/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.AutoTransferHandler;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.TransferRecipeCategory;
import me.shedaniel.rei.api.widgets.Button;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.toast.CopyRecipeIdentifierToast;
import me.shedaniel.rei.gui.widget.LateRenderable;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ClientHelperImpl;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class InternalWidgets {
    private InternalWidgets() {
    }

    public static Widget createAutoCraftingButtonWidget(Rectangle displayBounds, Rectangle rectangle, String text, final Supplier<RecipeDisplay> displaySupplier, List<Widget> setupDisplay, RecipeCategory<?> category) {
        class_465<?> handledScreen = ScreenHelper.getLastHandledScreen();
        boolean[] visible = new boolean[]{false};
        List[] errorTooltip = new List[]{null};
        final Button autoCraftingButton = Widgets.createButton(rectangle, text).focusable(false).onClick(button -> {
            AutoTransferHandler.Context context = AutoTransferHandler.Context.create(true, handledScreen, (RecipeDisplay)displaySupplier.get());
            for (AutoTransferHandler autoTransferHandler : RecipeHelper.getInstance().getSortedAutoCraftingHandler()) {
                try {
                    AutoTransferHandler.Result result = autoTransferHandler.handle(context);
                    if (!result.isSuccessful()) continue;
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            class_310.method_1551().method_1507((class_437)handledScreen);
            ScreenHelper.getLastOverlay().init();
        }).onRender(button -> {
            button.setEnabled(false);
            ArrayList error = null;
            int color = 0;
            visible[0] = false;
            IntList redSlots = null;
            AutoTransferHandler.Context context = AutoTransferHandler.Context.create(false, handledScreen, (RecipeDisplay)displaySupplier.get());
            for (AutoTransferHandler autoTransferHandler : RecipeHelper.getInstance().getSortedAutoCraftingHandler()) {
                try {
                    AutoTransferHandler.Result result = autoTransferHandler.handle(context);
                    if (result.isApplicable()) {
                        visible[0] = true;
                    }
                    if (result.isSuccessful()) {
                        button.setEnabled(true);
                        error = null;
                        color = 0;
                        redSlots = null;
                        break;
                    }
                    if (!result.isApplicable()) continue;
                    if (error == null) {
                        error = Lists.newArrayList();
                    }
                    error.add(result.getErrorKey());
                    color = result.getColor();
                    if (result.getIntegers() == null || result.getIntegers().isEmpty()) continue;
                    redSlots = result.getIntegers();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!visible[0]) {
                button.setEnabled(false);
                if (error == null) {
                    error = Lists.newArrayList();
                } else {
                    error.clear();
                }
                error.add("error.rei.no.handlers.applicable");
            }
            if ((button.containsMouse(PointHelper.ofMouse()) || button.isFocused()) && category instanceof TransferRecipeCategory && redSlots != null) {
                ((TransferRecipeCategory)category).renderRedSlots(setupDisplay, displayBounds, (RecipeDisplay)displaySupplier.get(), redSlots);
            }
            List list = errorTooltip[0] = error == null || error.isEmpty() ? null : Lists.newArrayList();
            if (errorTooltip[0] != null) {
                for (String s : error) {
                    if (!errorTooltip[0].stream().noneMatch(ss -> ss.equalsIgnoreCase(s))) continue;
                    errorTooltip[0].add(s);
                }
            }
            button.setTint(color);
        }).textColor((button, mouse) -> {
            if (!visible[0]) {
                return 0xA0A0A0;
            }
            if (button.isEnabled() && (button.containsMouse((Point)mouse) || button.isFocused())) {
                return 0xFFFFA0;
            }
            return 0xE0E0E0;
        }).textureId((button, mouse) -> !visible[0] ? 0 : ((button.containsMouse((Point)mouse) || button.isFocused()) && button.isEnabled() ? 4 : 1)).tooltipSupplier(button -> {
            String str = "";
            if (errorTooltip[0] == null) {
                str = ((Boolean)((ClientHelperImpl)ClientHelper.getInstance()).isYog.method_15332()).booleanValue() ? str + class_1074.method_4662((String)"text.auto_craft.move_items.yog", (Object[])new Object[0]) : str + class_1074.method_4662((String)"text.auto_craft.move_items", (Object[])new Object[0]);
            } else {
                if (errorTooltip[0].size() > 1) {
                    str = str + class_124.field_1061.toString() + class_1074.method_4662((String)"error.rei.multi.errors", (Object[])new Object[0]) + "\n";
                }
                str = str + CollectionUtils.mapAndJoinToString(errorTooltip[0], s -> class_124.field_1061.toString() + (errorTooltip[0].size() > 1 ? "- " : "") + class_1074.method_4662((String)s, (Object[])new Object[0]), "\n");
            }
            if (class_310.method_1551().field_1690.field_1827) {
                str = str + (((RecipeDisplay)displaySupplier.get()).getRecipeLocation().isPresent() ? class_1074.method_4662((String)"text.rei.recipe_id", (Object[])new Object[]{class_124.field_1080.toString(), ((RecipeDisplay)displaySupplier.get()).getRecipeLocation().get().toString()}) : "");
            }
            return str;
        });
        return new WidgetWithBounds(){

            @Override
            @NotNull
            public Rectangle getBounds() {
                return autoCraftingButton.getBounds();
            }

            public List<? extends class_364> method_25396() {
                return Collections.singletonList(autoCraftingButton);
            }

            public void method_25394(int mouseX, int mouseY, float delta) {
                autoCraftingButton.method_25394(mouseX, mouseY, delta);
            }

            public boolean method_25404(int int_1, int int_2, int int_3) {
                if (((RecipeDisplay)displaySupplier.get()).getRecipeLocation().isPresent() && ConfigObject.getInstance().getCopyRecipeIdentifierKeybind().matchesKey(int_1, int_2) && this.containsMouse(PointHelper.ofMouse())) {
                    this.minecraft.field_1774.method_1455(((RecipeDisplay)displaySupplier.get()).getRecipeLocation().get().toString());
                    if (ConfigObject.getInstance().isToastDisplayedOnCopyIdentifier()) {
                        CopyRecipeIdentifierToast.addToast(class_1074.method_4662((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), class_1074.method_4662((String)"msg.rei.recipe_id_details", (Object[])new Object[]{((RecipeDisplay)displaySupplier.get()).getRecipeLocation().get().toString()}));
                    }
                    return true;
                }
                return super.method_25404(int_1, int_2, int_3);
            }
        };
    }

    public static WidgetWithBounds wrapLateRenderable(WidgetWithBounds widget) {
        return new LateRenderableWidgetWithBounds(widget);
    }

    public static WidgetWithBounds wrapTranslate(WidgetWithBounds widget, float x, float y, float z) {
        return new WidgetWithBoundsWithTranslate(widget, x, y, z);
    }

    public static Widget wrapLateRenderable(Widget widget) {
        return new LateRenderableWidget(widget);
    }

    public static Widget mergeWidgets(Widget widget1, Widget widget2) {
        return new MergedWidget(widget2, widget1);
    }

    private static class WidgetWithBoundsWithTranslate
    extends WidgetWithBounds
    implements LateRenderable {
        private final WidgetWithBounds widget;
        private final float x;
        private final float y;
        private final float z;

        public WidgetWithBoundsWithTranslate(WidgetWithBounds widget, float x, float y, float z) {
            this.widget = widget;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        @NotNull
        public Rectangle getBounds() {
            return this.widget.getBounds();
        }

        public void method_25394(int mouseX, int mouseY, float delta) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)this.x, (float)this.y, (float)this.z);
            this.widget.setZ(this.getZ());
            this.widget.method_25394(mouseX, mouseY, delta);
            RenderSystem.popMatrix();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return this.widget.containsMouse(mouseX, mouseY);
        }

        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.widget);
        }

        public boolean method_25401(double mouseX, double mouseY, double amount) {
            return this.widget.method_25401(mouseX, mouseY, amount);
        }
    }

    private static class LateRenderableWidgetWithBounds
    extends WidgetWithBounds
    implements LateRenderable {
        private final WidgetWithBounds widget;

        private LateRenderableWidgetWithBounds(WidgetWithBounds widget) {
            this.widget = widget;
        }

        @Override
        @NotNull
        public Rectangle getBounds() {
            return this.widget.getBounds();
        }

        public void method_25394(int mouseX, int mouseY, float delta) {
            this.widget.setZ(this.getZ());
            this.widget.method_25394(mouseX, mouseY, delta);
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return this.widget.containsMouse(mouseX, mouseY);
        }

        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.widget);
        }

        public boolean method_25401(double mouseX, double mouseY, double amount) {
            return this.widget.method_25401(mouseX, mouseY, amount);
        }
    }

    private static class LateRenderableWidget
    extends Widget
    implements LateRenderable {
        private final Widget widget;

        private LateRenderableWidget(Widget widget) {
            this.widget = widget;
        }

        public void method_25394(int mouseX, int mouseY, float delta) {
            this.widget.setZ(this.getZ());
            this.widget.method_25394(mouseX, mouseY, delta);
        }

        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.widget);
        }

        public boolean method_25401(double mouseX, double mouseY, double amount) {
            return this.widget.method_25401(mouseX, mouseY, amount);
        }
    }

    private static class MergedWidget
    extends Widget {
        private final List<Widget> widgets;

        public MergedWidget(Widget widget1, Widget widget2) {
            this.widgets = Lists.newArrayList((Object[])new Widget[]{Objects.requireNonNull(widget1), Objects.requireNonNull(widget2)});
        }

        public void method_25394(int mouseX, int mouseY, float delta) {
            for (Widget widget : this.widgets) {
                widget.setZ(this.getZ());
                widget.method_25394(mouseX, mouseY, delta);
            }
        }

        public List<? extends class_364> method_25396() {
            return this.widgets;
        }

        public boolean method_25401(double mouseX, double mouseY, double amount) {
            for (Widget widget : this.widgets) {
                if (!widget.method_25401(mouseX, mouseY, amount)) continue;
                return true;
            }
            return false;
        }
    }
}

