/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.plugins.REIPluginV0;
import me.shedaniel.rei.api.widgets.Panel;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.impl.ClientHelperImpl;
import me.shedaniel.rei.impl.RenderingEntry;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.listeners.ContainerScreenHooks;
import me.shedaniel.rei.plugin.DefaultPotionEffectExclusionZones;
import me.shedaniel.rei.plugin.DefaultRecipeBookExclusionZones;
import me.shedaniel.rei.plugin.beacon.DefaultBeaconBaseCategory;
import me.shedaniel.rei.plugin.beacon.DefaultBeaconBaseDisplay;
import me.shedaniel.rei.plugin.blasting.DefaultBlastingDisplay;
import me.shedaniel.rei.plugin.brewing.DefaultBrewingCategory;
import me.shedaniel.rei.plugin.brewing.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.campfire.DefaultCampfireCategory;
import me.shedaniel.rei.plugin.campfire.DefaultCampfireDisplay;
import me.shedaniel.rei.plugin.composting.DefaultCompostingCategory;
import me.shedaniel.rei.plugin.composting.DefaultCompostingDisplay;
import me.shedaniel.rei.plugin.cooking.DefaultCookingCategory;
import me.shedaniel.rei.plugin.crafting.DefaultCraftingCategory;
import me.shedaniel.rei.plugin.crafting.DefaultCustomDisplay;
import me.shedaniel.rei.plugin.crafting.DefaultShapedDisplay;
import me.shedaniel.rei.plugin.crafting.DefaultShapelessDisplay;
import me.shedaniel.rei.plugin.fuel.DefaultFuelCategory;
import me.shedaniel.rei.plugin.fuel.DefaultFuelDisplay;
import me.shedaniel.rei.plugin.information.DefaultInformationCategory;
import me.shedaniel.rei.plugin.information.DefaultInformationDisplay;
import me.shedaniel.rei.plugin.smelting.DefaultSmeltingDisplay;
import me.shedaniel.rei.plugin.smoking.DefaultSmokingDisplay;
import me.shedaniel.rei.plugin.stonecutting.DefaultStoneCuttingCategory;
import me.shedaniel.rei.plugin.stonecutting.DefaultStoneCuttingDisplay;
import me.shedaniel.rei.plugin.stripping.DefaultStrippingCategory;
import me.shedaniel.rei.plugin.stripping.DefaultStrippingDisplay;
import me.shedaniel.rei.plugin.stripping.DummyAxeItem;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2609;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3871;
import net.minecraft.class_3873;
import net.minecraft.class_3874;
import net.minecraft.class_3920;
import net.minecraft.class_3962;
import net.minecraft.class_3975;
import net.minecraft.class_465;
import net.minecraft.class_472;
import net.minecraft.class_479;
import net.minecraft.class_485;
import net.minecraft.class_490;
import net.minecraft.class_518;
import org.jetbrains.annotations.Nullable;

public class DefaultPlugin
implements REIPluginV0 {
    public static final class_2960 CRAFTING = new class_2960("minecraft", "plugins/crafting");
    public static final class_2960 SMELTING = new class_2960("minecraft", "plugins/smelting");
    public static final class_2960 SMOKING = new class_2960("minecraft", "plugins/smoking");
    public static final class_2960 BLASTING = new class_2960("minecraft", "plugins/blasting");
    public static final class_2960 CAMPFIRE = new class_2960("minecraft", "plugins/campfire");
    public static final class_2960 STONE_CUTTING = new class_2960("minecraft", "plugins/stone_cutting");
    public static final class_2960 STRIPPING = new class_2960("minecraft", "plugins/stripping");
    public static final class_2960 BREWING = new class_2960("minecraft", "plugins/brewing");
    public static final class_2960 PLUGIN = new class_2960("roughlyenoughitems", "default_plugin");
    public static final class_2960 COMPOSTING = new class_2960("minecraft", "plugins/composting");
    public static final class_2960 FUEL = new class_2960("minecraft", "plugins/fuel");
    public static final class_2960 BEACON = new class_2960("roughlyenoughitems", "plugins/beacon");
    public static final class_2960 INFO = new class_2960("roughlyenoughitems", "plugins/information");
    private static final class_2960 DISPLAY_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/display.png");
    private static final class_2960 DISPLAY_TEXTURE_DARK = new class_2960("roughlyenoughitems", "textures/gui/display_dark.png");
    private static final List<DefaultBrewingDisplay> BREWING_DISPLAYS = Lists.newArrayList();
    private static final List<DefaultInformationDisplay> INFO_DISPLAYS = Lists.newArrayList();

    public static class_2960 getDisplayTexture() {
        return REIHelper.getInstance().isDarkThemeEnabled() ? DISPLAY_TEXTURE_DARK : DISPLAY_TEXTURE;
    }

    public static void registerBrewingDisplay(DefaultBrewingDisplay display) {
        BREWING_DISPLAYS.add(display);
    }

    public static void registerInfoDisplay(DefaultInformationDisplay display) {
        INFO_DISPLAYS.add(display);
    }

    @Override
    public class_2960 getPluginIdentifier() {
        return PLUGIN;
    }

    @Override
    public void preRegister() {
        INFO_DISPLAYS.clear();
    }

    @Override
    public void registerEntries(EntryRegistry entryRegistry) {
        if (!ConfigObject.getInstance().isLoadingDefaultPlugin()) {
            return;
        }
        for (class_1792 item : class_2378.field_11142) {
            List<class_1799> stacks = null;
            try {
                stacks = entryRegistry.appendStacksForItem(item);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stacks != null) {
                for (class_1799 stack : entryRegistry.appendStacksForItem(item)) {
                    entryRegistry.registerEntry(EntryStack.create(stack));
                }
                continue;
            }
            entryRegistry.registerEntry(EntryStack.create((class_1935)item));
        }
        EntryStack stack = EntryStack.create((class_1935)class_1802.field_8598);
        ArrayList<EntryStack> enchantments = new ArrayList<EntryStack>();
        for (class_1887 enchantment : class_2378.field_11160) {
            for (int i = enchantment.method_8187(); i <= enchantment.method_8183(); ++i) {
                HashMap<class_1887, Integer> map = new HashMap<class_1887, Integer>();
                map.put(enchantment, i);
                class_1799 itemStack = new class_1799((class_1935)class_1802.field_8598);
                class_1890.method_8214(map, (class_1799)itemStack);
                enchantments.add(EntryStack.create(itemStack).setting(EntryStack.Settings.CHECK_TAGS, EntryStack.Settings.TRUE));
            }
        }
        entryRegistry.queueRegisterEntryAfter(stack, enchantments);
        for (class_3611 fluid : class_2378.field_11154) {
            if (fluid.method_15785().method_15769() || !fluid.method_15785().method_15771()) continue;
            entryRegistry.registerEntry(EntryStack.create(fluid));
        }
        entryRegistry.registerEntry(new RenderingEntry(){
            private class_2960 id = new class_2960("roughlyenoughitems", "textures/gui/kirb.png");

            @Override
            public void render(Rectangle bounds, int mouseX, int mouseY, float delta) {
                class_310.method_1551().method_1531().method_22813(this.id);
                1.method_25295((int)bounds.x, (int)bounds.getMaxX(), (int)bounds.y, (int)bounds.getMaxY(), (int)this.method_25305(), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            }

            @Override
            public boolean isEmpty() {
                return (Boolean)((ClientHelperImpl)ClientHelper.getInstance()).isAprilFools.method_15332() == false;
            }

            @Override
            @Nullable
            public Tooltip getTooltip(Point point) {
                return Tooltip.create("Kibby");
            }
        });
    }

    @Override
    public void registerPluginCategories(RecipeHelper recipeHelper) {
        if (!ConfigObject.getInstance().isLoadingDefaultPlugin()) {
            return;
        }
        recipeHelper.registerCategory(new DefaultCraftingCategory());
        recipeHelper.registerCategory(new DefaultCookingCategory(SMELTING, EntryStack.create((class_1935)class_1802.field_8732), "category.rei.smelting"));
        recipeHelper.registerCategory(new DefaultCookingCategory(SMOKING, EntryStack.create((class_1935)class_1802.field_16309), "category.rei.smoking"));
        recipeHelper.registerCategory(new DefaultCookingCategory(BLASTING, EntryStack.create((class_1935)class_1802.field_16306), "category.rei.blasting"));
        recipeHelper.registerCategory(new DefaultCampfireCategory());
        recipeHelper.registerCategory(new DefaultStoneCuttingCategory());
        recipeHelper.registerCategory(new DefaultFuelCategory());
        recipeHelper.registerCategory(new DefaultBrewingCategory());
        recipeHelper.registerCategory(new DefaultCompostingCategory());
        recipeHelper.registerCategory(new DefaultStrippingCategory());
        recipeHelper.registerCategory(new DefaultBeaconBaseCategory());
    }

    @Override
    public void registerRecipeDisplays(RecipeHelper recipeHelper) {
        if (!ConfigObject.getInstance().isLoadingDefaultPlugin()) {
            return;
        }
        recipeHelper.registerRecipes(CRAFTING, class_1867.class, DefaultShapelessDisplay::new);
        recipeHelper.registerRecipes(CRAFTING, class_1869.class, DefaultShapedDisplay::new);
        recipeHelper.registerRecipes(SMELTING, class_3861.class, DefaultSmeltingDisplay::new);
        recipeHelper.registerRecipes(SMOKING, class_3862.class, DefaultSmokingDisplay::new);
        recipeHelper.registerRecipes(BLASTING, class_3859.class, DefaultBlastingDisplay::new);
        recipeHelper.registerRecipes(CAMPFIRE, class_3920.class, DefaultCampfireDisplay::new);
        recipeHelper.registerRecipes(STONE_CUTTING, class_3975.class, DefaultStoneCuttingDisplay::new);
        for (DefaultBrewingDisplay defaultBrewingDisplay : BREWING_DISPLAYS) {
            recipeHelper.registerDisplay(defaultBrewingDisplay);
        }
        for (Map.Entry entry : class_2609.method_11196().entrySet()) {
            recipeHelper.registerDisplay(new DefaultFuelDisplay(EntryStack.create((class_1935)entry.getKey()), (Integer)entry.getValue()));
        }
        List<EntryStack> arrowStack = Collections.singletonList(EntryStack.create((class_1935)class_1802.field_8107));
        for (EntryStack entry : EntryRegistry.getInstance().getStacksList()) {
            int i;
            if (entry.getItem() != class_1802.field_8150) continue;
            ArrayList<List<EntryStack>> input = new ArrayList<List<EntryStack>>();
            for (i = 0; i < 4; ++i) {
                input.add(arrowStack);
            }
            input.add(Collections.singletonList(EntryStack.create(entry.getItemStack())));
            for (i = 0; i < 4; ++i) {
                input.add(arrowStack);
            }
            class_1799 outputStack = new class_1799((class_1935)class_1802.field_8087, 8);
            class_1844.method_8061((class_1799)outputStack, (class_1842)class_1844.method_8063((class_1799)entry.getItemStack()));
            class_1844.method_8056((class_1799)outputStack, (Collection)class_1844.method_8068((class_1799)entry.getItemStack()));
            List<EntryStack> output = Collections.singletonList(EntryStack.create(outputStack).addSetting(EntryStack.Settings.CHECK_TAGS, EntryStack.Settings.TRUE));
            recipeHelper.registerDisplay(new DefaultCustomDisplay(null, input, output));
        }
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        if (class_3962.field_17566.isEmpty()) {
            class_3962.method_17758();
        }
        for (Object2FloatMap.Entry entry : class_3962.field_17566.object2FloatEntrySet()) {
            if (!(entry.getFloatValue() > 0.0f)) continue;
            linkedHashMap.put(entry.getKey(), Float.valueOf(entry.getFloatValue()));
        }
        LinkedList stacks = new LinkedList(linkedHashMap.keySet());
        stacks.sort((first, second) -> (int)((((Float)map.get(first)).floatValue() - ((Float)map.get(second)).floatValue()) * 100.0f));
        for (int i = 0; i < stacks.size(); i += class_3532.method_15340((int)48, (int)1, (int)(stacks.size() - i))) {
            ArrayList thisStacks = Lists.newArrayList();
            for (int j = i; j < i + 48; ++j) {
                if (j >= stacks.size()) continue;
                thisStacks.add(stacks.get(j));
            }
            recipeHelper.registerDisplay(new DefaultCompostingDisplay(class_3532.method_15375((float)((float)i / 48.0f)), thisStacks, linkedHashMap, Lists.newArrayList(linkedHashMap.keySet()), new class_1799[]{new class_1799((class_1935)class_1802.field_8324)}));
        }
        DummyAxeItem.getStrippedBlocksMap().entrySet().stream().sorted(Comparator.comparing(b -> class_2378.field_11146.method_10221(b.getKey()))).forEach(set -> recipeHelper.registerDisplay(new DefaultStrippingDisplay(new class_1799((class_1935)set.getKey()), new class_1799((class_1935)set.getValue()))));
        recipeHelper.registerDisplay(new DefaultBeaconBaseDisplay(CollectionUtils.map(Lists.newArrayList((Iterable)class_3481.field_22275.method_15138()), class_1799::new)));
    }

    @Override
    public void postRegister() {
        RecipeHelper.getInstance().registerCategory(new DefaultInformationCategory());
        for (DefaultInformationDisplay display : INFO_DISPLAYS) {
            RecipeHelper.getInstance().registerDisplay(display);
        }
        long time = System.currentTimeMillis();
        for (EntryStack entryStack : EntryRegistry.getInstance().getStacksList()) {
            this.applyPotionTransformer(entryStack);
        }
        for (List list : RecipeHelper.getInstance().getAllRecipes().values()) {
            for (RecipeDisplay display : list) {
                for (List<EntryStack> entries : display.getInputEntries()) {
                    for (EntryStack stack : entries) {
                        this.applyPotionTransformer(stack);
                    }
                }
                for (EntryStack stack : display.getOutputEntries()) {
                    this.applyPotionTransformer(stack);
                }
            }
        }
        time = System.currentTimeMillis() - time;
        RoughlyEnoughItemsCore.LOGGER.info("Applied Check Tags for potion in %dms.", (Object)time);
    }

    private void applyPotionTransformer(EntryStack stack) {
        if (stack.getItem() instanceof class_1812) {
            stack.addSetting(EntryStack.Settings.CHECK_TAGS, EntryStack.Settings.TRUE);
        }
    }

    @Override
    public void registerBounds(DisplayHelper displayHelper) {
        if (!ConfigObject.getInstance().isLoadingDefaultPlugin()) {
            return;
        }
        BaseBoundsHandler baseBoundsHandler = BaseBoundsHandler.getInstance();
        baseBoundsHandler.registerExclusionZones(class_485.class, new DefaultPotionEffectExclusionZones());
        baseBoundsHandler.registerExclusionZones(class_518.class, new DefaultRecipeBookExclusionZones());
        baseBoundsHandler.registerExclusionZones(RecipeViewingScreen.class, () -> {
            Panel widget = ((RecipeViewingScreen)class_310.method_1551().field_1755).getWorkingStationsBaseWidget();
            if (widget == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(widget.getBounds().clone());
        });
        displayHelper.registerHandler(new DisplayHelper.DisplayBoundsHandler<class_465<?>>(){

            @Override
            public Class<?> getBaseSupportedClass() {
                return class_465.class;
            }

            @Override
            public Rectangle getLeftBounds(class_465<?> screen) {
                return new Rectangle(2, 0, ((ContainerScreenHooks)ScreenHelper.getLastHandledScreen()).rei_getContainerLeft() - 4, class_310.method_1551().method_22683().method_4502());
            }

            @Override
            public Rectangle getRightBounds(class_465<?> screen) {
                int startX = ((ContainerScreenHooks)ScreenHelper.getLastHandledScreen()).rei_getContainerLeft() + ((ContainerScreenHooks)ScreenHelper.getLastHandledScreen()).rei_getContainerWidth() + 2;
                return new Rectangle(startX, 0, class_310.method_1551().method_22683().method_4486() - startX - 2, class_310.method_1551().method_22683().method_4502());
            }

            @Override
            public float getPriority() {
                return -1.0f;
            }
        });
        displayHelper.registerHandler(new DisplayHelper.DisplayBoundsHandler<RecipeViewingScreen>(){

            @Override
            public Class<?> getBaseSupportedClass() {
                return RecipeViewingScreen.class;
            }

            @Override
            public Rectangle getLeftBounds(RecipeViewingScreen screen) {
                return new Rectangle(2, 0, screen.getBounds().x - 4, class_310.method_1551().method_22683().method_4502());
            }

            @Override
            public Rectangle getRightBounds(RecipeViewingScreen screen) {
                int startX = screen.getBounds().x + screen.getBounds().width + 2;
                return new Rectangle(startX, 0, class_310.method_1551().method_22683().method_4486() - startX - 2, class_310.method_1551().method_22683().method_4502());
            }

            @Override
            public float getPriority() {
                return -1.0f;
            }
        });
        displayHelper.registerHandler(new DisplayHelper.DisplayBoundsHandler<VillagerRecipeViewingScreen>(){

            @Override
            public Class<?> getBaseSupportedClass() {
                return VillagerRecipeViewingScreen.class;
            }

            @Override
            public Rectangle getLeftBounds(VillagerRecipeViewingScreen screen) {
                return new Rectangle(2, 0, screen.bounds.x - 4, class_310.method_1551().method_22683().method_4502());
            }

            @Override
            public Rectangle getRightBounds(VillagerRecipeViewingScreen screen) {
                int startX = screen.bounds.x + screen.bounds.width + 2;
                return new Rectangle(startX, 0, class_310.method_1551().method_22683().method_4486() - startX - 2, class_310.method_1551().method_22683().method_4502());
            }

            @Override
            public float getPriority() {
                return -1.0f;
            }
        });
    }

    @Override
    public void registerOthers(RecipeHelper recipeHelper) {
        if (!ConfigObject.getInstance().isLoadingDefaultPlugin()) {
            return;
        }
        recipeHelper.registerWorkingStations(CRAFTING, EntryStack.create((class_1935)class_1802.field_8465));
        recipeHelper.registerWorkingStations(SMELTING, EntryStack.create((class_1935)class_1802.field_8732));
        recipeHelper.registerWorkingStations(SMOKING, EntryStack.create((class_1935)class_1802.field_16309));
        recipeHelper.registerWorkingStations(BLASTING, EntryStack.create((class_1935)class_1802.field_16306));
        recipeHelper.registerWorkingStations(CAMPFIRE, EntryStack.create((class_1935)class_1802.field_17346));
        recipeHelper.registerWorkingStations(BREWING, EntryStack.create((class_1935)class_1802.field_8740));
        recipeHelper.registerWorkingStations(STONE_CUTTING, EntryStack.create((class_1935)class_1802.field_16305));
        recipeHelper.registerWorkingStations(COMPOSTING, EntryStack.create((class_1935)class_1802.field_17530));
        recipeHelper.registerWorkingStations(BEACON, EntryStack.create((class_1935)class_1802.field_8668));
        recipeHelper.removeAutoCraftButton(FUEL);
        recipeHelper.removeAutoCraftButton(COMPOSTING);
        recipeHelper.removeAutoCraftButton(BEACON);
        recipeHelper.removeAutoCraftButton(INFO);
        recipeHelper.registerScreenClickArea(new Rectangle(88, 32, 28, 23), class_479.class, CRAFTING);
        recipeHelper.registerScreenClickArea(new Rectangle(137, 29, 10, 13), class_490.class, CRAFTING);
        recipeHelper.registerScreenClickArea(new Rectangle(97, 16, 14, 30), class_472.class, BREWING);
        recipeHelper.registerScreenClickArea(new Rectangle(78, 32, 28, 23), class_3873.class, SMELTING);
        recipeHelper.registerScreenClickArea(new Rectangle(78, 32, 28, 23), class_3874.class, SMOKING);
        recipeHelper.registerScreenClickArea(new Rectangle(78, 32, 28, 23), class_3871.class, BLASTING);
    }

    @Override
    public int getPriority() {
        return -1;
    }
}

