/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.widgets.Button;
import me.shedaniel.rei.api.widgets.Panel;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.RecipeDisplayExporter;
import me.shedaniel.rei.gui.RecipeScreen;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.RecipeChoosePageWidget;
import me.shedaniel.rei.gui.widget.TabWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ClientHelperImpl;
import me.shedaniel.rei.impl.InternalWidgets;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.widgets.PanelWidget;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class RecipeViewingScreen
extends class_437
implements RecipeScreen {
    public static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private final List<Widget> preWidgets = Lists.newArrayList();
    private final List<Widget> widgets = Lists.newArrayList();
    private final Map<Rectangle, List<Widget>> recipeBounds = Maps.newHashMap();
    private final List<TabWidget> tabs = Lists.newArrayList();
    private final Map<RecipeCategory<?>, List<RecipeDisplay>> categoriesMap;
    private final List<RecipeCategory<?>> categories;
    private final RecipeCategory<RecipeDisplay> selectedCategory;
    public int guiWidth;
    public int guiHeight;
    public int page;
    public int categoryPages = -1;
    public int largestWidth;
    public int largestHeight;
    public boolean choosePageActivated = false;
    public RecipeChoosePageWidget recipeChoosePageWidget;
    private int tabsPerPage = 5;
    private Rectangle bounds;
    @Nullable
    private Panel workingStationsBaseWidget;
    private Button recipeBack;
    private Button recipeNext;
    private Button categoryBack;
    private Button categoryNext;
    private EntryStack ingredientStackToNotice = EntryStack.empty();
    private EntryStack resultStackToNotice = EntryStack.empty();

    public RecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> categoriesMap, @Nullable class_2960 category) {
        super(class_333.field_18967);
        class_1041 window = class_310.method_1551().method_22683();
        this.bounds = new Rectangle(window.method_4486() / 2 - this.guiWidth / 2, window.method_4502() / 2 - this.guiHeight / 2, 176, 150);
        this.categoriesMap = categoriesMap;
        this.categories = Lists.newArrayList(categoriesMap.keySet());
        RecipeCategory<?> selected = this.categories.get(0);
        if (category != null) {
            for (RecipeCategory<?> recipeCategory : this.categories) {
                if (!recipeCategory.getIdentifier().equals((Object)category)) continue;
                selected = recipeCategory;
                break;
            }
        }
        this.selectedCategory = selected;
    }

    @ApiStatus.Internal
    static void transformIngredientNotice(List<Widget> setupDisplay, EntryStack noticeStack) {
        RecipeViewingScreen.transformNotice(1, setupDisplay, noticeStack);
    }

    @ApiStatus.Internal
    static void transformResultNotice(List<Widget> setupDisplay, EntryStack noticeStack) {
        RecipeViewingScreen.transformNotice(2, setupDisplay, noticeStack);
    }

    private static void transformNotice(int marker, List<Widget> setupDisplay, EntryStack noticeStack) {
        if (noticeStack.isEmpty()) {
            return;
        }
        for (Widget widget : setupDisplay) {
            EntryStack stack;
            EntryWidget entry;
            if (!(widget instanceof EntryWidget) || (entry = (EntryWidget)widget).getNoticeMark() != marker || entry.entries().size() <= 1 || (stack = CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(entry.entries(), noticeStack)) == null) continue;
            entry.clearStacks();
            entry.entry(stack);
        }
    }

    @Override
    @ApiStatus.Internal
    public void addIngredientStackToNotice(EntryStack stack) {
        this.ingredientStackToNotice = stack;
    }

    @Override
    @ApiStatus.Internal
    public void addResultStackToNotice(EntryStack stack) {
        this.resultStackToNotice = stack;
    }

    @Override
    public class_2960 getCurrentCategory() {
        return this.selectedCategory.getIdentifier();
    }

    @Override
    public void recalculateCategoryPage() {
        this.categoryPages = -1;
    }

    @Nullable
    public Panel getWorkingStationsBaseWidget() {
        return this.workingStationsBaseWidget;
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (int_1 == 256 && this.choosePageActivated) {
            this.choosePageActivated = false;
            this.method_25426();
            return true;
        }
        if (int_1 == 258) {
            boolean boolean_1;
            boolean bl = boolean_1 = !RecipeViewingScreen.method_25442();
            if (!this.method_25407(boolean_1)) {
                this.method_25407(boolean_1);
            }
            return true;
        }
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.method_25404(int_1, int_2, int_3);
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesKey(int_1, int_2)) {
            if (this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
            return this.recipeNext.isEnabled();
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesKey(int_1, int_2)) {
            if (this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            }
            return this.recipeBack.isEnabled();
        }
        for (class_364 element : this.method_25396()) {
            if (!element.method_25404(int_1, int_2, int_3)) continue;
            return true;
        }
        if (int_1 == 256 || this.field_22787.field_1690.field_1822.method_1417(int_1, int_2)) {
            class_310.method_1551().method_1507(ScreenHelper.getLastHandledScreen());
            ScreenHelper.getLastOverlay().init();
            return true;
        }
        if (int_1 == 259) {
            if (ScreenHelper.hasLastRecipeScreen()) {
                this.field_22787.method_1507(ScreenHelper.getLastRecipeScreen());
            } else {
                this.field_22787.method_1507(ScreenHelper.getLastHandledScreen());
            }
            return true;
        }
        return super.method_25404(int_1, int_2, int_3);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25426() {
        super.method_25426();
        boolean isCompactTabs = ConfigObject.getInstance().isUsingCompactTabs();
        int tabSize = isCompactTabs ? 24 : 28;
        this.field_22786.clear();
        this.recipeBounds.clear();
        this.tabs.clear();
        this.preWidgets.clear();
        this.widgets.clear();
        this.largestWidth = this.field_22789 - 100;
        this.largestHeight = Math.max(this.field_22790 - 36, 100);
        int maxWidthDisplay = CollectionUtils.mapAndMax(this.getCurrentDisplayed(), this.selectedCategory::getDisplayWidth, Comparator.naturalOrder()).orElse(150);
        this.guiWidth = maxWidthDisplay + 20;
        this.guiHeight = class_3532.method_15357((double)class_3532.method_15350((double)((double)(this.selectedCategory.getDisplayHeight() + 4) * (double)(this.getRecipesPerPage() + 1) + 36.0), (double)100.0, (double)this.largestHeight));
        this.tabsPerPage = Math.max(5, class_3532.method_15357((double)(((double)this.guiWidth - 20.0) / (double)tabSize)));
        if (this.categoryPages == -1) {
            this.categoryPages = Math.max(0, this.categories.indexOf(this.selectedCategory) / this.tabsPerPage);
        }
        this.bounds = new Rectangle(this.field_22789 / 2 - this.guiWidth / 2, this.field_22790 / 2 - this.guiHeight / 2, this.guiWidth, this.guiHeight);
        this.page = class_3532.method_15340((int)this.page, (int)0, (int)(this.getTotalPages(this.selectedCategory) - 1));
        this.widgets.add(Widgets.createButton(new Rectangle(this.bounds.x + 2, this.bounds.y - 16, 10, 10), (class_2561)new class_2588("text.rei.left_arrow")).onClick(button -> {
            --this.categoryPages;
            if (this.categoryPages < 0) {
                this.categoryPages = class_3532.method_15386((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1;
            }
            this.method_25426();
        }).enabled(this.categories.size() > this.tabsPerPage));
        this.widgets.add(Widgets.createButton(new Rectangle(this.bounds.x + this.bounds.width - 12, this.bounds.y - 16, 10, 10), (class_2561)new class_2588("text.rei.right_arrow")).onClick(button -> {
            ++this.categoryPages;
            if (this.categoryPages > class_3532.method_15386((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1) {
                this.categoryPages = 0;
            }
            this.method_25426();
        }).enabled(this.categories.size() > this.tabsPerPage));
        this.categoryBack = Widgets.createButton(new Rectangle(this.bounds.getX() + 5, this.bounds.getY() + 5, 12, 12), (class_2561)new class_2588("text.rei.left_arrow")).onClick(button -> {
            int currentCategoryIndex = this.categories.indexOf(this.selectedCategory);
            if (--currentCategoryIndex < 0) {
                currentCategoryIndex = this.categories.size() - 1;
            }
            ClientHelperImpl.getInstance().openRecipeViewingScreen(this.categoriesMap, this.categories.get(currentCategoryIndex).getIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
        }).tooltipLine(class_1074.method_4662((String)"text.rei.previous_category", (Object[])new Object[0]));
        this.widgets.add(this.categoryBack);
        this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.getCenterX(), this.bounds.getY() + 7), (class_2561)new class_2585(this.selectedCategory.getCategoryName()), clickableLabelWidget -> ClientHelper.getInstance().executeViewAllRecipesKeyBind()).tooltipLine(class_1074.method_4662((String)"text.rei.view_all_categories", (Object[])new Object[0])));
        this.categoryNext = Widgets.createButton(new Rectangle(this.bounds.getMaxX() - 17, this.bounds.getY() + 5, 12, 12), (class_2561)new class_2588("text.rei.right_arrow")).onClick(button -> {
            int currentCategoryIndex = this.categories.indexOf(this.selectedCategory);
            if (++currentCategoryIndex >= this.categories.size()) {
                currentCategoryIndex = 0;
            }
            ClientHelperImpl.getInstance().openRecipeViewingScreen(this.categoriesMap, this.categories.get(currentCategoryIndex).getIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
        }).tooltipLine(class_1074.method_4662((String)"text.rei.next_category", (Object[])new Object[0]));
        this.widgets.add(this.categoryNext);
        this.categoryBack.setEnabled(this.categories.size() > 1);
        this.categoryNext.setEnabled(this.categories.size() > 1);
        this.recipeBack = Widgets.createButton(new Rectangle(this.bounds.getX() + 5, this.bounds.getY() + 19, 12, 12), (class_2561)new class_2588("text.rei.left_arrow")).onClick(button -> {
            --this.page;
            if (this.page < 0) {
                this.page = this.getTotalPages(this.selectedCategory) - 1;
            }
            this.method_25426();
        }).tooltipLine(class_1074.method_4662((String)"text.rei.previous_page", (Object[])new Object[0]));
        this.widgets.add(this.recipeBack);
        this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.getCenterX(), this.bounds.getY() + 21), class_333.field_18967, label -> {
            this.choosePageActivated = true;
            this.method_25426();
        }).onRender((matrices, label) -> {
            label.setText((class_2561)new class_2585(String.format("%d/%d", this.page + 1, this.getTotalPages(this.selectedCategory))));
            label.setClickable(this.categoriesMap.get(this.selectedCategory).size() > this.getRecipesPerPageByHeight());
        }).tooltipSupplier(label -> label.isClickable() ? class_1074.method_4662((String)"text.rei.choose_page", (Object[])new Object[0]) : null));
        this.recipeNext = Widgets.createButton(new Rectangle(this.bounds.getMaxX() - 17, this.bounds.getY() + 19, 12, 12), (class_2561)new class_2588("text.rei.right_arrow")).onClick(button -> {
            ++this.page;
            if (this.page >= this.getTotalPages(this.selectedCategory)) {
                this.page = 0;
            }
            this.method_25426();
        }).tooltipLine(class_1074.method_4662((String)"text.rei.next_page", (Object[])new Object[0]));
        this.widgets.add(this.recipeNext);
        this.recipeBack.setEnabled(this.categoriesMap.get(this.selectedCategory).size() > this.getRecipesPerPageByHeight());
        this.recipeNext.setEnabled(this.categoriesMap.get(this.selectedCategory).size() > this.getRecipesPerPageByHeight());
        int tabV = isCompactTabs ? 166 : 192;
        for (int i = 0; i < this.tabsPerPage; ++i) {
            int j = i + this.categoryPages * this.tabsPerPage;
            if (this.categories.size() <= j) continue;
            TabWidget tab = TabWidget.create(i, tabSize, this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.categoryPages * this.tabsPerPage, this.tabsPerPage) * tabSize / 2, this.bounds.y, 0, tabV, widget -> {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                if (widget.getId() + this.categoryPages * this.tabsPerPage == this.categories.indexOf(this.selectedCategory)) {
                    return false;
                }
                ClientHelperImpl.getInstance().openRecipeViewingScreen(this.categoriesMap, this.categories.get(widget.getId() + this.categoryPages * this.tabsPerPage).getIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
                return true;
            });
            this.tabs.add(tab);
            tab.setRenderer(this.categories.get(j), this.categories.get(j).getLogo(), this.categories.get(j).getCategoryName(), tab.getId() + this.categoryPages * this.tabsPerPage == this.categories.indexOf(this.selectedCategory));
        }
        Optional<ButtonAreaSupplier> supplier = RecipeHelper.getInstance().getAutoCraftButtonArea(this.selectedCategory);
        int recipeHeight = this.selectedCategory.getDisplayHeight();
        List<RecipeDisplay> currentDisplayed = this.getCurrentDisplayed();
        for (int i = 0; i < currentDisplayed.size(); ++i) {
            RecipeDisplay display = currentDisplayed.get(i);
            Supplier<RecipeDisplay> displaySupplier = () -> display;
            int displayWidth = this.selectedCategory.getDisplayWidth(displaySupplier.get());
            Rectangle displayBounds = new Rectangle(this.getBounds().getCenterX() - displayWidth / 2, this.getBounds().y - 2 + 36 + recipeHeight * i + 4 * i, displayWidth, recipeHeight);
            List<Widget> setupDisplay = this.selectedCategory.setupDisplay(display, displayBounds);
            RecipeViewingScreen.transformIngredientNotice(setupDisplay, this.ingredientStackToNotice);
            RecipeViewingScreen.transformResultNotice(setupDisplay, this.resultStackToNotice);
            this.recipeBounds.put(displayBounds, setupDisplay);
            this.widgets.addAll(setupDisplay);
            if (!supplier.isPresent() || supplier.get().get(displayBounds) == null) continue;
            this.widgets.add(InternalWidgets.createAutoCraftingButtonWidget(displayBounds, supplier.get().get(displayBounds), (class_2561)new class_2585(supplier.get().getButtonText()), displaySupplier, setupDisplay, this.selectedCategory));
        }
        this.recipeChoosePageWidget = this.choosePageActivated ? new RecipeChoosePageWidget(this, this.page, this.getTotalPages(this.selectedCategory)) : null;
        this.workingStationsBaseWidget = null;
        List<List<EntryStack>> workingStations = RecipeHelper.getInstance().getWorkingStations(this.selectedCategory.getIdentifier());
        if (!workingStations.isEmpty()) {
            int hh = class_3532.method_15375((float)((float)(this.bounds.height - 16) / 18.0f));
            int actualHeight = Math.min(hh, workingStations.size());
            int innerWidth = class_3532.method_15386((float)((float)workingStations.size() / (float)hh));
            int xx = this.bounds.x - (8 + innerWidth * 16) + 6;
            int yy = this.bounds.y + 16;
            this.workingStationsBaseWidget = Widgets.createCategoryBase(new Rectangle(xx - 5, yy - 5, 15 + innerWidth * 16, 10 + actualHeight * 16));
            this.preWidgets.add(this.workingStationsBaseWidget);
            this.preWidgets.add(Widgets.createSlotBase(new Rectangle(xx - 1, yy - 1, innerWidth * 16 + 2, actualHeight * 16 + 2)));
            int index = 0;
            List<class_5250> list = Collections.singletonList(new class_2588("text.rei.working_station").method_27692(class_124.field_1054));
            xx += (innerWidth - 1) * 16;
            for (List<EntryStack> workingStation : workingStations) {
                this.preWidgets.add(new WorkstationSlotWidget(xx, yy, CollectionUtils.map(workingStation, stack -> stack.copy().setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, s -> list))));
                yy += 16;
                if (++index < hh) continue;
                index = 0;
                yy = this.bounds.y + 16;
                xx -= 16;
            }
        }
        this.field_22786.addAll(this.tabs);
        this.field_22786.add(ScreenHelper.getLastOverlay(true, false));
        this.field_22786.addAll(this.widgets);
        this.field_22786.addAll(this.preWidgets);
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public List<RecipeDisplay> getCurrentDisplayed() {
        ArrayList list = Lists.newArrayList();
        int recipesPerPage = this.getRecipesPerPage();
        for (int i = 0; i <= recipesPerPage; ++i) {
            if (this.page * (recipesPerPage + 1) + i >= this.categoriesMap.get(this.selectedCategory).size()) continue;
            list.add(this.categoriesMap.get(this.selectedCategory).get(this.page * (recipesPerPage + 1) + i));
        }
        return list;
    }

    public RecipeCategory<RecipeDisplay> getSelectedCategory() {
        return this.selectedCategory;
    }

    public int getPage() {
        return this.page;
    }

    public int getCategoryPage() {
        return this.categoryPages;
    }

    private int getRecipesPerPage() {
        if (this.selectedCategory.getFixedRecipesPerPage() > 0) {
            return this.selectedCategory.getFixedRecipesPerPage() - 1;
        }
        int height = this.selectedCategory.getDisplayHeight();
        return class_3532.method_15340((int)(class_3532.method_15357((double)(((double)this.largestHeight - 36.0) / ((double)height + 4.0))) - 1), (int)0, (int)Math.min(ConfigObject.getInstance().getMaxRecipePerPage() - 1, this.selectedCategory.getMaximumRecipePerPage() - 1));
    }

    private int getRecipesPerPageByHeight() {
        int height = this.selectedCategory.getDisplayHeight();
        return class_3532.method_15340((int)class_3532.method_15357((double)(((double)this.guiHeight - 36.0) / ((double)height + 4.0))), (int)0, (int)Math.min(ConfigObject.getInstance().getMaxRecipePerPage() - 1, this.selectedCategory.getMaximumRecipePerPage() - 1));
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        for (Widget widget : this.preWidgets) {
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
        PanelWidget.render(matrices, this.bounds, -1);
        if (REIHelper.getInstance().isDarkThemeEnabled()) {
            RecipeViewingScreen.method_25294((class_4587)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)-12566464);
            RecipeViewingScreen.method_25294((class_4587)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 19), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 30), (int)-12566464);
        } else {
            RecipeViewingScreen.method_25294((class_4587)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)-6381922);
            RecipeViewingScreen.method_25294((class_4587)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 19), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 31), (int)-6381922);
        }
        for (TabWidget tab : this.tabs) {
            if (tab.isSelected()) continue;
            tab.method_25394(matrices, mouseX, mouseY, delta);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        for (Widget widget : this.widgets) {
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (TabWidget tab : this.tabs) {
            if (!tab.isSelected()) continue;
            tab.method_25394(matrices, mouseX, mouseY, delta);
        }
        ScreenHelper.getLastOverlay().method_25394(matrices, mouseX, mouseY, delta);
        ScreenHelper.getLastOverlay().lateRender(matrices, mouseX, mouseY, delta);
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesCurrentKey()) {
            for (Map.Entry<Rectangle, List<Widget>> entry : this.recipeBounds.entrySet()) {
                Rectangle bounds = entry.getKey();
                this.method_25304(470);
                if (bounds.contains(mouseX, mouseY)) {
                    this.method_25296(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 1744822402, 1744822402);
                    class_2588 text = new class_2588("text.rei.release_export", new Object[]{export.getLocalizedName()});
                    class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
                    matrices.method_22903();
                    matrices.method_22904(0.0, 0.0, 480.0);
                    class_1159 matrix4f = matrices.method_23760().method_23761();
                    this.field_22793.method_22942((class_2561)text, (float)bounds.getCenterX() - (float)this.field_22793.method_27525((class_2561)text) / 2.0f, (float)bounds.getCenterY() - 4.5f, -16777216, false, matrix4f, (class_4597)immediate, false, 0, 0xF000F0);
                    immediate.method_22993();
                    matrices.method_22909();
                } else {
                    this.method_25296(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 0x67FFFFFF, 0x67FFFFFF);
                }
                this.method_25304(0);
            }
        }
        if (this.choosePageActivated) {
            this.method_25304(500);
            this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
            this.method_25304(0);
            this.recipeChoosePageWidget.method_25394(matrices, mouseX, mouseY, delta);
        }
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesKey(keyCode, scanCode)) {
            for (Map.Entry<Rectangle, List<Widget>> entry : this.recipeBounds.entrySet()) {
                Rectangle bounds = entry.getKey();
                if (!bounds.contains(PointHelper.ofMouse())) continue;
                RecipeDisplayExporter.exportRecipeDisplay(bounds, entry.getValue());
                break;
            }
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public int getTotalPages(RecipeCategory<RecipeDisplay> category) {
        return class_3532.method_15384((double)((double)this.categoriesMap.get(category).size() / (double)(this.getRecipesPerPage() + 1)));
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean method_25400(char char_1, int int_1) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.method_25400(char_1, int_1);
        }
        for (class_364 listener : this.method_25396()) {
            if (!listener.method_25400(char_1, int_1)) continue;
            return true;
        }
        return super.method_25400(char_1, int_1);
    }

    public boolean method_25403(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.method_25403(double_1, double_2, int_1, double_3, double_4);
        }
        return super.method_25403(double_1, double_2, int_1, double_3, double_4);
    }

    public boolean method_25406(double double_1, double double_2, int int_1) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.method_25406(double_1, double_2, int_1);
        }
        return super.method_25406(double_1, double_2, int_1);
    }

    public boolean method_25401(double i, double j, double amount) {
        for (class_364 listener : this.method_25396()) {
            if (!listener.method_25401(i, j, amount)) continue;
            return true;
        }
        if (this.getBounds().contains(PointHelper.ofMouse())) {
            if (amount > 0.0 && this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            } else if (amount < 0.0 && this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
        }
        if (new Rectangle(this.bounds.x, this.bounds.y - 28, this.bounds.width, 28).contains(PointHelper.ofMouse())) {
            if (amount > 0.0 && this.categoryBack.isEnabled()) {
                this.categoryBack.onClick();
            } else if (amount < 0.0 && this.categoryNext.isEnabled()) {
                this.categoryNext.onClick();
            }
        }
        return super.method_25401(i, j, amount);
    }

    public boolean method_25402(double double_1, double double_2, int int_1) {
        if (this.choosePageActivated) {
            if (this.recipeChoosePageWidget.containsMouse(double_1, double_2)) {
                return this.recipeChoosePageWidget.method_25402(double_1, double_2, int_1);
            }
            this.choosePageActivated = false;
            this.method_25426();
            return false;
        }
        for (class_364 entry : this.method_25396()) {
            if (!entry.method_25402(double_1, double_2, int_1)) continue;
            this.method_25395(entry);
            if (int_1 == 0) {
                this.method_25398(true);
            }
            return true;
        }
        return false;
    }

    public class_364 method_25399() {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget;
        }
        return super.method_25399();
    }

    public static class WorkstationSlotWidget
    extends EntryWidget {
        public WorkstationSlotWidget(int x, int y, List<EntryStack> widgets) {
            super(new Point(x, y));
            this.entries(widgets);
            this.noBackground();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return this.getInnerBounds().contains(mouseX, mouseY);
        }
    }
}

