/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.widgets.Button;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.RecipeScreen;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.widget.ScrollingContainer;
import me.shedaniel.rei.gui.widget.TabWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ClientHelperImpl;
import me.shedaniel.rei.impl.InternalWidgets;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class VillagerRecipeViewingScreen
extends class_437
implements RecipeScreen {
    private final Map<RecipeCategory<?>, List<RecipeDisplay>> categoryMap;
    private final List<RecipeCategory<?>> categories;
    private final List<Widget> widgets = Lists.newArrayList();
    private final List<Button> buttonList = Lists.newArrayList();
    private final List<RecipeEntry> recipeRenderers = Lists.newArrayList();
    private final List<TabWidget> tabs = Lists.newArrayList();
    public Rectangle bounds;
    public Rectangle scrollListBounds;
    private int tabsPerPage = 8;
    private int selectedCategoryIndex = 0;
    private int selectedRecipeIndex = 0;
    private final ScrollingContainer scrolling = new ScrollingContainer(){

        @Override
        public Rectangle getBounds() {
            return new Rectangle(VillagerRecipeViewingScreen.this.scrollListBounds.x + 1, VillagerRecipeViewingScreen.this.scrollListBounds.y + 1, VillagerRecipeViewingScreen.this.scrollListBounds.width - 2, VillagerRecipeViewingScreen.this.scrollListBounds.height - 2);
        }

        @Override
        public int getMaxScrollHeight() {
            int i = 0;
            for (Button button : VillagerRecipeViewingScreen.this.buttonList) {
                i += button.getBounds().height;
            }
            return i;
        }
    };
    private float scrollBarAlpha = 0.0f;
    private float scrollBarAlphaFuture = 0.0f;
    private long scrollBarAlphaFutureTime = -1L;
    private int tabsPage = -1;
    private EntryStack ingredientStackToNotice = EntryStack.empty();
    private EntryStack resultStackToNotice = EntryStack.empty();

    public VillagerRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> categoryMap, @Nullable class_2960 category) {
        super(class_333.field_18967);
        this.categoryMap = categoryMap;
        this.categories = Lists.newArrayList(categoryMap.keySet());
        if (category != null) {
            for (int i = 0; i < this.categories.size(); ++i) {
                if (!this.categories.get(i).getIdentifier().equals((Object)category)) continue;
                this.selectedCategoryIndex = i;
                break;
            }
        }
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public void addIngredientStackToNotice(EntryStack stack) {
        this.ingredientStackToNotice = stack;
    }

    @Override
    public void addResultStackToNotice(EntryStack stack) {
        this.resultStackToNotice = stack;
    }

    @Override
    public class_2960 getCurrentCategory() {
        return this.categories.get(this.selectedCategoryIndex).getIdentifier();
    }

    @Override
    public void recalculateCategoryPage() {
        this.tabsPage = -1;
    }

    public void method_25426() {
        super.method_25426();
        boolean isCompactTabs = ConfigObject.getInstance().isUsingCompactTabs();
        int tabSize = isCompactTabs ? 24 : 28;
        this.scrolling.draggingScrollBar = false;
        this.field_22786.clear();
        this.widgets.clear();
        this.buttonList.clear();
        this.recipeRenderers.clear();
        this.tabs.clear();
        int largestWidth = this.field_22789 - 100;
        int largestHeight = this.field_22790 - 40;
        RecipeCategory<?> category = this.categories.get(this.selectedCategoryIndex);
        RecipeDisplay display = this.categoryMap.get(category).get(this.selectedRecipeIndex);
        int guiWidth = class_3532.method_15340((int)(category.getDisplayWidth(display) + 30), (int)0, (int)largestWidth) + 100;
        int guiHeight = class_3532.method_15340((int)(category.getDisplayHeight() + 40), (int)166, (int)largestHeight);
        this.tabsPerPage = Math.max(5, class_3532.method_15357((double)(((double)guiWidth - 20.0) / (double)tabSize)));
        if (this.tabsPage == -1) {
            this.tabsPage = this.selectedCategoryIndex / this.tabsPerPage;
        }
        this.bounds = new Rectangle(this.field_22789 / 2 - guiWidth / 2, this.field_22790 / 2 - guiHeight / 2, guiWidth, guiHeight);
        List<List<EntryStack>> workingStations = RecipeHelper.getInstance().getWorkingStations(category.getIdentifier());
        if (!workingStations.isEmpty()) {
            int ww = class_3532.method_15375((float)((float)(this.bounds.width - 16) / 18.0f));
            int w = Math.min(ww, workingStations.size());
            int h = class_3532.method_15386((float)((float)workingStations.size() / (float)ww));
            int xx = this.bounds.x + 16;
            int yy = this.bounds.y + this.bounds.height + 2;
            this.widgets.add(Widgets.createCategoryBase(new Rectangle(xx - 5, this.bounds.y + this.bounds.height - 5, 10 + w * 16, 12 + h * 16)));
            this.widgets.add(Widgets.createSlotBase(new Rectangle(xx - 1, yy - 1, 2 + w * 16, 2 + h * 16)));
            int index = 0;
            List<class_5250> list = Collections.singletonList(new class_2588("text.rei.working_station").method_27692(class_124.field_1054));
            for (List<EntryStack> workingStation : workingStations) {
                this.widgets.add(new RecipeViewingScreen.WorkstationSlotWidget(xx, yy, CollectionUtils.map(workingStation, stack -> stack.copy().setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, s -> list))));
                xx += 16;
                if (++index < ww) continue;
                index = 0;
                xx = this.bounds.x + 16;
                yy += 16;
            }
        }
        this.widgets.add(Widgets.createCategoryBase(this.bounds));
        this.scrollListBounds = new Rectangle(this.bounds.x + 4, this.bounds.y + 17, 102, guiHeight - 17 - 7);
        this.widgets.add(Widgets.createSlotBase(this.scrollListBounds));
        Rectangle recipeBounds = new Rectangle(this.bounds.x + 100 + (guiWidth - 100) / 2 - category.getDisplayWidth(display) / 2, this.bounds.y + this.bounds.height / 2 - category.getDisplayHeight() / 2, category.getDisplayWidth(display), category.getDisplayHeight());
        List<Widget> setupDisplay = category.setupDisplay(display, recipeBounds);
        RecipeViewingScreen.transformIngredientNotice(setupDisplay, this.ingredientStackToNotice);
        RecipeViewingScreen.transformResultNotice(setupDisplay, this.resultStackToNotice);
        this.widgets.addAll(setupDisplay);
        Optional<ButtonAreaSupplier> supplier = RecipeHelper.getInstance().getAutoCraftButtonArea(category);
        if (supplier.isPresent() && supplier.get().get(recipeBounds) != null) {
            this.widgets.add(InternalWidgets.createAutoCraftingButtonWidget(recipeBounds, supplier.get().get(recipeBounds), (class_2561)new class_2585(supplier.get().getButtonText()), () -> display, setupDisplay, category));
        }
        int index = 0;
        for (RecipeDisplay recipeDisplay : this.categoryMap.get(category)) {
            int finalIndex = index++;
            RecipeEntry recipeEntry = category.getSimpleRenderer(recipeDisplay);
            this.recipeRenderers.add(recipeEntry);
            this.buttonList.add(Widgets.createButton(new Rectangle(this.bounds.x + 5, 0, recipeEntry.getWidth(), recipeEntry.getHeight()), class_333.field_18967).onClick(button -> {
                this.selectedRecipeIndex = finalIndex;
                this.method_25426();
            }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.scrollListBounds.contains(point) || button.isFocused()).onRender((matrices, button) -> button.setEnabled(this.selectedRecipeIndex != finalIndex)));
        }
        int tabV = isCompactTabs ? 166 : 192;
        for (int i = 0; i < this.tabsPerPage; ++i) {
            int j = i + this.tabsPage * this.tabsPerPage;
            if (this.categories.size() <= j) continue;
            RecipeCategory<?> tabCategory = this.categories.get(j);
            TabWidget tab = TabWidget.create(i, tabSize, this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.tabsPage * this.tabsPerPage, this.tabsPerPage) * tabSize / 2, this.bounds.y, 0, tabV, widget -> {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                if (widget.selected) {
                    return false;
                }
                ClientHelperImpl.getInstance().openRecipeViewingScreen(this.categoryMap, tabCategory.getIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
                return true;
            });
            this.tabs.add(tab);
            tab.setRenderer(tabCategory, tabCategory.getLogo(), tabCategory.getCategoryName(), j == this.selectedCategoryIndex);
        }
        this.widgets.add(Widgets.createButton(new Rectangle(this.bounds.x + 2, this.bounds.y - 16, 10, 10), (class_2561)new class_2588("text.rei.left_arrow")).onClick(button -> {
            --this.tabsPage;
            if (this.tabsPage < 0) {
                this.tabsPage = class_3532.method_15386((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1;
            }
            this.method_25426();
        }).enabled(this.categories.size() > this.tabsPerPage));
        this.widgets.add(Widgets.createButton(new Rectangle(this.bounds.x + this.bounds.width - 12, this.bounds.y - 16, 10, 10), (class_2561)new class_2588("text.rei.right_arrow")).onClick(button -> {
            ++this.tabsPage;
            if (this.tabsPage > class_3532.method_15386((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1) {
                this.tabsPage = 0;
            }
            this.method_25426();
        }).enabled(this.categories.size() > this.tabsPerPage));
        this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.x + 4 + this.scrollListBounds.width / 2, this.bounds.y + 6), (class_2561)new class_2585(this.categories.get(this.selectedCategoryIndex).getCategoryName()), label -> ClientHelper.getInstance().executeViewAllRecipesKeyBind()).tooltipLine(class_1074.method_4662((String)"text.rei.view_all_categories", (Object[])new Object[0])).noShadow().color(-12566464, -4473925).hoveredColor(-16760321, -17075));
        this.field_22786.addAll(this.buttonList);
        this.widgets.addAll(this.tabs);
        this.field_22786.addAll(this.widgets);
        this.field_22786.add(ScreenHelper.getLastOverlay(true, false));
        ScreenHelper.getLastOverlay().init();
    }

    public boolean method_25402(double mouseX, double mouseY, int int_1) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, int_1)) {
            this.scrollBarAlpha = 1.0f;
            return true;
        }
        return super.method_25402(mouseX, mouseY, int_1);
    }

    public boolean method_25400(char char_1, int int_1) {
        for (class_364 listener : this.method_25396()) {
            if (!listener.method_25400(char_1, int_1)) continue;
            return true;
        }
        return super.method_25400(char_1, int_1);
    }

    public boolean method_25401(double double_1, double double_2, double double_3) {
        double height = this.scrolling.getMaxScrollHeight();
        if (this.scrollListBounds.contains(double_1, double_2) && height > (double)(this.scrollListBounds.height - 2)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlphaFuture = 1.0f;
            }
            if ((float)(System.currentTimeMillis() - this.scrollBarAlphaFutureTime) > 300.0f) {
                this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            }
            return true;
        }
        for (class_364 listener : this.method_25396()) {
            if (!listener.method_25401(double_1, double_2, double_3)) continue;
            return true;
        }
        if (this.bounds.contains(PointHelper.ofMouse())) {
            if (double_3 < 0.0 && this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.method_25426();
            } else if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() - 1;
                }
                this.method_25426();
                return true;
            }
        }
        return super.method_25401(double_1, double_2, double_3);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (ConfigObject.getInstance().doesVillagerScreenHavePermanentScrollBar()) {
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 0.0f;
            this.scrollBarAlpha = 1.0f;
        } else if (this.scrollBarAlphaFutureTime > 0L) {
            long l = System.currentTimeMillis() - this.scrollBarAlphaFutureTime;
            if ((float)l > 300.0f) {
                if (this.scrollBarAlphaFutureTime == 0L) {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                    this.scrollBarAlphaFutureTime = -1L;
                } else if ((float)l > 2000.0f && this.scrollBarAlphaFuture == 1.0f) {
                    this.scrollBarAlphaFuture = 0.0f;
                    this.scrollBarAlphaFutureTime = System.currentTimeMillis();
                } else {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                }
            } else if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlpha = Math.min(this.scrollBarAlpha, 1.0f - Math.min(1.0f, (float)l / 300.0f));
            } else if (this.scrollBarAlphaFuture == 1.0f) {
                this.scrollBarAlpha = Math.max(Math.min(1.0f, (float)l / 300.0f), this.scrollBarAlpha);
            }
        }
        this.scrolling.updatePosition(delta);
        this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        int yOffset = 0;
        for (Widget widget : this.widgets) {
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
        ScreenHelper.getLastOverlay().method_25394(matrices, mouseX, mouseY, delta);
        RenderSystem.pushMatrix();
        ScissorsHandler.INSTANCE.scissor(this.scrolling.getBounds());
        for (Button button : this.buttonList) {
            button.getBounds().y = this.scrollListBounds.y + 1 + yOffset - (int)this.scrolling.scrollAmount;
            if (button.getBounds().getMaxY() > this.scrollListBounds.getMinY() && button.getBounds().getMinY() < this.scrollListBounds.getMaxY()) {
                button.method_25394(matrices, mouseX, mouseY, delta);
            }
            yOffset += button.getBounds().height;
        }
        for (int i = 0; i < this.buttonList.size(); ++i) {
            if (this.buttonList.get(i).getBounds().getMaxY() <= this.scrollListBounds.getMinY() || this.buttonList.get(i).getBounds().getMinY() >= this.scrollListBounds.getMaxY()) continue;
            this.recipeRenderers.get(i).setZ(1);
            this.recipeRenderers.get(i).render(matrices, this.buttonList.get(i).getBounds(), mouseX, mouseY, delta);
            Optional.ofNullable(this.recipeRenderers.get(i).getTooltip(new Point(mouseX, mouseY))).ifPresent(Tooltip::queue);
        }
        this.scrolling.renderScrollBar(0, this.scrollBarAlpha);
        ScissorsHandler.INSTANCE.removeLastScissor();
        RenderSystem.popMatrix();
        ScreenHelper.getLastOverlay().lateRender(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25403(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, int_1, double_3, double_4)) {
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 1.0f;
            return true;
        }
        return super.method_25403(mouseX, mouseY, int_1, double_3, double_4);
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (int_1 == 258) {
            boolean boolean_1;
            boolean bl = boolean_1 = !VillagerRecipeViewingScreen.method_25442();
            if (!this.method_25407(boolean_1)) {
                this.method_25407(boolean_1);
            }
            return true;
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesKey(int_1, int_2)) {
            if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.method_25426();
                return true;
            }
            return false;
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesKey(int_1, int_2)) {
            if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() - 1;
                }
                this.method_25426();
                return true;
            }
            return false;
        }
        for (class_364 element : this.method_25396()) {
            if (!element.method_25404(int_1, int_2, int_3)) continue;
            return true;
        }
        if (int_1 == 256 || this.field_22787.field_1690.field_1822.method_1417(int_1, int_2)) {
            class_310.method_1551().method_1507(ScreenHelper.getLastHandledScreen());
            ScreenHelper.getLastOverlay().init();
            return true;
        }
        if (int_1 == 259) {
            if (ScreenHelper.hasLastRecipeScreen()) {
                this.field_22787.method_1507(ScreenHelper.getLastRecipeScreen());
            } else {
                this.field_22787.method_1507(ScreenHelper.getLastHandledScreen());
            }
            return true;
        }
        return super.method_25404(int_1, int_2, int_3);
    }
}

