/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.*;
import me.shedaniel.rei.api.widgets.Button;
import me.shedaniel.rei.api.widgets.Panel;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.RecipeChoosePageWidget;
import me.shedaniel.rei.gui.widget.TabWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ClientHelperImpl;
import me.shedaniel.rei.impl.InternalWidgets;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.widgets.PanelWidget;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Supplier;

@ApiStatus.Internal
public class RecipeViewingScreen extends class_437 implements RecipeScreen {
    
    public static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private final List<Widget> preWidgets = Lists.newArrayList();
    private final List<Widget> widgets = Lists.newArrayList();
    private final Map<Rectangle, List<Widget>> recipeBounds = Maps.newHashMap();
    private final List<TabWidget> tabs = Lists.newArrayList();
    private final Map<RecipeCategory<?>, List<RecipeDisplay>> categoriesMap;
    private final List<RecipeCategory<?>> categories;
    private final RecipeCategory<RecipeDisplay> selectedCategory;
    public int guiWidth;
    public int guiHeight;
    public int page;
    public int categoryPages = -1;
    public int largestWidth, largestHeight;
    public boolean choosePageActivated = false;
    public RecipeChoosePageWidget recipeChoosePageWidget;
    private int tabsPerPage = 5;
    private Rectangle bounds;
    @Nullable
    private Panel workingStationsBaseWidget;
    private Button recipeBack, recipeNext, categoryBack, categoryNext;
    private EntryStack ingredientStackToNotice = EntryStack.empty();
    private EntryStack resultStackToNotice = EntryStack.empty();
    
    public RecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> categoriesMap, @Nullable class_2960 category) {
        super(class_333.field_18967);
        class_1041 window = class_310.method_1551().method_22683();
        this.bounds = new Rectangle(window.method_4486() / 2 - guiWidth / 2, window.method_4502() / 2 - guiHeight / 2, 176, 150);
        this.categoriesMap = categoriesMap;
        this.categories = Lists.newArrayList(categoriesMap.keySet());
        RecipeCategory<?> selected = categories.get(0);
        if (category != null) {
            for (RecipeCategory<?> recipeCategory : categories) {
                if (recipeCategory.getIdentifier().equals(category)) {
                    selected = recipeCategory;
                    break;
                }
            }
        }
        this.selectedCategory = (RecipeCategory<RecipeDisplay>) selected;
    }
    
    @ApiStatus.Internal
    static void transformIngredientNotice(List<Widget> setupDisplay, EntryStack noticeStack) {
        transformNotice(1, setupDisplay, noticeStack);
    }
    
    @ApiStatus.Internal
    static void transformResultNotice(List<Widget> setupDisplay, EntryStack noticeStack) {
        transformNotice(2, setupDisplay, noticeStack);
    }
    
    private static void transformNotice(int marker, List<Widget> setupDisplay, EntryStack noticeStack) {
        if (noticeStack.isEmpty())
            return;
        for (Widget widget : setupDisplay) {
            if (widget instanceof EntryWidget) {
                EntryWidget entry = (EntryWidget) widget;
                if (entry.getNoticeMark() == marker && entry.entries().size() > 1) {
                    EntryStack stack = CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(entry.entries(), noticeStack);
                    if (stack != null) {
                        entry.clearStacks();
                        entry.entry(stack);
                    }
                }
            }
        }
    }
    
    @ApiStatus.Internal
    @Override
    public void addIngredientStackToNotice(EntryStack stack) {
        this.ingredientStackToNotice = stack;
    }
    
    @ApiStatus.Internal
    @Override
    public void addResultStackToNotice(EntryStack stack) {
        this.resultStackToNotice = stack;
    }
    
    @Override
    public class_2960 getCurrentCategory() {
        return selectedCategory.getIdentifier();
    }
    
    @Override
    public void recalculateCategoryPage() {
        this.categoryPages = -1;
    }
    
    @Nullable
    public Panel getWorkingStationsBaseWidget() {
        return workingStationsBaseWidget;
    }
    
    @Override
    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (int_1 == 256 && choosePageActivated) {
            choosePageActivated = false;
            method_25426();
            return true;
        }
        if (int_1 == 258) {
            boolean boolean_1 = !method_25442();
            if (!this.method_25407(boolean_1))
                this.method_25407(boolean_1);
            return true;
        }
        if (choosePageActivated)
            return recipeChoosePageWidget.method_25404(int_1, int_2, int_3);
        else if (ConfigObject.getInstance().getNextPageKeybind().matchesKey(int_1, int_2)) {
            if (recipeNext.isEnabled())
                recipeNext.onClick();
            return recipeNext.isEnabled();
        } else if (ConfigObject.getInstance().getPreviousPageKeybind().matchesKey(int_1, int_2)) {
            if (recipeBack.isEnabled())
                recipeBack.onClick();
            return recipeBack.isEnabled();
        }
        for (class_364 element : method_25396())
            if (element.method_25404(int_1, int_2, int_3))
                return true;
        if (int_1 == 256 || this.field_22787.field_1690.field_1822.method_1417(int_1, int_2)) {
            class_310.method_1551().method_1507(ScreenHelper.getLastHandledScreen());
            ScreenHelper.getLastOverlay().init();
            return true;
        }
        if (int_1 == 259) {
            if (ScreenHelper.hasLastRecipeScreen())
                field_22787.method_1507(ScreenHelper.getLastRecipeScreen());
            else
                field_22787.method_1507(ScreenHelper.getLastHandledScreen());
            return true;
        }
        return super.method_25404(int_1, int_2, int_3);
    }
    
    @Override
    public boolean method_25421() {
        return false;
    }
    
    @Override
    public void method_25426() {
        super.method_25426();
        boolean isCompactTabs = ConfigObject.getInstance().isUsingCompactTabs();
        int tabSize = isCompactTabs ? 24 : 28;
        this.field_22786.clear();
        this.recipeBounds.clear();
        this.tabs.clear();
        this.preWidgets.clear();
        this.widgets.clear();
        this.largestWidth = field_22789 - 100;
        this.largestHeight = Math.max(field_22790 - 34 - 30, 100);
        int maxWidthDisplay = CollectionUtils.mapAndMax(getCurrentDisplayed(), selectedCategory::getDisplayWidth, Comparator.naturalOrder()).orElse(150);
        this.guiWidth = Math.max(maxWidthDisplay + 40, 0);
        this.guiHeight = class_3532.method_15357(class_3532.method_15350((double) (selectedCategory.getDisplayHeight() + 4) * (getRecipesPerPage() + 1) + 36, 100, largestHeight));
        if (!ConfigObject.getInstance().shouldResizeDynamically()) this.guiHeight = largestHeight;
        this.tabsPerPage = Math.max(5, class_3532.method_15357((guiWidth - 20d) / tabSize));
        if (this.categoryPages == -1) {
            this.categoryPages = Math.max(0, categories.indexOf(selectedCategory) / tabsPerPage);
        }
        this.bounds = new Rectangle(field_22789 / 2 - guiWidth / 2, field_22790 / 2 - guiHeight / 2, guiWidth, guiHeight);
        this.page = class_3532.method_15340(page, 0, getTotalPages(selectedCategory) - 1);
        this.widgets.add(Widgets.createButton(new Rectangle(bounds.x, bounds.y - 16, 10, 10), new class_2588("text.rei.left_arrow"))
                .onClick(button -> {
                    categoryPages--;
                    if (categoryPages < 0)
                        categoryPages = class_3532.method_15386(categories.size() / (float) tabsPerPage) - 1;
                    RecipeViewingScreen.this.method_25426();
                })
                .enabled(categories.size() > tabsPerPage));
        this.widgets.add(Widgets.createButton(new Rectangle(bounds.x + bounds.width - 10, bounds.y - 16, 10, 10), new class_2588("text.rei.right_arrow"))
                .onClick(button -> {
                    categoryPages++;
                    if (categoryPages > class_3532.method_15386(categories.size() / (float) tabsPerPage) - 1)
                        categoryPages = 0;
                    RecipeViewingScreen.this.method_25426();
                })
                .enabled(categories.size() > tabsPerPage));
        widgets.add(categoryBack = Widgets.createButton(new Rectangle(bounds.getX() + 5, bounds.getY() + 5, 12, 12), new class_2588("text.rei.left_arrow"))
                .onClick(button -> {
                    int currentCategoryIndex = categories.indexOf(selectedCategory);
                    currentCategoryIndex--;
                    if (currentCategoryIndex < 0)
                        currentCategoryIndex = categories.size() - 1;
                    ClientHelperImpl.getInstance().openRecipeViewingScreen(categoriesMap, categories.get(currentCategoryIndex).getIdentifier(), ingredientStackToNotice, resultStackToNotice);
                }).tooltipLine(class_1074.method_4662("text.rei.previous_category")));
        widgets.add(Widgets.createClickableLabel(new Point(bounds.getCenterX(), bounds.getY() + 7), new class_2585(selectedCategory.getCategoryName()), clickableLabelWidget -> {
            ClientHelper.getInstance().executeViewAllRecipesKeyBind();
        }).tooltipLine(class_1074.method_4662("text.rei.view_all_categories")));
        widgets.add(categoryNext = Widgets.createButton(new Rectangle(bounds.getMaxX() - 17, bounds.getY() + 5, 12, 12), new class_2588("text.rei.right_arrow"))
                .onClick(button -> {
                    int currentCategoryIndex = categories.indexOf(selectedCategory);
                    currentCategoryIndex++;
                    if (currentCategoryIndex >= categories.size())
                        currentCategoryIndex = 0;
                    ClientHelperImpl.getInstance().openRecipeViewingScreen(categoriesMap, categories.get(currentCategoryIndex).getIdentifier(), ingredientStackToNotice, resultStackToNotice);
                }).tooltipLine(class_1074.method_4662("text.rei.next_category")));
        categoryBack.setEnabled(categories.size() > 1);
        categoryNext.setEnabled(categories.size() > 1);
        
        widgets.add(recipeBack = Widgets.createButton(new Rectangle(bounds.getX() + 5, bounds.getY() + 19, 12, 12), new class_2588("text.rei.left_arrow"))
                .onClick(button -> {
                    page--;
                    if (page < 0)
                        page = getTotalPages(selectedCategory) - 1;
                    RecipeViewingScreen.this.method_25426();
                }).tooltipLine(class_1074.method_4662("text.rei.previous_page")));
        widgets.add(Widgets.createClickableLabel(new Point(bounds.getCenterX(), bounds.getY() + 21), class_333.field_18967, label -> {
            RecipeViewingScreen.this.choosePageActivated = true;
            RecipeViewingScreen.this.method_25426();
        }).onRender((matrices, label) -> {
            label.setText(new class_2585(String.format("%d/%d", page + 1, getTotalPages(selectedCategory))));
            label.setClickable(getTotalPages(selectedCategory) > 1);
        }).tooltipSupplier(label -> label.isClickable() ? class_1074.method_4662("text.rei.choose_page") : null));
        widgets.add(recipeNext = Widgets.createButton(new Rectangle(bounds.getMaxX() - 17, bounds.getY() + 19, 12, 12), new class_2588("text.rei.right_arrow"))
                .onClick(button -> {
                    page++;
                    if (page >= getTotalPages(selectedCategory))
                        page = 0;
                    RecipeViewingScreen.this.method_25426();
                }).tooltipLine(class_1074.method_4662("text.rei.next_page")));
        recipeBack.setEnabled(getTotalPages(selectedCategory) > 1);
        recipeNext.setEnabled(getTotalPages(selectedCategory) > 1);
        int tabV = isCompactTabs ? 166 : 192;
        for (int i = 0; i < tabsPerPage; i++) {
            int j = i + categoryPages * tabsPerPage;
            if (categories.size() > j) {
                TabWidget tab;
                tabs.add(tab = TabWidget.create(i, tabSize, bounds.x + bounds.width / 2 - Math.min(categories.size() - categoryPages * tabsPerPage, tabsPerPage) * tabSize / 2, bounds.y, 0, tabV, widget -> {
                    class_310.method_1551().method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
                    if (widget.getId() + categoryPages * tabsPerPage == categories.indexOf(selectedCategory))
                        return false;
                    ClientHelperImpl.getInstance().openRecipeViewingScreen(categoriesMap, categories.get(widget.getId() + categoryPages * tabsPerPage).getIdentifier(), ingredientStackToNotice, resultStackToNotice);
                    return true;
                }));
                tab.setRenderer(categories.get(j), categories.get(j).getLogo(), categories.get(j).getCategoryName(), tab.getId() + categoryPages * tabsPerPage == categories.indexOf(selectedCategory));
            }
        }
        Optional<ButtonAreaSupplier> supplier = RecipeHelper.getInstance().getAutoCraftButtonArea(selectedCategory);
        int recipeHeight = selectedCategory.getDisplayHeight();
        List<RecipeDisplay> currentDisplayed = getCurrentDisplayed();
        for (int i = 0; i < currentDisplayed.size(); i++) {
            final RecipeDisplay display = currentDisplayed.get(i);
            final Supplier<RecipeDisplay> displaySupplier = () -> display;
            int displayWidth = selectedCategory.getDisplayWidth(displaySupplier.get());
            final Rectangle displayBounds = new Rectangle(getBounds().getCenterX() - displayWidth / 2, getBounds().getCenterY() + 16 - recipeHeight * (getRecipesPerPage() + 1) / 2 - 2 * (getRecipesPerPage() + 1) + recipeHeight * i + 4 * i, displayWidth, recipeHeight);
            List<Widget> setupDisplay = selectedCategory.setupDisplay(display, displayBounds);
            transformIngredientNotice(setupDisplay, ingredientStackToNotice);
            transformResultNotice(setupDisplay, resultStackToNotice);
            recipeBounds.put(displayBounds, setupDisplay);
            this.widgets.addAll(setupDisplay);
            if (supplier.isPresent() && supplier.get().get(displayBounds) != null)
                this.widgets.add(InternalWidgets.createAutoCraftingButtonWidget(displayBounds, supplier.get().get(displayBounds), new class_2585(supplier.get().getButtonText()), displaySupplier, setupDisplay, selectedCategory));
        }
        if (choosePageActivated)
            recipeChoosePageWidget = new RecipeChoosePageWidget(this, page, getTotalPages(selectedCategory));
        else
            recipeChoosePageWidget = null;
        
        workingStationsBaseWidget = null;
        List<List<EntryStack>> workingStations = RecipeHelper.getInstance().getWorkingStations(selectedCategory.getIdentifier());
        if (!workingStations.isEmpty()) {
            int hh = class_3532.method_15375((bounds.height - 16) / 18f);
            int actualHeight = Math.min(hh, workingStations.size());
            int innerWidth = class_3532.method_15386(workingStations.size() / ((float) hh));
            int xx = bounds.x - (8 + innerWidth * 16) + 6;
            int yy = bounds.y + 16;
            preWidgets.add(workingStationsBaseWidget = Widgets.createCategoryBase(new Rectangle(xx - 5, yy - 5, 15 + innerWidth * 16, 10 + actualHeight * 16)));
            preWidgets.add(Widgets.createSlotBase(new Rectangle(xx - 1, yy - 1, innerWidth * 16 + 2, actualHeight * 16 + 2)));
            int index = 0;
            List<class_2561> list = Collections.singletonList(new class_2588("text.rei.working_station").method_27692(class_124.field_1054));
            xx += (innerWidth - 1) * 16;
            for (List<EntryStack> workingStation : workingStations) {
                preWidgets.add(new WorkstationSlotWidget(xx, yy, CollectionUtils.map(workingStation, stack -> stack.copy().setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, s -> list))));
                index++;
                yy += 16;
                if (index >= hh) {
                    index = 0;
                    yy = bounds.y + 16;
                    xx -= 16;
                }
            }
        }
        
        field_22786.addAll(tabs);
        field_22786.add(ScreenHelper.getLastOverlay(true, false));
        field_22786.addAll(widgets);
        field_22786.addAll(preWidgets);
    }
    
    public List<Widget> getWidgets() {
        return widgets;
    }
    
    public List<RecipeDisplay> getCurrentDisplayed() {
        List<RecipeDisplay> list = Lists.newArrayList();
        int recipesPerPage = getRecipesPerPage();
        for (int i = 0; i <= recipesPerPage; i++)
            if (page * (recipesPerPage + 1) + i < categoriesMap.get(selectedCategory).size())
                list.add(categoriesMap.get(selectedCategory).get(page * (recipesPerPage + 1) + i));
        return list;
    }
    
    public RecipeCategory<RecipeDisplay> getSelectedCategory() {
        return selectedCategory;
    }
    
    public int getPage() {
        return page;
    }
    
    public int getCategoryPage() {
        return categoryPages;
    }
    
    private int getRecipesPerPage() {
        if (selectedCategory.getFixedRecipesPerPage() > 0)
            return selectedCategory.getFixedRecipesPerPage() - 1;
        int height = selectedCategory.getDisplayHeight();
        return class_3532.method_15340(class_3532.method_15357(((double) largestHeight - 36) / ((double) height + 4)) - 1, 0, Math.min(ConfigObject.getInstance().getMaxRecipePerPage() - 1, selectedCategory.getMaximumRecipePerPage() - 1));
    }
    
    private int getRecipesPerPageByHeight() {
        int height = selectedCategory.getDisplayHeight();
        return class_3532.method_15340(class_3532.method_15357(((double) guiHeight - 36) / ((double) height + 4)), 0, Math.min(ConfigObject.getInstance().getMaxRecipePerPage() - 1, selectedCategory.getMaximumRecipePerPage() - 1));
    }
    
    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        for (Widget widget : preWidgets) {
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
        PanelWidget.render(matrices, bounds, -1);
        if (REIHelper.getInstance().isDarkThemeEnabled()) {
            method_25294(matrices, bounds.x + 17, bounds.y + 5, bounds.x + bounds.width - 17, bounds.y + 17, 0xFF404040);
            method_25294(matrices, bounds.x + 17, bounds.y + 19, bounds.x + bounds.width - 17, bounds.y + 30, 0xFF404040);
        } else {
            method_25294(matrices, bounds.x + 17, bounds.y + 5, bounds.x + bounds.width - 17, bounds.y + 17, 0xFF9E9E9E);
            method_25294(matrices, bounds.x + 17, bounds.y + 19, bounds.x + bounds.width - 17, bounds.y + 31, 0xFF9E9E9E);
        }
        for (TabWidget tab : tabs) {
            if (!tab.isSelected())
                tab.method_25394(matrices, mouseX, mouseY, delta);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        for (Widget widget : widgets) {
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
        RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
        for (TabWidget tab : tabs) {
            if (tab.isSelected())
                tab.method_25394(matrices, mouseX, mouseY, delta);
        }
        ScreenHelper.getLastOverlay().method_25394(matrices, mouseX, mouseY, delta);
        ScreenHelper.getLastOverlay().lateRender(matrices, mouseX, mouseY, delta);
        {
            ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
            if (export.matchesCurrentKey()) {
                for (Map.Entry<Rectangle, List<Widget>> entry : recipeBounds.entrySet()) {
                    Rectangle bounds = entry.getKey();
                    method_25304(470);
                    if (bounds.contains(mouseX, mouseY)) {
                        method_25296(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 1744822402, 1744822402);
                        class_2561 text = new class_2588("text.rei.release_export", export.getLocalizedName().method_27662().getString());
                        class_4597.class_4598 immediate = class_4597.method_22991(class_289.method_1348().method_1349());
                        matrices.method_22903();
                        matrices.method_22904(0.0D, 0.0D, 480);
                        class_1159 matrix4f = matrices.method_23760().method_23761();
                        field_22793.method_22942(text, bounds.getCenterX() - field_22793.method_27525(text) / 2f, bounds.getCenterY() - 4.5f, 0xff000000, false, matrix4f, immediate, false, 0, 15728880);
                        immediate.method_22993();
                        matrices.method_22909();
                    } else {
                        method_25296(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 1744830463, 1744830463);
                    }
                    method_25304(0);
                }
            }
        }
        if (choosePageActivated) {
            method_25304(500);
            this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
            method_25304(0);
            recipeChoosePageWidget.method_25394(matrices, mouseX, mouseY, delta);
        }
    }
    
    @Override
    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesKey(keyCode, scanCode)) {
            for (Map.Entry<Rectangle, List<Widget>> entry : recipeBounds.entrySet()) {
                Rectangle bounds = entry.getKey();
                if (bounds.contains(PointHelper.ofMouse())) {
                    RecipeDisplayExporter.exportRecipeDisplay(bounds, entry.getValue());
                    break;
                }
            }
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }
    
    public int getTotalPages(RecipeCategory<RecipeDisplay> category) {
        return class_3532.method_15384(categoriesMap.get(category).size() / (double) (getRecipesPerPage() + 1));
    }
    
    public Rectangle getBounds() {
        return bounds;
    }
    
    @Override
    public boolean method_25400(char char_1, int int_1) {
        if (choosePageActivated) {
            return recipeChoosePageWidget.method_25400(char_1, int_1);
        }
        for (class_364 listener : method_25396())
            if (listener.method_25400(char_1, int_1))
                return true;
        return super.method_25400(char_1, int_1);
    }
    
    @Override
    public boolean method_25403(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (choosePageActivated) {
            return recipeChoosePageWidget.method_25403(double_1, double_2, int_1, double_3, double_4);
        }
        return super.method_25403(double_1, double_2, int_1, double_3, double_4);
    }
    
    @Override
    public boolean method_25406(double double_1, double double_2, int int_1) {
        if (choosePageActivated) {
            return recipeChoosePageWidget.method_25406(double_1, double_2, int_1);
        }
        return super.method_25406(double_1, double_2, int_1);
    }
    
    @Override
    public boolean method_25401(double i, double j, double amount) {
        for (class_364 listener : method_25396())
            if (listener.method_25401(i, j, amount))
                return true;
        if (getBounds().contains(PointHelper.ofMouse())) {
            if (amount > 0 && recipeBack.isEnabled())
                recipeBack.onClick();
            else if (amount < 0 && recipeNext.isEnabled())
                recipeNext.onClick();
        }
        if ((new Rectangle(bounds.x, bounds.y - 28, bounds.width, 28)).contains(PointHelper.ofMouse())) {
            if (amount > 0 && categoryBack.isEnabled())
                categoryBack.onClick();
            else if (amount < 0 && categoryNext.isEnabled())
                categoryNext.onClick();
        }
        return super.method_25401(i, j, amount);
    }
    
    @Override
    public boolean method_25402(double double_1, double double_2, int int_1) {
        if (choosePageActivated)
            if (recipeChoosePageWidget.containsMouse(double_1, double_2)) {
                return recipeChoosePageWidget.method_25402(double_1, double_2, int_1);
            } else {
                choosePageActivated = false;
                method_25426();
                return false;
            }
        for (class_364 entry : method_25396())
            if (entry.method_25402(double_1, double_2, int_1)) {
                method_25395(entry);
                if (int_1 == 0)
                    method_25398(true);
                return true;
            }
        return false;
    }
    
    @Override
    public class_364 method_25399() {
        if (choosePageActivated)
            return recipeChoosePageWidget;
        return super.method_25399();
    }
    
    public static class WorkstationSlotWidget extends EntryWidget {
        public WorkstationSlotWidget(int x, int y, List<EntryStack> widgets) {
            super(new Point(x, y));
            entries(widgets);
            noBackground();
        }
        
        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return getInnerBounds().contains(mouseX, mouseY);
        }
    }
    
}
