/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.widgets.Button;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.OverlaySearchField;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.gui.config.SearchFieldLocation;
import me.shedaniel.rei.gui.modules.Menu;
import me.shedaniel.rei.gui.modules.entries.GameModeMenuEntry;
import me.shedaniel.rei.gui.modules.entries.WeatherMenuEntry;
import me.shedaniel.rei.gui.widget.EntryListWidget;
import me.shedaniel.rei.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.gui.widget.LateRenderable;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ClientHelperImpl;
import me.shedaniel.rei.impl.InternalWidgets;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.Weather;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_1162;
import net.minecraft.class_1269;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_333;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_638;
import net.minecraft.class_918;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ContainerScreenOverlay
extends WidgetWithBounds {
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final List<Tooltip> TOOLTIPS = Lists.newArrayList();
    private static final List<Runnable> AFTER_RENDER = Lists.newArrayList();
    private static final EntryListWidget ENTRY_LIST_WIDGET = new EntryListWidget();
    private static FavoritesListWidget favoritesListWidget = null;
    private final List<Widget> widgets = Lists.newLinkedList();
    public boolean shouldReInit = false;
    private int tooltipWidth;
    private int tooltipHeight;
    private List<class_2561> tooltipLines;
    public final TriConsumer<class_4587, Point, Float> renderTooltipCallback = (matrices, mouse, aFloat) -> {
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 999.0);
        int x = mouse.x;
        int y = mouse.y;
        this.method_25296((class_4587)matrices, x - 3, y - 4, x + this.tooltipWidth + 3, y - 3, -267386864, -267386864);
        this.method_25296((class_4587)matrices, x - 3, y + this.tooltipHeight + 3, x + this.tooltipWidth + 3, y + this.tooltipHeight + 4, -267386864, -267386864);
        this.method_25296((class_4587)matrices, x - 3, y - 3, x + this.tooltipWidth + 3, y + this.tooltipHeight + 3, -267386864, -267386864);
        this.method_25296((class_4587)matrices, x - 4, y - 3, x - 3, y + this.tooltipHeight + 3, -267386864, -267386864);
        this.method_25296((class_4587)matrices, x + this.tooltipWidth + 3, y - 3, x + this.tooltipWidth + 4, y + this.tooltipHeight + 3, -267386864, -267386864);
        this.method_25296((class_4587)matrices, x - 3, y - 3 + 1, x - 3 + 1, y + this.tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
        this.method_25296((class_4587)matrices, x + this.tooltipWidth + 2, y - 3 + 1, x + this.tooltipWidth + 3, y + this.tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
        this.method_25296((class_4587)matrices, x - 3, y - 3, x + this.tooltipWidth + 3, y - 3 + 1, 0x505000FF, 0x505000FF);
        this.method_25296((class_4587)matrices, x - 3, y + this.tooltipHeight + 2, x + this.tooltipWidth + 3, y + this.tooltipHeight + 3, 1344798847, 1344798847);
        int currentY = y;
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        class_1159 matrix = matrices.method_23760().method_23761();
        for (int lineIndex = 0; lineIndex < this.tooltipLines.size(); ++lineIndex) {
            this.font.method_22942(this.tooltipLines.get(lineIndex), (float)x, (float)currentY, -1, true, matrix, (class_4597)immediate, false, 0, 0xF000F0);
            currentY += lineIndex == 0 ? 12 : 10;
        }
        immediate.method_22993();
        matrices.method_22909();
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
    };
    private Rectangle bounds;
    private class_1041 window;
    private Button leftButton;
    private Button rightButton;
    @ApiStatus.Experimental
    private Rectangle subsetsButtonBounds;
    @ApiStatus.Experimental
    @Nullable
    private Menu subsetsMenu = null;
    private Widget wrappedSubsetsMenu = null;
    @Nullable
    private Menu weatherMenu = null;
    private Widget wrappedWeatherMenu = null;
    private boolean renderWeatherMenu = false;
    private Button weatherButton = null;
    @Nullable
    private Menu gameModeMenu = null;
    private Widget wrappedGameModeMenu = null;
    private boolean renderGameModeMenu = false;
    private Button gameModeButton = null;

    public static EntryListWidget getEntryListWidget() {
        return ENTRY_LIST_WIDGET;
    }

    @Nullable
    public static FavoritesListWidget getFavoritesListWidget() {
        return favoritesListWidget;
    }

    @ApiStatus.Experimental
    @Nullable
    public Menu getSubsetsMenu() {
        return this.subsetsMenu;
    }

    public void removeWeatherMenu() {
        this.renderWeatherMenu = false;
        Widget tmpWeatherMenu = this.wrappedWeatherMenu;
        AFTER_RENDER.add(() -> this.widgets.remove((Object)tmpWeatherMenu));
        this.weatherMenu = null;
        this.wrappedWeatherMenu = null;
    }

    public void removeGameModeMenu() {
        this.renderGameModeMenu = false;
        Widget tmpGameModeMenu = this.wrappedGameModeMenu;
        AFTER_RENDER.add(() -> this.widgets.remove((Object)tmpGameModeMenu));
        this.gameModeMenu = null;
        this.wrappedGameModeMenu = null;
    }

    public void init(boolean useless) {
        this.init();
    }

    public void init() {
        this.shouldReInit = false;
        this.method_25396().clear();
        this.wrappedSubsetsMenu = null;
        this.subsetsMenu = null;
        this.weatherMenu = null;
        this.renderWeatherMenu = false;
        this.weatherButton = null;
        this.window = class_310.method_1551().method_22683();
        DisplayHelper.DisplayBoundsHandler<?> boundsHandler = DisplayHelper.getInstance().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
        this.bounds = ConfigObject.getInstance().isLeftHandSidePanel() ? boundsHandler.getLeftBounds(class_310.method_1551().field_1755) : boundsHandler.getRightBounds(class_310.method_1551().field_1755);
        this.widgets.add(ENTRY_LIST_WIDGET);
        if (ConfigObject.getInstance().doDisplayFavoritesOnTheLeft() && ConfigObject.getInstance().isFavoritesEnabled()) {
            if (favoritesListWidget == null) {
                favoritesListWidget = new FavoritesListWidget();
            }
            this.widgets.add(favoritesListWidget);
        }
        ENTRY_LIST_WIDGET.updateArea(boundsHandler, ScreenHelper.getSearchField() == null ? "" : null);
        if (ScreenHelper.getSearchField() == null) {
            ScreenHelper.setSearchField(new OverlaySearchField(0, 0, 0, 0));
        }
        ScreenHelper.getSearchField().getBounds().setBounds(this.getSearchFieldArea());
        this.widgets.add(ScreenHelper.getSearchField());
        ScreenHelper.getSearchField().setChangedListener(s -> ENTRY_LIST_WIDGET.updateSearch((String)s, false));
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.leftButton = Widgets.createButton(new Rectangle(this.bounds.x, this.bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), (class_2561)new class_2588("text.rei.left_arrow")).onClick(button -> {
                ENTRY_LIST_WIDGET.previousPage();
                if (ENTRY_LIST_WIDGET.getPage() < 0) {
                    ENTRY_LIST_WIDGET.setPage(ENTRY_LIST_WIDGET.getTotalPages() - 1);
                }
                ENTRY_LIST_WIDGET.updateEntriesPosition();
            }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y)).tooltipLine(class_1074.method_4662((String)"text.rei.previous_page", (Object[])new Object[0])).focusable(false);
            this.widgets.add(this.leftButton);
            this.rightButton = Widgets.createButton(new Rectangle(this.bounds.x + this.bounds.width - 18, this.bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), (class_2561)new class_2588("text.rei.right_arrow")).onClick(button -> {
                ENTRY_LIST_WIDGET.nextPage();
                if (ENTRY_LIST_WIDGET.getPage() >= ENTRY_LIST_WIDGET.getTotalPages()) {
                    ENTRY_LIST_WIDGET.setPage(0);
                }
                ENTRY_LIST_WIDGET.updateEntriesPosition();
            }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y)).tooltipLine(class_1074.method_4662((String)"text.rei.next_page", (Object[])new Object[0])).focusable(false);
            this.widgets.add(this.rightButton);
        }
        Rectangle configButtonArea = this.getConfigButtonArea();
        Widget tmp = InternalWidgets.wrapLateRenderable(InternalWidgets.mergeWidgets(Widgets.createButton(configButtonArea, class_333.field_18967).onClick(button -> {
            if (class_437.method_25442()) {
                ClientHelper.getInstance().setCheating(!ClientHelper.getInstance().isCheating());
                return;
            }
            ConfigManager.getInstance().openConfigScreen((class_437)REIHelper.getInstance().getPreviousHandledScreen());
        }).onRender((matrices, button) -> {
            if (ClientHelper.getInstance().isCheating() && RoughlyEnoughItemsCore.hasOperatorPermission()) {
                button.setTint(RoughlyEnoughItemsCore.hasPermissionToUsePackets() ? 721354752 : 1476440063);
            } else {
                button.removeTint();
            }
        }).focusable(false).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y)).tooltipSupplier(button -> {
            String tooltips = class_1074.method_4662((String)"text.rei.config_tooltip", (Object[])new Object[0]);
            tooltips = tooltips + "\n  ";
            tooltips = !ClientHelper.getInstance().isCheating() ? tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_disabled", (Object[])new Object[0]) : (!RoughlyEnoughItemsCore.hasOperatorPermission() ? tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_enabled_no_perms", (Object[])new Object[0]) : (RoughlyEnoughItemsCore.hasPermissionToUsePackets() ? tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_enabled", (Object[])new Object[0]) : tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_limited_enabled", (Object[])new Object[0])));
            return tooltips;
        }), Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            helper.method_25304(helper.method_25305() + 1);
            class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
            helper.method_25302(matrices, configButtonArea.x + 3, configButtonArea.y + 3, 0, 0, 14, 14);
        })));
        this.widgets.add(tmp);
        tmp.setZ(600);
        if (ConfigObject.getInstance().doesShowUtilsButtons()) {
            this.gameModeButton = Widgets.createButton(ConfigObject.getInstance().isLowerConfigButton() ? new Rectangle(ConfigObject.getInstance().isLeftHandSidePanel() ? this.window.method_4486() - 30 : 10, 10, 20, 20) : new Rectangle(ConfigObject.getInstance().isLeftHandSidePanel() ? this.window.method_4486() - 55 : 35, 10, 20, 20), class_333.field_18967).onRender((matrices, button) -> {
                boolean tmpRender = this.renderGameModeMenu;
                boolean bl = this.renderGameModeMenu = !this.renderWeatherMenu && (button.isFocused() || button.containsMouse(PointHelper.ofMouse()) || this.wrappedGameModeMenu != null && this.wrappedGameModeMenu.containsMouse(PointHelper.ofMouse()));
                if (tmpRender != this.renderGameModeMenu) {
                    if (this.renderGameModeMenu) {
                        this.gameModeMenu = new Menu(new Point(button.getBounds().x, button.getBounds().getMaxY()), CollectionUtils.filterAndMap(Arrays.asList(class_1934.values()), mode -> mode != class_1934.field_9218, GameModeMenuEntry::new));
                        if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                            this.gameModeMenu.menuStartPoint.x -= this.gameModeMenu.getBounds().width - this.gameModeButton.getBounds().width;
                        }
                        this.wrappedGameModeMenu = InternalWidgets.wrapTranslate(InternalWidgets.wrapLateRenderable(this.gameModeMenu), 0.0f, 0.0f, 600.0f);
                        AFTER_RENDER.add(() -> this.widgets.add(this.wrappedGameModeMenu));
                    } else {
                        this.removeGameModeMenu();
                    }
                }
                button.setText((class_2561)new class_2585(this.getGameModeShortText(this.getCurrentGameMode())));
            }).focusable(false).tooltipLine(class_1074.method_4662((String)"text.rei.gamemode_button.tooltip.all", (Object[])new Object[0])).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y));
            this.widgets.add(this.gameModeButton);
            this.weatherButton = Widgets.createButton(new Rectangle(ConfigObject.getInstance().isLeftHandSidePanel() ? this.window.method_4486() - 30 : 10, 35, 20, 20), class_333.field_18967).onRender((matrices, button) -> {
                boolean tmpRender = this.renderWeatherMenu;
                boolean bl = this.renderWeatherMenu = !this.renderGameModeMenu && (button.isFocused() || button.containsMouse(PointHelper.ofMouse()) || this.wrappedWeatherMenu != null && this.wrappedWeatherMenu.containsMouse(PointHelper.ofMouse()));
                if (tmpRender != this.renderWeatherMenu) {
                    if (this.renderWeatherMenu) {
                        this.weatherMenu = new Menu(new Point(button.getBounds().x, button.getBounds().getMaxY()), CollectionUtils.map(Weather.values(), WeatherMenuEntry::new));
                        if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                            this.weatherMenu.menuStartPoint.x -= this.weatherMenu.getBounds().width - this.weatherButton.getBounds().width;
                        }
                        this.wrappedWeatherMenu = InternalWidgets.wrapTranslate(InternalWidgets.wrapLateRenderable(this.weatherMenu), 0.0f, 0.0f, 400.0f);
                        AFTER_RENDER.add(() -> this.widgets.add(this.wrappedWeatherMenu));
                    } else {
                        this.removeWeatherMenu();
                    }
                }
            }).tooltipLine(class_1074.method_4662((String)"text.rei.weather_button.tooltip.all", (Object[])new Object[0])).focusable(false).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y));
            this.widgets.add(this.weatherButton);
            this.widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
                class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                helper.method_25302(matrices, this.weatherButton.getBounds().x + 3, this.weatherButton.getBounds().y + 3, this.getCurrentWeather().getId() * 14, 14, 14, 14);
            }));
        }
        this.subsetsButtonBounds = this.getSubsetsButtonBounds();
        if (ConfigObject.getInstance().isSubsetsEnabled()) {
            this.widgets.add(InternalWidgets.wrapLateRenderable(InternalWidgets.wrapTranslate(Widgets.createButton(this.subsetsButtonBounds, (class_2561)((Boolean)((ClientHelperImpl)ClientHelper.getInstance()).isAprilFools.method_15332() != false ? new class_2588("text.rei.tiny_potato") : new class_2588("text.rei.subsets"))).onClick(button -> {
                if (this.subsetsMenu == null) {
                    this.subsetsMenu = Menu.createSubsetsMenuFromRegistry(new Point(this.subsetsButtonBounds.x, this.subsetsButtonBounds.getMaxY()));
                    this.wrappedSubsetsMenu = InternalWidgets.wrapTranslate(InternalWidgets.wrapLateRenderable(this.subsetsMenu), 0.0f, 0.0f, 400.0f);
                    this.widgets.add(this.wrappedSubsetsMenu);
                } else {
                    this.widgets.remove((Object)this.wrappedSubsetsMenu);
                    this.subsetsMenu = null;
                    this.wrappedSubsetsMenu = null;
                }
            }), 0.0f, 0.0f, 600.0f)));
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.x + this.bounds.width / 2, this.bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 10), class_333.field_18967, label -> {
                ENTRY_LIST_WIDGET.setPage(0);
                ENTRY_LIST_WIDGET.updateEntriesPosition();
            }).tooltipLine(class_1074.method_4662((String)"text.rei.go_back_first_page", (Object[])new Object[0])).focusable(false).onRender((matrices, label) -> {
                label.setClickable(ENTRY_LIST_WIDGET.getTotalPages() > 1);
                label.setText((class_2561)new class_2585(String.format("%s/%s", ENTRY_LIST_WIDGET.getPage() + 1, Math.max(ENTRY_LIST_WIDGET.getTotalPages(), 1))));
            }));
        }
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            Rectangle area = this.getCraftableToggleArea();
            class_918 itemRenderer = class_310.method_1551().method_1480();
            class_1799 icon = new class_1799((class_1935)class_2246.field_9980);
            tmp = InternalWidgets.wrapLateRenderable(InternalWidgets.mergeWidgets(Widgets.createButton(area, class_333.field_18967).focusable(false).onClick(button -> {
                ConfigManager.getInstance().toggleCraftableOnly();
                ENTRY_LIST_WIDGET.updateSearch(ScreenHelper.getSearchField().getText(), true);
            }).onRender((matrices, button) -> button.setTint(ConfigManager.getInstance().isCraftableOnlyEnabled() ? 939579655 : 956235776)).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y)).tooltipSupplier(button -> class_1074.method_4662((String)(ConfigManager.getInstance().isCraftableOnlyEnabled() ? "text.rei.showing_craftable" : "text.rei.showing_all"), (Object[])new Object[0])), Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
                class_1162 vector = new class_1162((float)(area.x + 2), (float)(area.y + 2), (float)(helper.method_25305() - 10), 1.0f);
                vector.method_22674(matrices.method_23760().method_23761());
                itemRenderer.field_4730 = vector.method_4957();
                itemRenderer.method_4010(icon, (int)vector.method_4953(), (int)vector.method_4956());
                itemRenderer.field_4730 = 0.0f;
            })));
            this.widgets.add(tmp);
            tmp.setZ(600);
        }
    }

    @ApiStatus.Experimental
    private Rectangle getSubsetsButtonBounds() {
        if (ConfigObject.getInstance().isSubsetsEnabled()) {
            if (class_310.method_1551().field_1755 instanceof RecipeViewingScreen) {
                RecipeViewingScreen widget = (RecipeViewingScreen)class_310.method_1551().field_1755;
                return new Rectangle(widget.getBounds().x, 3, widget.getBounds().width, 18);
            }
            if (class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen) {
                VillagerRecipeViewingScreen widget = (VillagerRecipeViewingScreen)class_310.method_1551().field_1755;
                return new Rectangle(widget.bounds.x, 3, widget.bounds.width, 18);
            }
            return new Rectangle(REIHelper.getInstance().getPreviousHandledScreen().field_2776, 3, REIHelper.getInstance().getPreviousHandledScreen().field_2792, 18);
        }
        return null;
    }

    private Weather getNextWeather() {
        try {
            Weather current = this.getCurrentWeather();
            int next = current.getId() + 1;
            if (next >= 3) {
                next = 0;
            }
            return Weather.byId(next);
        }
        catch (Exception e) {
            return Weather.CLEAR;
        }
    }

    private Weather getCurrentWeather() {
        class_638 world = class_310.method_1551().field_1687;
        if (world.method_8546()) {
            return Weather.THUNDER;
        }
        if (world.method_8401().method_156()) {
            return Weather.RAIN;
        }
        return Weather.CLEAR;
    }

    private String getGameModeShortText(class_1934 gameMode) {
        return class_1074.method_4662((String)("text.rei.short_gamemode." + gameMode.method_8381()), (Object[])new Object[0]);
    }

    private String getGameModeText(class_1934 gameMode) {
        return class_1074.method_4662((String)("selectWorld.gameMode." + gameMode.method_8381()), (Object[])new Object[0]);
    }

    private class_1934 getNextGameMode(boolean reverse) {
        try {
            class_1934 current = this.getCurrentGameMode();
            int next = current.method_8379() + 1;
            if (reverse) {
                next -= 2;
            }
            if (next > 3) {
                next = 0;
            }
            if (next < 0) {
                next = 3;
            }
            return class_1934.method_8384((int)next);
        }
        catch (Exception e) {
            return class_1934.field_9218;
        }
    }

    private class_1934 getCurrentGameMode() {
        return class_310.method_1551().method_1562().method_2871(class_310.method_1551().field_1724.method_7334().getId()).method_2958();
    }

    private Rectangle getSearchFieldArea() {
        int widthRemoved = 1 + (ConfigObject.getInstance().isCraftableFilterEnabled() ? 22 : 0) + (ConfigObject.getInstance().isLowerConfigButton() ? 22 : 0);
        SearchFieldLocation searchFieldLocation = ConfigObject.getInstance().getSearchFieldLocation();
        if (searchFieldLocation == SearchFieldLocation.BOTTOM_SIDE) {
            return new Rectangle(this.bounds.x + 2, this.window.method_4502() - 22, this.bounds.width - 6 - widthRemoved, 18);
        }
        if (searchFieldLocation == SearchFieldLocation.TOP_SIDE) {
            return new Rectangle(this.bounds.x + 2, 4, this.bounds.width - 6 - widthRemoved, 18);
        }
        if (class_310.method_1551().field_1755 instanceof RecipeViewingScreen) {
            RecipeViewingScreen widget = (RecipeViewingScreen)class_310.method_1551().field_1755;
            return new Rectangle(widget.getBounds().x, this.window.method_4502() - 22, widget.getBounds().width - widthRemoved, 18);
        }
        if (class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen) {
            VillagerRecipeViewingScreen widget = (VillagerRecipeViewingScreen)class_310.method_1551().field_1755;
            return new Rectangle(widget.bounds.x, this.window.method_4502() - 22, widget.bounds.width - widthRemoved, 18);
        }
        return new Rectangle(REIHelper.getInstance().getPreviousHandledScreen().field_2776, this.window.method_4502() - 22, REIHelper.getInstance().getPreviousHandledScreen().field_2792 - widthRemoved, 18);
    }

    private Rectangle getCraftableToggleArea() {
        Rectangle area = this.getSearchFieldArea();
        area.setLocation(area.x + area.width + 4, area.y - 1);
        area.setSize(20, 20);
        return area;
    }

    private Rectangle getConfigButtonArea() {
        if (ConfigObject.getInstance().isLowerConfigButton()) {
            Rectangle area = this.getSearchFieldArea();
            area.setLocation(area.x + area.width + (ConfigObject.getInstance().isCraftableFilterEnabled() ? 26 : 4), area.y - 1);
            area.setSize(20, 20);
            return area;
        }
        return new Rectangle(ConfigObject.getInstance().isLeftHandSidePanel() ? this.window.method_4486() - 30 : 10, 10, 20, 20);
    }

    private String getCheatModeText() {
        return class_1074.method_4662((String)String.format("%s%s", "text.rei.", ClientHelper.getInstance().isCheating() ? "cheat" : "nocheat"), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_465 handledScreen;
        List<class_1799> currentStacks = ClientHelper.getInstance().getInventoryItemsTypes();
        if (this.shouldReInit) {
            ENTRY_LIST_WIDGET.updateSearch(ScreenHelper.getSearchField().getText(), true);
            this.init();
        } else {
            for (DisplayHelper.DisplayBoundsHandler<?> handler : DisplayHelper.getInstance().getSortedBoundsHandlers(this.minecraft.field_1755.getClass())) {
                if (handler == null || !handler.shouldRecalculateArea(!ConfigObject.getInstance().isLeftHandSidePanel(), this.bounds)) continue;
                this.init();
                break;
            }
        }
        if (ConfigManager.getInstance().isCraftableOnlyEnabled() && (currentStacks.size() != ScreenHelper.inventoryStacks.size() || !this.hasSameListContent(new LinkedList<class_1799>(ScreenHelper.inventoryStacks), currentStacks))) {
            ScreenHelper.inventoryStacks = currentStacks;
            ENTRY_LIST_WIDGET.updateSearch(ScreenHelper.getSearchField().getText(), true);
        }
        if (OverlaySearchField.isSearching) {
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 200.0);
            if (class_310.method_1551().field_1755 instanceof class_465) {
                handledScreen = (class_465)class_310.method_1551().field_1755;
                int x = handledScreen.field_2776;
                int y = handledScreen.field_2800;
                for (class_1735 slot : handledScreen.method_17577().field_7761) {
                    if (slot.method_7681() && ENTRY_LIST_WIDGET.canLastSearchTermsBeAppliedTo(EntryStack.create(slot.method_7677()))) continue;
                    this.method_25296(matrices, x + slot.field_7873, y + slot.field_7872, x + slot.field_7873 + 16, y + slot.field_7872 + 16, -601874400, -601874400);
                }
            }
            matrices.method_22909();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderWidgets(matrices, mouseX, mouseY, delta);
        if (class_310.method_1551().field_1755 instanceof class_465 && ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            handledScreen = (class_465)class_310.method_1551().field_1755;
            for (RecipeHelper.ScreenClickArea area : RecipeHelper.getInstance().getScreenClickAreas()) {
                if (!area.getScreenClass().equals(class_310.method_1551().field_1755.getClass()) || !area.getRectangle().contains(mouseX - handledScreen.field_2776, mouseY - handledScreen.field_2800)) continue;
                String collect = CollectionUtils.mapAndJoinToString(area.getCategories(), identifier -> RecipeHelper.getInstance().getCategory((class_2960)identifier).getCategoryName(), ", ");
                TOOLTIPS.add(Tooltip.create(new class_2561[]{new class_2588("text.rei.view_recipes_for", new Object[]{collect})}));
                break;
            }
        }
    }

    public void lateRender(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_437 currentScreen;
        if (ScreenHelper.isOverlayVisible()) {
            ScreenHelper.getSearchField().laterRender(matrices, mouseX, mouseY, delta);
            for (Widget widget : this.widgets) {
                if (!(widget instanceof LateRenderable) || this.wrappedSubsetsMenu == widget || this.wrappedWeatherMenu == widget || this.wrappedGameModeMenu == widget) continue;
                widget.method_25394(matrices, mouseX, mouseY, delta);
            }
        }
        if (this.wrappedWeatherMenu != null) {
            if (this.wrappedWeatherMenu.containsMouse(mouseX, mouseY)) {
                TOOLTIPS.clear();
            }
            this.wrappedWeatherMenu.method_25394(matrices, mouseX, mouseY, delta);
        } else if (this.wrappedGameModeMenu != null) {
            if (this.wrappedGameModeMenu.containsMouse(mouseX, mouseY)) {
                TOOLTIPS.clear();
            }
            this.wrappedGameModeMenu.method_25394(matrices, mouseX, mouseY, delta);
        }
        if (this.wrappedSubsetsMenu != null) {
            TOOLTIPS.clear();
            this.wrappedSubsetsMenu.method_25394(matrices, mouseX, mouseY, delta);
        }
        if (!((currentScreen = class_310.method_1551().field_1755) instanceof RecipeViewingScreen) || !((RecipeViewingScreen)currentScreen).choosePageActivated) {
            for (Tooltip tooltip : TOOLTIPS) {
                if (tooltip == null) continue;
                this.renderTooltip(matrices, tooltip);
            }
        }
        for (Runnable runnable : AFTER_RENDER) {
            runnable.run();
        }
        TOOLTIPS.clear();
        AFTER_RENDER.clear();
    }

    public void renderTooltip(class_4587 matrices, Tooltip tooltip) {
        this.renderTooltip(matrices, tooltip.getText(), tooltip.getX(), tooltip.getY());
    }

    public void renderTooltip(class_4587 matrices, List<class_2561> lines, int mouseX, int mouseY) {
        if (lines.isEmpty()) {
            return;
        }
        this.tooltipWidth = lines.stream().map(arg_0 -> ((class_327)this.font).method_27525(arg_0)).max(Integer::compareTo).get();
        this.tooltipHeight = lines.size() <= 1 ? 8 : lines.size() * 10;
        this.tooltipLines = lines;
        ScreenHelper.drawHoveringWidget(matrices, mouseX, mouseY, this.renderTooltipCallback, this.tooltipWidth, this.tooltipHeight, 0.0f);
    }

    private boolean hasSameListContent(List<class_1799> list1, List<class_1799> list2) {
        list1.sort(Comparator.comparing(Object::toString));
        list2.sort(Comparator.comparing(Object::toString));
        return CollectionUtils.mapAndJoinToString(list1, Object::toString, "").equals(CollectionUtils.mapAndJoinToString(list2, Object::toString, ""));
    }

    public void addTooltip(@Nullable Tooltip tooltip) {
        if (tooltip != null) {
            TOOLTIPS.add(tooltip);
        }
    }

    public void renderWidgets(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (!ScreenHelper.isOverlayVisible()) {
            return;
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.leftButton.setEnabled(ENTRY_LIST_WIDGET.getTotalPages() > 1);
            this.rightButton.setEnabled(ENTRY_LIST_WIDGET.getTotalPages() > 1);
        }
        for (Widget widget : this.widgets) {
            if (widget instanceof LateRenderable) continue;
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (this.wrappedSubsetsMenu != null && this.wrappedSubsetsMenu.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.wrappedWeatherMenu != null && this.wrappedWeatherMenu.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.wrappedGameModeMenu != null && this.wrappedGameModeMenu.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.isInside(PointHelper.ofMouse())) {
            if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
                if (amount > 0.0 && this.leftButton.isEnabled()) {
                    this.leftButton.onClick();
                } else if (amount < 0.0 && this.rightButton.isEnabled()) {
                    this.rightButton.onClick();
                } else {
                    return false;
                }
                return true;
            }
            if (ENTRY_LIST_WIDGET.method_25401(mouseX, mouseY, amount)) {
                return true;
            }
        }
        if (this.isNotInExclusionZones(PointHelper.getMouseX(), PointHelper.getMouseY()) && favoritesListWidget != null && favoritesListWidget.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        for (Widget widget : this.widgets) {
            if (widget == ENTRY_LIST_WIDGET || favoritesListWidget != null && widget == favoritesListWidget || this.wrappedSubsetsMenu != null && widget == this.wrappedSubsetsMenu || this.wrappedWeatherMenu != null && widget == this.wrappedWeatherMenu || this.wrappedGameModeMenu != null && widget == this.wrappedGameModeMenu || !widget.method_25401(mouseX, mouseY, amount)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (ScreenHelper.isOverlayVisible()) {
            if (ScreenHelper.getSearchField().method_25404(int_1, int_2, int_3)) {
                return true;
            }
            for (class_364 class_3642 : this.widgets) {
                if (class_3642 == ScreenHelper.getSearchField() || !class_3642.method_25404(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesKey(int_1, int_2)) {
            ScreenHelper.toggleOverlayVisible();
            return true;
        }
        class_1799 itemStack = null;
        if (class_310.method_1551().field_1755 instanceof class_465) {
            class_465 class_4652 = (class_465)class_310.method_1551().field_1755;
            if (class_4652.field_2787 != null && !class_4652.field_2787.method_7677().method_7960()) {
                itemStack = class_4652.field_2787.method_7677();
            }
        }
        if (itemStack != null && !itemStack.method_7960()) {
            if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(int_1, int_2)) {
                return ClientHelper.getInstance().executeRecipeKeyBind(itemStack);
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesKey(int_1, int_2)) {
                return ClientHelper.getInstance().executeUsageKeyBind(itemStack);
            }
        }
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesKey(int_1, int_2)) {
            ScreenHelper.getSearchField().setFocused(true);
            this.method_25395((class_364)ScreenHelper.getSearchField());
            ScreenHelper.getSearchField().keybindFocusTime = System.currentTimeMillis();
            ScreenHelper.getSearchField().keybindFocusKey = int_1;
            return true;
        }
        return false;
    }

    public boolean method_25400(char char_1, int int_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (ScreenHelper.getSearchField().method_25400(char_1, int_1)) {
            return true;
        }
        for (class_364 class_3642 : this.widgets) {
            if (class_3642 == ScreenHelper.getSearchField() || !class_3642.method_25400(char_1, int_1)) continue;
            return true;
        }
        return false;
    }

    public List<Widget> method_25396() {
        return this.widgets;
    }

    public boolean method_25402(double double_1, double double_2, int int_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (this.wrappedSubsetsMenu != null && this.wrappedSubsetsMenu.method_25402(double_1, double_2, int_1)) {
            this.method_25395((class_364)this.wrappedSubsetsMenu);
            if (int_1 == 0) {
                this.method_25398(true);
            }
            ScreenHelper.getSearchField().setFocused(false);
            return true;
        }
        if (this.wrappedWeatherMenu != null) {
            if (this.wrappedWeatherMenu.method_25402(double_1, double_2, int_1)) {
                this.method_25395((class_364)this.wrappedWeatherMenu);
                if (int_1 == 0) {
                    this.method_25398(true);
                }
                ScreenHelper.getSearchField().setFocused(false);
                return true;
            }
            if (!this.wrappedWeatherMenu.containsMouse(double_1, double_2) && !this.weatherButton.containsMouse(double_1, double_2)) {
                this.removeWeatherMenu();
            }
        }
        if (this.wrappedGameModeMenu != null) {
            if (this.wrappedGameModeMenu.method_25402(double_1, double_2, int_1)) {
                this.method_25395((class_364)this.wrappedGameModeMenu);
                if (int_1 == 0) {
                    this.method_25398(true);
                }
                ScreenHelper.getSearchField().setFocused(false);
                return true;
            }
            if (!this.wrappedGameModeMenu.containsMouse(double_1, double_2) && !this.gameModeButton.containsMouse(double_1, double_2)) {
                this.removeGameModeMenu();
            }
        }
        if (class_310.method_1551().field_1755 instanceof class_465 && ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            class_465 handledScreen = (class_465)class_310.method_1551().field_1755;
            for (RecipeHelper.ScreenClickArea area : RecipeHelper.getInstance().getScreenClickAreas()) {
                if (!area.getScreenClass().equals(handledScreen.getClass()) || !area.getRectangle().contains(double_1 - (double)handledScreen.field_2776, double_2 - (double)handledScreen.field_2800)) continue;
                ClientHelper.getInstance().executeViewAllRecipesFromCategories(Arrays.asList(area.getCategories()));
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                return true;
            }
        }
        for (class_364 class_3642 : this.widgets) {
            if (class_3642 == this.wrappedSubsetsMenu || class_3642 == this.wrappedWeatherMenu || class_3642 == this.wrappedGameModeMenu || !class_3642.method_25402(double_1, double_2, int_1)) continue;
            this.method_25395(class_3642);
            if (int_1 == 0) {
                this.method_25398(true);
            }
            if (!(class_3642 instanceof OverlaySearchField)) {
                ScreenHelper.getSearchField().setFocused(false);
            }
            return true;
        }
        return false;
    }

    public boolean method_25403(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        return this.method_25399() != null && this.method_25397() && int_1 == 0 && this.method_25399().method_25403(double_1, double_2, int_1, double_3, double_4);
    }

    public boolean isInside(double mouseX, double mouseY) {
        return this.bounds.contains(mouseX, mouseY) && this.isNotInExclusionZones(mouseX, mouseY);
    }

    public boolean isNotInExclusionZones(double mouseX, double mouseY) {
        for (DisplayHelper.DisplayBoundsHandler<?> handler : DisplayHelper.getInstance().getSortedBoundsHandlers(class_310.method_1551().field_1755.getClass())) {
            class_1269 in = handler.isInZone(mouseX, mouseY);
            if (in == class_1269.field_5811) continue;
            return in == class_1269.field_5812;
        }
        return true;
    }

    public boolean isInside(Point point) {
        return this.isInside(point.getX(), point.getY());
    }
}

