/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.widgets.Slot;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntryWidget
extends Slot {
    protected static final class_2960 RECIPE_GUI = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    protected static final class_2960 RECIPE_GUI_DARK = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer_dark.png");
    @ApiStatus.Internal
    private byte noticeMark = 0;
    protected boolean highlight = true;
    protected boolean tooltips = true;
    protected boolean background = true;
    protected boolean interactable = true;
    protected boolean interactableFavorites = true;
    private Rectangle bounds;
    private List<EntryStack> entryStacks;

    protected EntryWidget(int x, int y) {
        this(new Point(x, y));
    }

    protected EntryWidget(Point point) {
        this.bounds = new Rectangle(point.x - 1, point.y - 1, 18, 18);
        this.entryStacks = new ArrayList<EntryStack>();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static EntryWidget create(int x, int y) {
        return EntryWidget.create(new Point(x, y));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static EntryWidget create(Point point) {
        return new EntryWidget(point);
    }

    @Override
    @NotNull
    public EntryWidget unmarkInputOrOutput() {
        this.noticeMark = 0;
        return this;
    }

    public EntryWidget markIsInput() {
        this.noticeMark = 1;
        return this;
    }

    public EntryWidget markIsOutput() {
        this.noticeMark = (byte)2;
        return this;
    }

    @Override
    public byte getNoticeMark() {
        return this.noticeMark;
    }

    @Override
    public void setNoticeMark(byte noticeMark) {
        this.noticeMark = noticeMark;
    }

    @Override
    public void setInteractable(boolean interactable) {
        this.interactable(interactable);
    }

    @Override
    public boolean isInteractable() {
        return this.interactable;
    }

    @Override
    public void setInteractableFavorites(boolean interactableFavorites) {
        this.interactableFavorites(interactableFavorites);
    }

    @Override
    public boolean isInteractableFavorites() {
        return this.interactableFavorites;
    }

    public EntryWidget disableInteractions() {
        return this.interactable(false);
    }

    @Override
    @NotNull
    public EntryWidget interactable(boolean b) {
        this.interactable = b;
        this.interactableFavorites = this.interactableFavorites && this.interactable;
        return this;
    }

    public EntryWidget disableFavoritesInteractions() {
        return this.interactableFavorites(false);
    }

    @Override
    @NotNull
    public EntryWidget interactableFavorites(boolean b) {
        this.interactableFavorites = b && this.interactable;
        return this;
    }

    public EntryWidget noHighlight() {
        return this.highlight(false);
    }

    public EntryWidget highlight(boolean b) {
        this.highlight = b;
        return this;
    }

    @Override
    public boolean isHighlightEnabled() {
        return this.highlight;
    }

    @Override
    public void setHighlightEnabled(boolean highlights) {
        this.highlight(highlights);
    }

    public EntryWidget noTooltips() {
        return this.tooltips(false);
    }

    public EntryWidget tooltips(boolean b) {
        this.tooltips = b;
        return this;
    }

    @Override
    public void setTooltipsEnabled(boolean tooltipsEnabled) {
        this.tooltips(tooltipsEnabled);
    }

    @Override
    public boolean isTooltipsEnabled() {
        return this.tooltips;
    }

    public EntryWidget noBackground() {
        return this.background(false);
    }

    public EntryWidget background(boolean b) {
        this.background = b;
        return this;
    }

    @Override
    public void setBackgroundEnabled(boolean backgroundEnabled) {
        this.background(backgroundEnabled);
    }

    @Override
    public boolean isBackgroundEnabled() {
        return this.background;
    }

    public EntryWidget clearStacks() {
        this.entryStacks.clear();
        return this;
    }

    @Override
    @NotNull
    public Slot clearEntries() {
        return this.clearStacks();
    }

    @Override
    @NotNull
    public EntryWidget entry(EntryStack stack) {
        this.entryStacks.add(stack);
        return this;
    }

    @Override
    @NotNull
    public EntryWidget entries(Collection<EntryStack> stacks) {
        this.entryStacks.addAll(stacks);
        return this;
    }

    protected EntryStack getCurrentEntry() {
        if (this.entryStacks.isEmpty()) {
            return EntryStack.empty();
        }
        if (this.entryStacks.size() == 1) {
            return this.entryStacks.get(0);
        }
        return this.entryStacks.get(class_3532.method_15357((double)((double)(System.currentTimeMillis() / 500L) % (double)this.entryStacks.size() / 1.0)));
    }

    @Override
    @NotNull
    public List<EntryStack> getEntries() {
        return this.entryStacks;
    }

    public List<EntryStack> entries() {
        return this.entryStacks;
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        return this.bounds;
    }

    protected Rectangle getInnerBounds() {
        return new Rectangle(this.bounds.x + 1, this.bounds.y + 1, this.bounds.width - 2, this.bounds.height - 2);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.drawBackground(matrices, mouseX, mouseY, delta);
        this.drawCurrentEntry(matrices, mouseX, mouseY, delta);
        boolean highlighted = this.containsMouse(mouseX, mouseY);
        if (this.hasTooltips() && highlighted) {
            this.queueTooltip(matrices, mouseX, mouseY, delta);
        }
        if (this.hasHighlight() && highlighted) {
            this.drawHighlighted(matrices, mouseX, mouseY, delta);
        }
    }

    public final boolean hasTooltips() {
        return this.tooltips;
    }

    public final boolean hasHighlight() {
        return this.highlight;
    }

    protected void drawBackground(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.background) {
            this.minecraft.method_1531().method_22813(REIHelper.getInstance().isDarkThemeEnabled() ? RECIPE_GUI_DARK : RECIPE_GUI);
            this.method_25302(matrices, this.bounds.x, this.bounds.y, 0, 222, this.bounds.width, this.bounds.height);
        }
    }

    protected void drawCurrentEntry(class_4587 matrices, int mouseX, int mouseY, float delta) {
        EntryStack entry = this.getCurrentEntry();
        entry.setZ(100);
        entry.render(matrices, this.getInnerBounds(), mouseX, mouseY, delta);
    }

    protected void queueTooltip(class_4587 matrices, int mouseX, int mouseY, float delta) {
        Tooltip tooltip = this.getCurrentTooltip(new Point(mouseX, mouseY));
        if (tooltip != null) {
            if (this.interactableFavorites && ConfigObject.getInstance().doDisplayFavoritesTooltip() && !ConfigObject.getInstance().getFavoriteKeyCode().isUnknown()) {
                String name = ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString();
                if (this.reverseFavoritesAction()) {
                    tooltip.getText().addAll(Stream.of(class_1074.method_4662((String)"text.rei.remove_favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(class_2585::new).collect(Collectors.toList()));
                } else {
                    tooltip.getText().addAll(Stream.of(class_1074.method_4662((String)"text.rei.favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(class_2585::new).collect(Collectors.toList()));
                }
            }
            tooltip.queue();
        }
    }

    @Override
    @Nullable
    public Tooltip getCurrentTooltip(Point point) {
        return this.getCurrentEntry().getTooltip(point);
    }

    protected void drawHighlighted(class_4587 matrices, int mouseX, int mouseY, float delta) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        int color = REIHelper.getInstance().isDarkThemeEnabled() ? -1877929711 : -2130706433;
        this.setZ(300);
        Rectangle bounds = this.getInnerBounds();
        this.method_25296(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), color, color);
        this.setZ(0);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.interactable) {
            return false;
        }
        if (this.containsMouse(mouseX, mouseY)) {
            if (button == 0) {
                return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentEntry());
            }
            if (button == 1) {
                return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentEntry());
            }
        }
        return false;
    }

    protected boolean reverseFavoritesAction() {
        return false;
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (!this.interactable) {
            return false;
        }
        if (this.containsMouse(PointHelper.ofMouse())) {
            if (this.interactableFavorites && ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(PointHelper.ofMouse()) && !this.getCurrentEntry().isEmpty()) {
                ModifierKeyCode keyCode = ConfigObject.getInstance().getFavoriteKeyCode();
                EntryStack entry = this.getCurrentEntry().copy();
                entry.setAmount(127);
                if (keyCode.matchesKey(int_1, int_2)) {
                    if (this.reverseFavoritesAction()) {
                        ConfigObject.getInstance().getFavorites().remove(entry);
                    } else if (!CollectionUtils.anyMatchEqualsEntryIgnoreAmount(ConfigObject.getInstance().getFavorites(), entry)) {
                        ConfigObject.getInstance().getFavorites().add(entry);
                    }
                    ConfigManager.getInstance().saveConfig();
                    if (ConfigObject.getInstance().doDisplayFavoritesOnTheLeft()) {
                        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
                        if (favoritesListWidget != null) {
                            favoritesListWidget.updateSearch(ContainerScreenOverlay.getEntryListWidget(), ScreenHelper.getSearchField().getText());
                        }
                    } else {
                        ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText());
                    }
                    this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                    return true;
                }
            }
            if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(int_1, int_2)) {
                return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentEntry());
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesKey(int_1, int_2)) {
                return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentEntry());
            }
        }
        return false;
    }
}

