/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.*;
import me.shedaniel.rei.api.widgets.Button;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.config.SearchFieldLocation;
import me.shedaniel.rei.gui.modules.entries.GameModeMenuEntry;
import me.shedaniel.rei.gui.modules.entries.WeatherMenuEntry;
import me.shedaniel.rei.gui.modules.Menu;
import me.shedaniel.rei.gui.widget.*;
import me.shedaniel.rei.impl.ClientHelperImpl;
import me.shedaniel.rei.impl.InternalWidgets;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.Weather;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1159;
import net.minecraft.class_1162;
import net.minecraft.class_1269;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_638;
import net.minecraft.class_918;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

@ApiStatus.Internal
public class ContainerScreenOverlay extends WidgetWithBounds {
    
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final List<Tooltip> TOOLTIPS = Lists.newArrayList();
    private static final List<Runnable> AFTER_RENDER = Lists.newArrayList();
    private static final EntryListWidget ENTRY_LIST_WIDGET = new EntryListWidget();
    private static FavoritesListWidget favoritesListWidget = null;
    private final List<Widget> widgets = Lists.newLinkedList();
    public boolean shouldReInit = false;
    private int tooltipWidth;
    private int tooltipHeight;
    private List<class_2561> tooltipLines;
    public final TriConsumer<class_4587, Point, Float> renderTooltipCallback = (matrices, mouse, aFloat) -> {
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        matrices.method_22903();
        matrices.method_22904(0, 0, 999);
        int x = mouse.x;
        int y = mouse.y;
        this.method_25296(matrices, x - 3, y - 4, x + tooltipWidth + 3, y - 3, -267386864, -267386864);
        this.method_25296(matrices, x - 3, y + tooltipHeight + 3, x + tooltipWidth + 3, y + tooltipHeight + 4, -267386864, -267386864);
        this.method_25296(matrices, x - 3, y - 3, x + tooltipWidth + 3, y + tooltipHeight + 3, -267386864, -267386864);
        this.method_25296(matrices, x - 4, y - 3, x - 3, y + tooltipHeight + 3, -267386864, -267386864);
        this.method_25296(matrices, x + tooltipWidth + 3, y - 3, x + tooltipWidth + 4, y + tooltipHeight + 3, -267386864, -267386864);
        this.method_25296(matrices, x - 3, y - 3 + 1, x - 3 + 1, y + tooltipHeight + 3 - 1, 1347420415, 1344798847);
        this.method_25296(matrices, x + tooltipWidth + 2, y - 3 + 1, x + tooltipWidth + 3, y + tooltipHeight + 3 - 1, 1347420415, 1344798847);
        this.method_25296(matrices, x - 3, y - 3, x + tooltipWidth + 3, y - 3 + 1, 1347420415, 1347420415);
        this.method_25296(matrices, x - 3, y + tooltipHeight + 2, x + tooltipWidth + 3, y + tooltipHeight + 3, 1344798847, 1344798847);
        int currentY = y;
        class_4597.class_4598 immediate = class_4597.method_22991(class_289.method_1348().method_1349());
        class_1159 matrix = matrices.method_23760().method_23761();
        for (int lineIndex = 0; lineIndex < tooltipLines.size(); lineIndex++) {
            font.method_22942(tooltipLines.get(lineIndex), x, currentY, -1, true, matrix, immediate, false, 0, 15728880);
            currentY += lineIndex == 0 ? 12 : 10;
        }
        immediate.method_22993();
        matrices.method_22909();
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
    };
    private Rectangle bounds;
    private class_1041 window;
    private Button leftButton, rightButton;
    @ApiStatus.Experimental
    private Rectangle subsetsButtonBounds;
    @ApiStatus.Experimental
    @Nullable
    private Menu subsetsMenu = null;
    private Widget wrappedSubsetsMenu = null;
    
    @Nullable
    private Menu weatherMenu = null;
    private Widget wrappedWeatherMenu = null;
    private boolean renderWeatherMenu = false;
    private Button weatherButton = null;
    
    @Nullable
    private Menu gameModeMenu = null;
    private Widget wrappedGameModeMenu = null;
    private boolean renderGameModeMenu = false;
    private Button gameModeButton = null;
    
    public static EntryListWidget getEntryListWidget() {
        return ENTRY_LIST_WIDGET;
    }
    
    @Nullable
    public static FavoritesListWidget getFavoritesListWidget() {
        return favoritesListWidget;
    }
    
    @ApiStatus.Experimental
    @Nullable
    public Menu getSubsetsMenu() {
        return subsetsMenu;
    }
    
    public void removeWeatherMenu() {
        this.renderWeatherMenu = false;
        Widget tmpWeatherMenu = wrappedWeatherMenu;
        AFTER_RENDER.add(() -> this.widgets.remove(tmpWeatherMenu));
        this.weatherMenu = null;
        this.wrappedWeatherMenu = null;
    }
    
    public void removeGameModeMenu() {
        this.renderGameModeMenu = false;
        Widget tmpGameModeMenu = wrappedGameModeMenu;
        AFTER_RENDER.add(() -> this.widgets.remove(tmpGameModeMenu));
        this.gameModeMenu = null;
        this.wrappedGameModeMenu = null;
    }
    
    public void init(boolean useless) {
        init();
    }
    
    public void init() {
        this.shouldReInit = false;
        //Update Variables
        this.method_25396().clear();
        this.wrappedSubsetsMenu = null;
        this.subsetsMenu = null;
        this.weatherMenu = null;
        this.renderWeatherMenu = false;
        this.weatherButton = null;
        this.window = class_310.method_1551().method_22683();
        @SuppressWarnings({"RawTypeCanBeGeneric", "rawtypes"})
        DisplayHelper.DisplayBoundsHandler boundsHandler = DisplayHelper.getInstance().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
        this.bounds = ConfigObject.getInstance().isLeftHandSidePanel() ? boundsHandler.getLeftBounds(class_310.method_1551().field_1755) : boundsHandler.getRightBounds(class_310.method_1551().field_1755);
        widgets.add(ENTRY_LIST_WIDGET);
        if (ConfigObject.getInstance().doDisplayFavoritesOnTheLeft() && ConfigObject.getInstance().isFavoritesEnabled()) {
            if (favoritesListWidget == null)
                favoritesListWidget = new FavoritesListWidget();
            widgets.add(favoritesListWidget);
        }
        ENTRY_LIST_WIDGET.updateArea(boundsHandler, ScreenHelper.getSearchField() == null ? "" : null);
        if (ScreenHelper.getSearchField() == null) {
            ScreenHelper.setSearchField(new OverlaySearchField(0, 0, 0, 0));
        }
        ScreenHelper.getSearchField().getBounds().setBounds(getSearchFieldArea());
        this.widgets.add(ScreenHelper.getSearchField());
        ScreenHelper.getSearchField().setChangedListener(s -> ENTRY_LIST_WIDGET.updateSearch(s, false));
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            widgets.add(leftButton = Widgets.createButton(new Rectangle(bounds.x, bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), new class_2588("text.rei.left_arrow"))
                    .onClick(button -> {
                        ENTRY_LIST_WIDGET.previousPage();
                        if (ENTRY_LIST_WIDGET.getPage() < 0)
                            ENTRY_LIST_WIDGET.setPage(ENTRY_LIST_WIDGET.getTotalPages() - 1);
                        ENTRY_LIST_WIDGET.updateEntriesPosition();
                    })
                    .containsMousePredicate((button, point) -> button.getBounds().contains(point) && isNotInExclusionZones(point.x, point.y))
                    .tooltipLine(class_1074.method_4662("text.rei.previous_page"))
                    .focusable(false));
            widgets.add(rightButton = Widgets.createButton(new Rectangle(bounds.x + bounds.width - 18, bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), new class_2588("text.rei.right_arrow"))
                    .onClick(button -> {
                        ENTRY_LIST_WIDGET.nextPage();
                        if (ENTRY_LIST_WIDGET.getPage() >= ENTRY_LIST_WIDGET.getTotalPages())
                            ENTRY_LIST_WIDGET.setPage(0);
                        ENTRY_LIST_WIDGET.updateEntriesPosition();
                    })
                    .containsMousePredicate((button, point) -> button.getBounds().contains(point) && isNotInExclusionZones(point.x, point.y))
                    .tooltipLine(class_1074.method_4662("text.rei.next_page"))
                    .focusable(false));
        }
        
        final Rectangle configButtonArea = getConfigButtonArea();
        Widget tmp;
        widgets.add(tmp = InternalWidgets.wrapLateRenderable(InternalWidgets.mergeWidgets(
                Widgets.createButton(configButtonArea, class_333.field_18967)
                        .onClick(button -> {
                            if (class_437.method_25442()) {
                                ClientHelper.getInstance().setCheating(!ClientHelper.getInstance().isCheating());
                                return;
                            }
                            ConfigManager.getInstance().openConfigScreen(REIHelper.getInstance().getPreviousContainerScreen());
                        })
                        .onRender((matrices, button) -> {
                            if (ClientHelper.getInstance().isCheating() && RoughlyEnoughItemsCore.hasOperatorPermission()) {
                                button.setTint(RoughlyEnoughItemsCore.hasPermissionToUsePackets() ? 721354752 : 1476440063);
                            } else {
                                button.removeTint();
                            }
                        })
                        .focusable(false)
                        .containsMousePredicate((button, point) -> button.getBounds().contains(point) && isNotInExclusionZones(point.x, point.y))
                        .tooltipSupplier(button -> {
                            String tooltips = class_1074.method_4662("text.rei.config_tooltip");
                            tooltips += "\n  ";
                            if (!ClientHelper.getInstance().isCheating())
                                tooltips += "\n" + class_1074.method_4662("text.rei.cheating_disabled");
                            else if (!RoughlyEnoughItemsCore.hasOperatorPermission())
                                tooltips += "\n" + class_1074.method_4662("text.rei.cheating_enabled_no_perms");
                            else if (RoughlyEnoughItemsCore.hasPermissionToUsePackets())
                                tooltips += "\n" + class_1074.method_4662("text.rei.cheating_enabled");
                            else
                                tooltips += "\n" + class_1074.method_4662("text.rei.cheating_limited_enabled");
                            return tooltips;
                        }),
                Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
                    helper.method_25304(helper.method_25305() + 1);
                    class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
                    helper.method_25302(matrices, configButtonArea.x + 3, configButtonArea.y + 3, 0, 0, 14, 14);
                })
                )
        ));
        tmp.setZ(600);
        if (ConfigObject.getInstance().doesShowUtilsButtons()) {
            widgets.add(gameModeButton = Widgets.createButton(ConfigObject.getInstance().isLowerConfigButton() ? new Rectangle(ConfigObject.getInstance().isLeftHandSidePanel() ? window.method_4486() - 30 : 10, 10, 20, 20) : new Rectangle(ConfigObject.getInstance().isLeftHandSidePanel() ? window.method_4486() - 55 : 35, 10, 20, 20), class_333.field_18967)
                    .onRender((matrices, button) -> {
                        boolean tmpRender = renderGameModeMenu;
                        renderGameModeMenu = !renderWeatherMenu && (button.isFocused() || button.containsMouse(PointHelper.ofMouse()) || (wrappedGameModeMenu != null && wrappedGameModeMenu.containsMouse(PointHelper.ofMouse())));
                        if (tmpRender != renderGameModeMenu) {
                            if (renderGameModeMenu) {
                                this.gameModeMenu = new Menu(new Point(button.getBounds().x, button.getBounds().getMaxY()),
                                        CollectionUtils.filterAndMap(Arrays.asList(class_1934.values()), mode -> mode != class_1934.field_9218, GameModeMenuEntry::new));
                                if (ConfigObject.getInstance().isLeftHandSidePanel())
                                    this.gameModeMenu.menuStartPoint.x -= this.gameModeMenu.getBounds().width - this.gameModeButton.getBounds().width;
                                this.wrappedGameModeMenu = InternalWidgets.wrapTranslate(InternalWidgets.wrapLateRenderable(gameModeMenu), 0, 0, 600);
                                AFTER_RENDER.add(() -> this.widgets.add(wrappedGameModeMenu));
                            } else {
                                removeGameModeMenu();
                            }
                        }
                        button.setText(new class_2585(getGameModeShortText(getCurrentGameMode())));
                    })
                    .focusable(false)
                    .tooltipLine(class_1074.method_4662("text.rei.gamemode_button.tooltip.all"))
                    .containsMousePredicate((button, point) -> button.getBounds().contains(point) && isNotInExclusionZones(point.x, point.y)));
            widgets.add(weatherButton = Widgets.createButton(new Rectangle(ConfigObject.getInstance().isLeftHandSidePanel() ? window.method_4486() - 30 : 10, 35, 20, 20), class_333.field_18967)
                    .onRender((matrices, button) -> {
                        boolean tmpRender = renderWeatherMenu;
                        renderWeatherMenu = !renderGameModeMenu && (button.isFocused() || button.containsMouse(PointHelper.ofMouse()) || (wrappedWeatherMenu != null && wrappedWeatherMenu.containsMouse(PointHelper.ofMouse())));
                        if (tmpRender != renderWeatherMenu) {
                            if (renderWeatherMenu) {
                                this.weatherMenu = new Menu(new Point(button.getBounds().x, button.getBounds().getMaxY()),
                                        CollectionUtils.map(Weather.values(), WeatherMenuEntry::new));
                                if (ConfigObject.getInstance().isLeftHandSidePanel())
                                    this.weatherMenu.menuStartPoint.x -= this.weatherMenu.getBounds().width - this.weatherButton.getBounds().width;
                                this.wrappedWeatherMenu = InternalWidgets.wrapTranslate(InternalWidgets.wrapLateRenderable(weatherMenu), 0, 0, 400);
                                AFTER_RENDER.add(() -> this.widgets.add(wrappedWeatherMenu));
                            } else {
                                removeWeatherMenu();
                            }
                        }
                    })
                    .tooltipLine(class_1074.method_4662("text.rei.weather_button.tooltip.all"))
                    .focusable(false)
                    .containsMousePredicate((button, point) -> button.getBounds().contains(point) && isNotInExclusionZones(point.x, point.y)));
            widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
                class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
                RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
                helper.method_25302(matrices, weatherButton.getBounds().x + 3, weatherButton.getBounds().y + 3, getCurrentWeather().getId() * 14, 14, 14, 14);
            }));
        }
        subsetsButtonBounds = getSubsetsButtonBounds();
        if (ConfigObject.getInstance().isSubsetsEnabled()) {
            widgets.add(InternalWidgets.wrapLateRenderable(InternalWidgets.wrapTranslate(Widgets.createButton(subsetsButtonBounds, ((ClientHelperImpl) ClientHelper.getInstance()).isAprilFools.method_15332() ? new class_2588("text.rei.tiny_potato") : new class_2588("text.rei.subsets"))
                    .onClick(button -> {
                        if (subsetsMenu == null) {
                            wrappedSubsetsMenu = InternalWidgets.wrapTranslate(InternalWidgets.wrapLateRenderable(this.subsetsMenu = Menu.createSubsetsMenuFromRegistry(new Point(this.subsetsButtonBounds.x, this.subsetsButtonBounds.getMaxY()))), 0, 0, 400);
                            this.widgets.add(this.wrappedSubsetsMenu);
                        } else {
                            this.widgets.remove(this.wrappedSubsetsMenu);
                            this.subsetsMenu = null;
                            this.wrappedSubsetsMenu = null;
                        }
                    }), 0, 0, 600)));
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            widgets.add(Widgets.createClickableLabel(new Point(bounds.x + (bounds.width / 2), bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 10), class_333.field_18967, label -> {
                ENTRY_LIST_WIDGET.setPage(0);
                ENTRY_LIST_WIDGET.updateEntriesPosition();
            }).tooltipLine(class_1074.method_4662("text.rei.go_back_first_page")).focusable(false).onRender((matrices, label) -> {
                label.setClickable(ENTRY_LIST_WIDGET.getTotalPages() > 1);
                label.setText(new class_2585(String.format("%s/%s", ENTRY_LIST_WIDGET.getPage() + 1, Math.max(ENTRY_LIST_WIDGET.getTotalPages(), 1))));
            }));
        }
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            Rectangle area = getCraftableToggleArea();
            class_918 itemRenderer = class_310.method_1551().method_1480();
            class_1799 icon = new class_1799(class_2246.field_9980);
            this.widgets.add(tmp = InternalWidgets.wrapLateRenderable(InternalWidgets.mergeWidgets(
                    Widgets.createButton(area, class_333.field_18967)
                            .focusable(false)
                            .onClick(button -> {
                                ConfigManager.getInstance().toggleCraftableOnly();
                                ENTRY_LIST_WIDGET.updateSearch(ScreenHelper.getSearchField().getText(), true);
                            })
                            .onRender((matrices, button) -> button.setTint(ConfigManager.getInstance().isCraftableOnlyEnabled() ? 939579655 : 956235776))
                            .containsMousePredicate((button, point) -> button.getBounds().contains(point) && isNotInExclusionZones(point.x, point.y))
                            .tooltipSupplier(button -> class_1074.method_4662(ConfigManager.getInstance().isCraftableOnlyEnabled() ? "text.rei.showing_craftable" : "text.rei.showing_all")),
                    Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
                        class_1162 vector = new class_1162(area.x + 2, area.y + 2, helper.method_25305() - 10, 1.0F);
                        vector.method_22674(matrices.method_23760().method_23761());
                        itemRenderer.field_4730 = vector.method_4957();
                        itemRenderer.method_4010(icon, (int) vector.method_4953(), (int) vector.method_4956());
                        itemRenderer.field_4730 = 0.0F;
                    }))
            ));
            tmp.setZ(600);
        }
    }
    
    @ApiStatus.Experimental
    private Rectangle getSubsetsButtonBounds() {
        if (ConfigObject.getInstance().isSubsetsEnabled()) {
            if (class_310.method_1551().field_1755 instanceof RecipeViewingScreen) {
                RecipeViewingScreen widget = (RecipeViewingScreen) class_310.method_1551().field_1755;
                return new Rectangle(widget.getBounds().x, 3, widget.getBounds().width, 18);
            }
            if (class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen) {
                VillagerRecipeViewingScreen widget = (VillagerRecipeViewingScreen) class_310.method_1551().field_1755;
                return new Rectangle(widget.bounds.x, 3, widget.bounds.width, 18);
            }
            return new Rectangle(REIHelper.getInstance().getPreviousContainerScreen().field_2776, 3, REIHelper.getInstance().getPreviousContainerScreen().field_2792, 18);
        }
        return null;
    }
    
    private Weather getNextWeather() {
        try {
            Weather current = getCurrentWeather();
            int next = current.getId() + 1;
            if (next >= 3)
                next = 0;
            return Weather.byId(next);
        } catch (Exception e) {
            return Weather.CLEAR;
        }
    }
    
    private Weather getCurrentWeather() {
        class_638 world = class_310.method_1551().field_1687;
        if (world.method_8546())
            return Weather.THUNDER;
        if (world.method_28104().method_156())
            return Weather.RAIN;
        return Weather.CLEAR;
    }
    
    private String getGameModeShortText(class_1934 gameMode) {
        return class_1074.method_4662("text.rei.short_gamemode." + gameMode.method_8381());
    }
    
    private String getGameModeText(class_1934 gameMode) {
        return class_1074.method_4662("selectWorld.gameMode." + gameMode.method_8381());
    }
    
    private class_1934 getNextGameMode(boolean reverse) {
        try {
            class_1934 current = getCurrentGameMode();
            int next = current.method_8379() + 1;
            if (reverse)
                next -= 2;
            if (next > 3)
                next = 0;
            if (next < 0)
                next = 3;
            return class_1934.method_8384(next);
        } catch (Exception e) {
            return class_1934.field_9218;
        }
    }
    
    private class_1934 getCurrentGameMode() {
        return class_310.method_1551().method_1562().method_2871(class_310.method_1551().field_1724.method_7334().getId()).method_2958();
    }
    
    private Rectangle getSearchFieldArea() {
        int widthRemoved = 1 + (ConfigObject.getInstance().isCraftableFilterEnabled() ? 22 : 0) + (ConfigObject.getInstance().isLowerConfigButton() ? 22 : 0);
        SearchFieldLocation searchFieldLocation = ConfigObject.getInstance().getSearchFieldLocation();
        if (searchFieldLocation == SearchFieldLocation.BOTTOM_SIDE)
            return new Rectangle(bounds.x + 2, window.method_4502() - 22, bounds.width - 6 - widthRemoved, 18);
        if (searchFieldLocation == SearchFieldLocation.TOP_SIDE)
            return new Rectangle(bounds.x + 2, 4, bounds.width - 6 - widthRemoved, 18);
        if (class_310.method_1551().field_1755 instanceof RecipeViewingScreen) {
            RecipeViewingScreen widget = (RecipeViewingScreen) class_310.method_1551().field_1755;
            return new Rectangle(widget.getBounds().x, window.method_4502() - 22, widget.getBounds().width - widthRemoved, 18);
        }
        if (class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen) {
            VillagerRecipeViewingScreen widget = (VillagerRecipeViewingScreen) class_310.method_1551().field_1755;
            return new Rectangle(widget.bounds.x, window.method_4502() - 22, widget.bounds.width - widthRemoved, 18);
        }
        return new Rectangle(REIHelper.getInstance().getPreviousContainerScreen().field_2776, window.method_4502() - 22, REIHelper.getInstance().getPreviousContainerScreen().field_2792 - widthRemoved, 18);
    }
    
    private Rectangle getCraftableToggleArea() {
        Rectangle area = getSearchFieldArea();
        area.setLocation(area.x + area.width + 4, area.y - 1);
        area.setSize(20, 20);
        return area;
    }
    
    private Rectangle getConfigButtonArea() {
        if (ConfigObject.getInstance().isLowerConfigButton()) {
            Rectangle area = getSearchFieldArea();
            area.setLocation(area.x + area.width + (ConfigObject.getInstance().isCraftableFilterEnabled() ? 26 : 4), area.y - 1);
            area.setSize(20, 20);
            return area;
        }
        return new Rectangle(ConfigObject.getInstance().isLeftHandSidePanel() ? window.method_4486() - 30 : 10, 10, 20, 20);
    }
    
    private String getCheatModeText() {
        return class_1074.method_4662(String.format("%s%s", "text.rei.", ClientHelper.getInstance().isCheating() ? "cheat" : "nocheat"));
    }
    
    @NotNull
    @Override
    public Rectangle getBounds() {
        return bounds;
    }
    
    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        List<class_1799> currentStacks = ClientHelper.getInstance().getInventoryItemsTypes();
        if (shouldReInit) {
            ENTRY_LIST_WIDGET.updateSearch(ScreenHelper.getSearchField().getText(), true);
            init();
        } else {
            for (DisplayHelper.DisplayBoundsHandler<?> handler : DisplayHelper.getInstance().getSortedBoundsHandlers(minecraft.field_1755.getClass())) {
                if (handler != null && handler.shouldRecalculateArea(!ConfigObject.getInstance().isLeftHandSidePanel(), bounds)) {
                    init();
                    break;
                }
            }
        }
        if (ConfigManager.getInstance().isCraftableOnlyEnabled() && ((currentStacks.size() != ScreenHelper.inventoryStacks.size()) || !hasSameListContent(new LinkedList<>(ScreenHelper.inventoryStacks), currentStacks))) {
            ScreenHelper.inventoryStacks = currentStacks;
            ENTRY_LIST_WIDGET.updateSearch(ScreenHelper.getSearchField().getText(), true);
        }
        if (OverlaySearchField.isSearching) {
            matrices.method_22903();
            matrices.method_22904(0, 0, 200f);
            if (class_310.method_1551().field_1755 instanceof class_465) {
                class_465<?> containerScreen = (class_465<?>) class_310.method_1551().field_1755;
                int x = containerScreen.field_2776, y = containerScreen.field_2800;
                for (class_1735 slot : containerScreen.method_17577().field_7761)
                    if (!slot.method_7681() || !ENTRY_LIST_WIDGET.canLastSearchTermsBeAppliedTo(EntryStack.create(slot.method_7677())))
                        method_25296(matrices, x + slot.field_7873, y + slot.field_7872, x + slot.field_7873 + 16, y + slot.field_7872 + 16, -601874400, -601874400);
            }
            matrices.method_22909();
        }
        RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.renderWidgets(matrices, mouseX, mouseY, delta);
        if (class_310.method_1551().field_1755 instanceof class_465 && ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            class_465<?> containerScreen = (class_465<?>) class_310.method_1551().field_1755;
            for (RecipeHelper.ScreenClickArea area : RecipeHelper.getInstance().getScreenClickAreas())
                if (area.getScreenClass().equals(class_310.method_1551().field_1755.getClass()))
                    if (area.getRectangle().contains(mouseX - containerScreen.field_2776, mouseY - containerScreen.field_2800)) {
                        String collect = CollectionUtils.mapAndJoinToString(area.getCategories(), identifier -> RecipeHelper.getInstance().getCategory(identifier).getCategoryName(), ", ");
                        TOOLTIPS.add(Tooltip.create(new class_2588("text.rei.view_recipes_for", collect)));
                        break;
                    }
        }
    }
    
    public void lateRender(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (ScreenHelper.isOverlayVisible()) {
            ScreenHelper.getSearchField().laterRender(matrices, mouseX, mouseY, delta);
            for (Widget widget : widgets) {
                if (widget instanceof LateRenderable && wrappedSubsetsMenu != widget && wrappedWeatherMenu != widget && wrappedGameModeMenu != widget)
                    widget.method_25394(matrices, mouseX, mouseY, delta);
            }
        }
        if (wrappedWeatherMenu != null) {
            if (wrappedWeatherMenu.containsMouse(mouseX, mouseY)) {
                TOOLTIPS.clear();
            }
            wrappedWeatherMenu.method_25394(matrices, mouseX, mouseY, delta);
        } else if (wrappedGameModeMenu != null) {
            if (wrappedGameModeMenu.containsMouse(mouseX, mouseY)) {
                TOOLTIPS.clear();
            }
            wrappedGameModeMenu.method_25394(matrices, mouseX, mouseY, delta);
        }
        if (wrappedSubsetsMenu != null) {
            TOOLTIPS.clear();
            wrappedSubsetsMenu.method_25394(matrices, mouseX, mouseY, delta);
        }
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (!(currentScreen instanceof RecipeViewingScreen) || !((RecipeViewingScreen) currentScreen).choosePageActivated)
            for (Tooltip tooltip : TOOLTIPS) {
                if (tooltip != null)
                    renderTooltip(matrices, tooltip);
            }
        for (Runnable runnable : AFTER_RENDER) {
            runnable.run();
        }
        TOOLTIPS.clear();
        AFTER_RENDER.clear();
    }
    
    public void renderTooltip(class_4587 matrices, Tooltip tooltip) {
        renderTooltip(matrices, tooltip.getText(), tooltip.getX(), tooltip.getY());
    }
    
    public void renderTooltip(class_4587 matrices, List<class_2561> lines, int mouseX, int mouseY) {
        if (lines.isEmpty())
            return;
        tooltipWidth = lines.stream().map(font::method_27525).max(Integer::compareTo).get();
        tooltipHeight = lines.size() <= 1 ? 8 : lines.size() * 10;
        tooltipLines = lines;
        ScreenHelper.drawHoveringWidget(matrices, mouseX, mouseY, renderTooltipCallback, tooltipWidth, tooltipHeight, 0);
    }
    
    private boolean hasSameListContent(List<class_1799> list1, List<class_1799> list2) {
        list1.sort(Comparator.comparing(Object::toString));
        list2.sort(Comparator.comparing(Object::toString));
        return CollectionUtils.mapAndJoinToString(list1, Object::toString, "").equals(CollectionUtils.mapAndJoinToString(list2, Object::toString, ""));
    }
    
    public void addTooltip(@Nullable Tooltip tooltip) {
        if (tooltip != null)
            TOOLTIPS.add(tooltip);
    }
    
    public void renderWidgets(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (!ScreenHelper.isOverlayVisible())
            return;
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            leftButton.setEnabled(ENTRY_LIST_WIDGET.getTotalPages() > 1);
            rightButton.setEnabled(ENTRY_LIST_WIDGET.getTotalPages() > 1);
        }
        for (Widget widget : widgets) {
            if (!(widget instanceof LateRenderable))
                widget.method_25394(matrices, mouseX, mouseY, delta);
        }
    }
    
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!ScreenHelper.isOverlayVisible())
            return false;
        if (wrappedSubsetsMenu != null && wrappedSubsetsMenu.method_25401(mouseX, mouseY, amount))
            return true;
        if (wrappedWeatherMenu != null && wrappedWeatherMenu.method_25401(mouseX, mouseY, amount))
            return true;
        if (wrappedGameModeMenu != null && wrappedGameModeMenu.method_25401(mouseX, mouseY, amount))
            return true;
        if (isInside(PointHelper.ofMouse())) {
            if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
                if (amount > 0 && leftButton.isEnabled())
                    leftButton.onClick();
                else if (amount < 0 && rightButton.isEnabled())
                    rightButton.onClick();
                else
                    return false;
                return true;
            } else if (ENTRY_LIST_WIDGET.method_25401(mouseX, mouseY, amount))
                return true;
        }
        if (isNotInExclusionZones(PointHelper.getMouseX(), PointHelper.getMouseY())) {
            if (favoritesListWidget != null && favoritesListWidget.method_25401(mouseX, mouseY, amount))
                return true;
        }
        for (Widget widget : widgets)
            if (widget != ENTRY_LIST_WIDGET && (favoritesListWidget == null || widget != favoritesListWidget)
                && (wrappedSubsetsMenu == null || widget != wrappedSubsetsMenu)
                && (wrappedWeatherMenu == null || widget != wrappedWeatherMenu)
                && (wrappedGameModeMenu == null || widget != wrappedGameModeMenu)
                && widget.method_25401(mouseX, mouseY, amount))
                return true;
        return false;
    }
    
    @Override
    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (ScreenHelper.isOverlayVisible()) {
            if (ScreenHelper.getSearchField().method_25404(int_1, int_2, int_3))
                return true;
            for (class_364 listener : widgets)
                if (listener != ScreenHelper.getSearchField() && listener.method_25404(int_1, int_2, int_3))
                    return true;
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesKey(int_1, int_2)) {
            ScreenHelper.toggleOverlayVisible();
            return true;
        }
        class_1799 itemStack = null;
        if (class_310.method_1551().field_1755 instanceof class_465) {
            class_465<?> containerScreen = (class_465<?>) class_310.method_1551().field_1755;
            if (containerScreen.field_2787 != null && !containerScreen.field_2787.method_7677().method_7960())
                itemStack = containerScreen.field_2787.method_7677();
        }
        if (itemStack != null && !itemStack.method_7960()) {
            if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(int_1, int_2))
                return ClientHelper.getInstance().executeRecipeKeyBind(itemStack);
            else if (ConfigObject.getInstance().getUsageKeybind().matchesKey(int_1, int_2))
                return ClientHelper.getInstance().executeUsageKeyBind(itemStack);
        }
        if (!ScreenHelper.isOverlayVisible())
            return false;
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesKey(int_1, int_2)) {
            ScreenHelper.getSearchField().setFocused(true);
            method_25395(ScreenHelper.getSearchField());
            ScreenHelper.getSearchField().keybindFocusTime = System.currentTimeMillis();
            ScreenHelper.getSearchField().keybindFocusKey = int_1;
            return true;
        }
        return false;
    }
    
    @Override
    public boolean method_25400(char char_1, int int_1) {
        if (!ScreenHelper.isOverlayVisible())
            return false;
        if (ScreenHelper.getSearchField().method_25400(char_1, int_1))
            return true;
        for (class_364 listener : widgets)
            if (listener != ScreenHelper.getSearchField() && listener.method_25400(char_1, int_1))
                return true;
        return false;
    }
    
    @Override
    public List<Widget> method_25396() {
        return widgets;
    }
    
    @Override
    public boolean method_25402(double double_1, double double_2, int int_1) {
        if (!ScreenHelper.isOverlayVisible())
            return false;
        if (wrappedSubsetsMenu != null && wrappedSubsetsMenu.method_25402(double_1, double_2, int_1)) {
            this.method_25395(wrappedSubsetsMenu);
            if (int_1 == 0)
                this.method_25398(true);
            ScreenHelper.getSearchField().setFocused(false);
            return true;
        }
        if (wrappedWeatherMenu != null) {
            if (wrappedWeatherMenu.method_25402(double_1, double_2, int_1)) {
                this.method_25395(wrappedWeatherMenu);
                if (int_1 == 0)
                    this.method_25398(true);
                ScreenHelper.getSearchField().setFocused(false);
                return true;
            } else if (!wrappedWeatherMenu.containsMouse(double_1, double_2) && !weatherButton.containsMouse(double_1, double_2)) {
                removeWeatherMenu();
            }
        }
        if (wrappedGameModeMenu != null) {
            if (wrappedGameModeMenu.method_25402(double_1, double_2, int_1)) {
                this.method_25395(wrappedGameModeMenu);
                if (int_1 == 0)
                    this.method_25398(true);
                ScreenHelper.getSearchField().setFocused(false);
                return true;
            } else if (!wrappedGameModeMenu.containsMouse(double_1, double_2) && !gameModeButton.containsMouse(double_1, double_2)) {
                removeGameModeMenu();
            }
        }
        if (class_310.method_1551().field_1755 instanceof class_465 && ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            class_465<?> containerScreen = (class_465<?>) class_310.method_1551().field_1755;
            for (RecipeHelper.ScreenClickArea area : RecipeHelper.getInstance().getScreenClickAreas())
                if (area.getScreenClass().equals(containerScreen.getClass()))
                    if (area.getRectangle().contains(double_1 - containerScreen.field_2776, double_2 - containerScreen.field_2800)) {
                        ClientHelper.getInstance().executeViewAllRecipesFromCategories(Arrays.asList(area.getCategories()));
                        class_310.method_1551().method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
                        return true;
                    }
        }
        for (class_364 element : widgets)
            if (element != wrappedSubsetsMenu && element != wrappedWeatherMenu && element != wrappedGameModeMenu && element.method_25402(double_1, double_2, int_1)) {
                this.method_25395(element);
                if (int_1 == 0)
                    this.method_25398(true);
                if (!(element instanceof OverlaySearchField))
                    ScreenHelper.getSearchField().setFocused(false);
                return true;
            }
        return false;
    }
    
    @Override
    public boolean method_25403(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (!ScreenHelper.isOverlayVisible())
            return false;
        return (this.method_25399() != null && this.method_25397() && int_1 == 0) && this.method_25399().method_25403(double_1, double_2, int_1, double_3, double_4);
    }
    
    public boolean isInside(double mouseX, double mouseY) {
        return bounds.contains(mouseX, mouseY) && isNotInExclusionZones(mouseX, mouseY);
    }
    
    public boolean isNotInExclusionZones(double mouseX, double mouseY) {
        for (DisplayHelper.DisplayBoundsHandler<?> handler : DisplayHelper.getInstance().getSortedBoundsHandlers(class_310.method_1551().field_1755.getClass())) {
            class_1269 in = handler.isInZone(mouseX, mouseY);
            if (in != class_1269.field_5811)
                return in == class_1269.field_5812;
        }
        return true;
    }
    
    public boolean isInside(Point point) {
        return isInside(point.getX(), point.getY());
    }
    
}
