/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.OptimalEntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.config.ItemListOrdering;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.SearchArgument;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1159;
import net.minecraft.class_1269;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EntryListWidget
extends WidgetWithBounds {
    static final Supplier<Boolean> RENDER_ENCHANTMENT_GLINT = ConfigObject.getInstance()::doesRenderEntryEnchantmentGlint;
    static final Comparator<? super EntryStack> ENTRY_NAME_COMPARER = Comparator.comparing(SearchArgument::tryGetEntryStackName);
    static final Comparator<? super EntryStack> ENTRY_GROUP_COMPARER = Comparator.comparingInt(stack -> {
        class_1761 group;
        if (stack.getType() == EntryStack.Type.ITEM && (group = stack.getItem().method_7859()) != null) {
            return group.method_7741();
        }
        return Integer.MAX_VALUE;
    });
    private static final int SIZE = 18;
    private static final boolean LAZY = true;
    private static int page;
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return EntryListWidget.this.getBounds();
        }

        public int getMaxScrollHeight() {
            if (EntryListWidget.this.favorites.isEmpty()) {
                return class_3532.method_15386((float)((float)(EntryListWidget.this.allStacks.size() + EntryListWidget.this.blockedCount) / ((float)((EntryListWidget)EntryListWidget.this).innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
            }
            return class_3532.method_15386((float)((float)(EntryListWidget.this.allStacks.size() + EntryListWidget.this.blockedCount + EntryListWidget.this.getScrollNumberForFavorites()) / ((float)((EntryListWidget)EntryListWidget.this).innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize() - 12;
        }
    };
    protected int blockedCount;
    private boolean debugTime;
    private Rectangle bounds;
    private Rectangle innerBounds;
    private List<EntryStack> allStacks = null;
    private List<EntryStack> favorites = null;
    private List<EntryListEntry> entries = Collections.emptyList();
    private List<Widget> renders = Collections.emptyList();
    private List<Widget> widgets = Collections.emptyList();
    private List<SearchArgument.SearchArguments> lastSearchArguments = Collections.emptyList();
    private String lastSearchTerm = null;

    public static int entrySize() {
        return class_3532.method_15384((double)(18.0 * ConfigObject.getInstance().getEntrySize()));
    }

    static boolean notSteppingOnExclusionZones(int left, int top, Rectangle listArea) {
        class_310 instance = class_310.method_1551();
        for (DisplayHelper.DisplayBoundsHandler<?> sortedBoundsHandler : DisplayHelper.getInstance().getSortedBoundsHandlers(instance.field_1755.getClass())) {
            class_1269 fit = sortedBoundsHandler.canItemSlotWidgetFit(left, top, instance.field_1755, listArea);
            if (fit == class_1269.field_5811) continue;
            return fit == class_1269.field_5812;
        }
        return true;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / (float)EntryListWidget.entrySize())), 1);
            if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f) + 3.0f), bounds.y, width * EntryListWidget.entrySize(), bounds.height);
            }
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f) - 3.0f), bounds.y, width * EntryListWidget.entrySize(), bounds.height);
        }
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2) / (float)EntryListWidget.entrySize())), 1);
        int height = Math.max(class_3532.method_15375((float)((float)(bounds.height - 2) / (float)EntryListWidget.entrySize())), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f)), (int)((float)bounds.getCenterY() - (float)height * ((float)EntryListWidget.entrySize() / 2.0f)), width * EntryListWidget.entrySize(), height * EntryListWidget.entrySize());
    }

    protected final int getSlotsHeightNumberForFavorites() {
        if (this.favorites.isEmpty()) {
            return 0;
        }
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            return class_3532.method_15386((float)(2.0f + (float)this.favorites.size() / ((float)this.innerBounds.width / (float)EntryListWidget.entrySize())));
        }
        int height = class_3532.method_15386((float)((float)this.favorites.size() / ((float)this.innerBounds.width / (float)EntryListWidget.entrySize())));
        int pagesToFit = class_3532.method_15386((float)((float)height / ((float)this.innerBounds.height / (float)EntryListWidget.entrySize() - 1.0f)));
        if (height > this.innerBounds.height / EntryListWidget.entrySize() - 1 && height % (this.innerBounds.height / EntryListWidget.entrySize()) == this.innerBounds.height / EntryListWidget.entrySize() - 2) {
            --height;
        }
        return height + pagesToFit + 1;
    }

    protected final int getScrollNumberForFavorites() {
        if (this.favorites.isEmpty()) {
            return 0;
        }
        return this.innerBounds.width / EntryListWidget.entrySize() * this.getSlotsHeightNumberForFavorites();
    }

    public boolean method_25401(double double_1, double double_2, double double_3) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled() && this.bounds.contains(double_1, double_2)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            return true;
        }
        return super.method_25401(double_1, double_2, double_3);
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        EntryListWidget.page = page;
    }

    public void previousPage() {
        --page;
    }

    public void nextPage() {
        ++page;
    }

    public int getTotalPages() {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            return 1;
        }
        return class_3532.method_15386((float)((float)(this.allStacks.size() + this.getScrollNumberForFavorites()) / (float)this.entries.size()));
    }

    /*
     * WARNING - void declaration
     */
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int nextIndex;
            for (EntryListEntry entryListEntry2 : this.entries) {
                entryListEntry2.clearStacks();
            }
            ScissorsHandler.INSTANCE.scissor(this.bounds);
            int sizeForFavorites = this.getSlotsHeightNumberForFavorites();
            int n = Math.max(0, class_3532.method_15357((double)(this.scrolling.scrollAmount / (double)EntryListWidget.entrySize())) - sizeForFavorites);
            int i = nextIndex = n * this.innerBounds.width / EntryListWidget.entrySize();
            this.blockedCount = 0;
            if (this.debugTime) {
                void var11_30;
                int offset;
                long l;
                EntryListEntry entry;
                long totalTimeStart = System.nanoTime();
                boolean bl = false;
                long time = 0L;
                if (sizeForFavorites > 0) {
                    this.method_27535(matrices, this.font, (class_2561)new class_2588("text.rei.favorites"), this.innerBounds.x + 2, (int)((double)(this.innerBounds.y + 8) - this.scrolling.scrollAmount), -1);
                    nextIndex += this.innerBounds.width / EntryListWidget.entrySize();
                    block1: for (EntryStack stack : this.favorites) {
                        while (true) {
                            entry = this.entries.get(nextIndex);
                            entry.getBounds().y = (int)((double)entry.backupY - this.scrolling.scrollAmount);
                            if (entry.getBounds().y > this.bounds.getMaxY()) break block1;
                            if (EntryListWidget.notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, this.innerBounds)) {
                                void var11_29;
                                entry.entry(stack);
                                entry.isFavorites = true;
                                ++var11_29;
                                l = System.currentTimeMillis();
                                entry.method_25394(matrices, mouseX, mouseY, delta);
                                time += System.currentTimeMillis() - l;
                                ++nextIndex;
                                continue block1;
                            }
                            ++this.blockedCount;
                            ++nextIndex;
                        }
                    }
                    nextIndex += this.innerBounds.width / -EntryListWidget.entrySize() + this.getScrollNumberForFavorites() - this.favorites.size();
                }
                int n2 = offset = sizeForFavorites > 0 ? -12 : 0;
                block3: while (i < this.allStacks.size()) {
                    EntryStack stack;
                    stack = this.allStacks.get(i);
                    while (true) {
                        entry = this.entries.get(nextIndex);
                        entry.getBounds().y = (int)((double)entry.backupY - this.scrolling.scrollAmount + (double)offset);
                        if (entry.getBounds().y > this.bounds.getMaxY()) break block3;
                        if (EntryListWidget.notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, this.innerBounds)) {
                            entry.entry(stack);
                            entry.isFavorites = false;
                            if (!entry.getCurrentEntry().isEmpty()) {
                                ++var11_30;
                                l = System.nanoTime();
                                entry.method_25394(matrices, mouseX, mouseY, delta);
                                time += System.nanoTime() - l;
                            }
                            ++nextIndex;
                            break;
                        }
                        ++this.blockedCount;
                        ++nextIndex;
                    }
                    ++i;
                }
                long totalTime = System.nanoTime() - totalTimeStart;
                int z = this.getZ();
                this.setZ(500);
                class_2585 debugText = new class_2585(String.format("%d entries, avg. %.0fns, ttl. %.0fms, %s fps", (int)var11_30, (double)time / (double)var11_30, (double)totalTime / 1000000.0, this.minecraft.field_1770.split(" ")[0]));
                int n3 = this.bounds.x;
                int n4 = this.bounds.y;
                int n5 = this.bounds.x + this.font.method_27525((class_2561)debugText) + 2;
                int n6 = this.bounds.y;
                this.font.getClass();
                this.method_25296(matrices, n3, n4, n5, n6 + 9 + 2, -16777216, -16777216);
                class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
                matrices.method_22903();
                matrices.method_22904(0.0, 0.0, (double)this.getZ());
                class_1159 matrix = matrices.method_23760().method_23761();
                this.font.method_22942((class_2561)debugText, (float)(this.bounds.x + 2), (float)(this.bounds.y + 2), -1, false, matrix, (class_4597)immediate, false, 0, 0xF000F0);
                immediate.method_22993();
                this.setZ(z);
                matrices.method_22909();
            } else {
                int offset;
                if (sizeForFavorites > 0) {
                    this.method_27535(matrices, this.font, (class_2561)new class_2588("text.rei.favorites"), this.innerBounds.x + 2, (int)((double)(this.innerBounds.y + 8) - this.scrolling.scrollAmount), -1);
                    nextIndex += this.innerBounds.width / EntryListWidget.entrySize();
                    block5: for (EntryStack stack : this.favorites) {
                        while (true) {
                            EntryListEntry entryListEntry3 = this.entries.get(nextIndex);
                            entryListEntry3.getBounds().y = (int)((double)entryListEntry3.backupY - this.scrolling.scrollAmount);
                            if (entryListEntry3.getBounds().y > this.bounds.getMaxY()) break block5;
                            if (EntryListWidget.notSteppingOnExclusionZones(entryListEntry3.getBounds().x, entryListEntry3.getBounds().y, this.innerBounds)) {
                                entryListEntry3.entry(stack);
                                entryListEntry3.isFavorites = true;
                                entryListEntry3.method_25394(matrices, mouseX, mouseY, delta);
                                ++nextIndex;
                                continue block5;
                            }
                            ++this.blockedCount;
                            ++nextIndex;
                        }
                    }
                    nextIndex += this.innerBounds.width / -EntryListWidget.entrySize() + this.getScrollNumberForFavorites() - this.favorites.size();
                }
                int n7 = offset = sizeForFavorites > 0 ? -12 : 0;
                block7: while (i < this.allStacks.size()) {
                    EntryStack stack;
                    stack = this.allStacks.get(i);
                    while (true) {
                        EntryListEntry entryListEntry4 = this.entries.get(nextIndex);
                        entryListEntry4.getBounds().y = (int)((double)entryListEntry4.backupY - this.scrolling.scrollAmount + (double)offset);
                        if (entryListEntry4.getBounds().y > this.bounds.getMaxY()) break block7;
                        if (EntryListWidget.notSteppingOnExclusionZones(entryListEntry4.getBounds().x, entryListEntry4.getBounds().y, this.innerBounds)) {
                            entryListEntry4.entry(stack);
                            entryListEntry4.isFavorites = false;
                            entryListEntry4.method_25394(matrices, mouseX, mouseY, delta);
                            ++nextIndex;
                            break;
                        }
                        ++this.blockedCount;
                        ++nextIndex;
                    }
                    ++i;
                }
            }
            this.updatePosition(delta);
            ScissorsHandler.INSTANCE.removeLastScissor();
            this.scrolling.renderScrollBar(0, 1.0f, REIHelper.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        } else if (this.debugTime) {
            int size = 0;
            long l = 0L;
            for (Widget widget : this.renders) {
                widget.method_25394(matrices, mouseX, mouseY, delta);
            }
            long totalTimeStart = System.nanoTime();
            if (ConfigObject.getInstance().doesFastEntryRendering()) {
                for (Map.Entry entry : this.entries.stream().collect(Collectors.groupingBy(entryListEntry -> entryListEntry.getCurrentEntry().getClass())).entrySet()) {
                    List list = (List)entry.getValue();
                    if (list.isEmpty()) continue;
                    EntryListEntry firstWidget = (EntryListEntry)((Object)list.get(0));
                    EntryStack first = firstWidget.getCurrentEntry();
                    if (first instanceof OptimalEntryStack) {
                        EntryStack currentEntry;
                        OptimalEntryStack firstStack = (OptimalEntryStack)((Object)first);
                        firstStack.optimisedRenderStart(matrices, delta);
                        long l2 = System.nanoTime();
                        for (EntryListEntry listEntry : list) {
                            currentEntry = listEntry.getCurrentEntry();
                            currentEntry.setZ(100);
                            listEntry.drawBackground(matrices, mouseX, mouseY, delta);
                            ((OptimalEntryStack)((Object)currentEntry)).optimisedRenderBase(matrices, listEntry.getInnerBounds(), mouseX, mouseY, delta);
                            if (currentEntry.isEmpty()) continue;
                            ++size;
                        }
                        for (EntryListEntry listEntry : list) {
                            currentEntry = listEntry.getCurrentEntry();
                            ((OptimalEntryStack)((Object)currentEntry)).optimisedRenderOverlay(matrices, listEntry.getInnerBounds(), mouseX, mouseY, delta);
                            if (!listEntry.containsMouse(mouseX, mouseY)) continue;
                            listEntry.queueTooltip(matrices, mouseX, mouseY, delta);
                            listEntry.drawHighlighted(matrices, mouseX, mouseY, delta);
                        }
                        l += System.nanoTime() - l2;
                        firstStack.optimisedRenderEnd(matrices, delta);
                        continue;
                    }
                    for (EntryListEntry listEntry : list) {
                        if (listEntry.getCurrentEntry().isEmpty()) continue;
                        ++size;
                        long l3 = System.nanoTime();
                        listEntry.method_25394(matrices, mouseX, mouseY, delta);
                        l += System.nanoTime() - l3;
                    }
                }
            } else {
                for (EntryListEntry entryListEntry5 : this.entries) {
                    if (entryListEntry5.getCurrentEntry().isEmpty()) continue;
                    ++size;
                    long l4 = System.nanoTime();
                    entryListEntry5.method_25394(matrices, mouseX, mouseY, delta);
                    l += System.nanoTime() - l4;
                }
            }
            long totalTime = System.nanoTime() - totalTimeStart;
            int z = this.getZ();
            this.setZ(500);
            class_2585 debugText = new class_2585(String.format("%d entries, avg. %.0fns, ttl. %.0fms, %s fps", size, (double)l / (double)size, (double)totalTime / 1000000.0, this.minecraft.field_1770.split(" ")[0]));
            int stringWidth = this.font.method_27525((class_2561)debugText);
            int n = Math.min(this.bounds.x, this.minecraft.field_1755.field_22789 - stringWidth - 2);
            int n8 = this.bounds.y;
            int n9 = this.bounds.x + stringWidth + 2;
            int n10 = this.bounds.y;
            this.font.getClass();
            this.method_25296(matrices, n, n8, n9, n10 + 9 + 2, -16777216, -16777216);
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, (double)this.getZ());
            class_1159 matrix = matrices.method_23760().method_23761();
            this.font.method_22942((class_2561)debugText, (float)Math.min(this.bounds.x + 2, this.minecraft.field_1755.field_22789 - stringWidth), (float)(this.bounds.y + 2), -1, false, matrix, (class_4597)immediate, false, 0, 0xF000F0);
            immediate.method_22993();
            this.setZ(z);
            matrices.method_22909();
        } else {
            for (Widget widget : this.renders) {
                widget.method_25394(matrices, mouseX, mouseY, delta);
            }
            if (ConfigObject.getInstance().doesFastEntryRendering()) {
                for (Map.Entry entry : this.entries.stream().collect(Collectors.groupingBy(entryListEntry -> entryListEntry.getCurrentEntry().getClass())).entrySet()) {
                    List list = (List)entry.getValue();
                    if (list.isEmpty()) continue;
                    EntryListEntry firstWidget = (EntryListEntry)((Object)list.get(0));
                    EntryStack first = firstWidget.getCurrentEntry();
                    if (first instanceof OptimalEntryStack) {
                        EntryStack currentEntry;
                        OptimalEntryStack firstStack = (OptimalEntryStack)((Object)first);
                        firstStack.optimisedRenderStart(matrices, delta);
                        for (EntryListEntry listEntry : list) {
                            currentEntry = listEntry.getCurrentEntry();
                            currentEntry.setZ(100);
                            listEntry.drawBackground(matrices, mouseX, mouseY, delta);
                            ((OptimalEntryStack)((Object)currentEntry)).optimisedRenderBase(matrices, listEntry.getInnerBounds(), mouseX, mouseY, delta);
                        }
                        for (EntryListEntry listEntry : list) {
                            currentEntry = listEntry.getCurrentEntry();
                            ((OptimalEntryStack)((Object)currentEntry)).optimisedRenderOverlay(matrices, listEntry.getInnerBounds(), mouseX, mouseY, delta);
                            if (!listEntry.containsMouse(mouseX, mouseY)) continue;
                            listEntry.queueTooltip(matrices, mouseX, mouseY, delta);
                            listEntry.drawHighlighted(matrices, mouseX, mouseY, delta);
                        }
                        firstStack.optimisedRenderEnd(matrices, delta);
                        continue;
                    }
                    for (EntryListEntry entryListEntry6 : list) {
                        if (entryListEntry6.getCurrentEntry().isEmpty()) continue;
                        entryListEntry6.method_25394(matrices, mouseX, mouseY, delta);
                    }
                }
            } else {
                for (EntryListEntry entryListEntry7 : this.entries) {
                    if (entryListEntry7.getCurrentEntry().isEmpty()) continue;
                    entryListEntry7.method_25394(matrices, mouseX, mouseY, delta);
                }
            }
        }
        if (this.containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating() && !this.minecraft.field_1724.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
            Tooltip.create(new class_2561[]{new class_2588("text.rei.delete_items")}).queue();
        }
    }

    private int getScrollbarMinX() {
        if (ConfigObject.getInstance().isLeftHandSidePanel()) {
            return this.bounds.x + 1;
        }
        return this.bounds.getMaxX() - 7;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, dx, dy, ConfigObject.getInstance().doesSnapToRows(), (double)EntryListWidget.entrySize())) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    private void updatePosition(float delta) {
        if (ConfigObject.getInstance().doesSnapToRows() && this.scrolling.scrollTarget >= 0.0 && this.scrolling.scrollTarget <= (double)this.scrolling.getMaxScroll()) {
            double nearestRow = (double)Math.round(this.scrolling.scrollTarget / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
            this.scrolling.scrollTarget = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.scrolling.scrollTarget, (double)nearestRow, (double)0.001f) ? (this.scrolling.scrollTarget += (nearestRow - this.scrolling.scrollTarget) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        this.scrolling.updatePosition(delta);
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (this.containsMouse(PointHelper.ofMouse())) {
            for (Widget widget : this.widgets) {
                if (!widget.method_25404(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateArea(DisplayHelper.DisplayBoundsHandler<?> boundsHandler, @Nullable String searchTerm) {
        this.bounds = boundsHandler.getItemListArea(ScreenHelper.getLastOverlay().getBounds());
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateFavoritesBounds(boundsHandler, searchTerm);
        }
        if (searchTerm != null) {
            this.updateSearch(searchTerm, true);
        } else if (this.allStacks == null || this.favorites == null || favoritesListWidget != null && favoritesListWidget.favorites == null) {
            this.updateSearch("", true);
        } else {
            this.updateEntriesPosition();
        }
    }

    public void updateEntriesPosition() {
        this.innerBounds = EntryListWidget.updateInnerBounds(this.bounds);
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.renders = Lists.newArrayList();
            page = Math.max(page, 0);
            ArrayList entries = Lists.newArrayList();
            int width = this.innerBounds.width / EntryListWidget.entrySize();
            int height = this.innerBounds.height / EntryListWidget.entrySize();
            for (int currentY = 0; currentY < height; ++currentY) {
                for (int currentX = 0; currentX < width; ++currentX) {
                    if (!EntryListWidget.notSteppingOnExclusionZones(currentX * EntryListWidget.entrySize() + this.innerBounds.x, currentY * EntryListWidget.entrySize() + this.innerBounds.y, this.innerBounds)) continue;
                    entries.add((EntryListEntry)new EntryListEntry(currentX * EntryListWidget.entrySize() + this.innerBounds.x, currentY * EntryListWidget.entrySize() + this.innerBounds.y).noBackground());
                }
            }
            page = Math.max(Math.min(page, this.getTotalPages() - 1), 0);
            int numberForFavorites = this.getScrollNumberForFavorites();
            List subList = this.allStacks.stream().skip(Math.max(0, page * entries.size() - numberForFavorites)).limit(Math.max(0, entries.size() - Math.max(0, numberForFavorites - page * entries.size()))).collect(Collectors.toList());
            for (int i = 0; i < subList.size(); ++i) {
                EntryStack stack = (EntryStack)subList.get(i);
                ((EntryListEntry)((Object)entries.get(i + Math.max(0, numberForFavorites - page * entries.size())))).clearStacks().entry(stack);
                ((EntryListEntry)((Object)entries.get(i + Math.max(0, numberForFavorites - page * entries.size())))).isFavorites = false;
            }
            this.entries = entries;
            if (numberForFavorites > 0) {
                int skippedFavorites = page * (entries.size() - width);
                int j = 0;
                if (skippedFavorites < this.favorites.size()) {
                    this.renders.add(Widgets.createLabel(new Point(this.innerBounds.x + 2, this.innerBounds.y + 6), (class_2561)new class_2588("text.rei.favorites")).leftAligned());
                    j += width;
                }
                List subFavoritesList = this.favorites.stream().skip(skippedFavorites).limit(Math.max(0, entries.size() - width)).collect(Collectors.toList());
                for (EntryStack stack : subFavoritesList) {
                    ((EntryListEntry)((Object)entries.get(j))).clearStacks().entry(stack);
                    ((EntryListEntry)((Object)entries.get(j))).isFavorites = true;
                    ++j;
                }
            }
            this.widgets = Lists.newArrayList(this.renders);
            this.widgets.addAll(entries);
        } else {
            page = 0;
            int width = this.innerBounds.width / EntryListWidget.entrySize();
            int pageHeight = this.innerBounds.height / EntryListWidget.entrySize();
            int sizeForFavorites = this.getScrollNumberForFavorites();
            int slotsToPrepare = Math.max(this.allStacks.size() * 3 + sizeForFavorites * 3, width * pageHeight * 3);
            int currentX = 0;
            int currentY = 0;
            ArrayList entries = Lists.newArrayList();
            for (int i = 0; i < slotsToPrepare; ++i) {
                int xPos = currentX * EntryListWidget.entrySize() + this.innerBounds.x;
                int yPos = currentY * EntryListWidget.entrySize() + this.innerBounds.y;
                entries.add((EntryListEntry)new EntryListEntry(xPos, yPos).noBackground());
                if (++currentX < width) continue;
                currentX = 0;
                ++currentY;
            }
            this.entries = entries;
            this.widgets = Lists.newArrayList(this.renders);
            this.widgets.addAll(entries);
        }
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateEntriesPosition();
        }
    }

    @ApiStatus.Internal
    public List<EntryStack> getAllStacks() {
        return this.allStacks;
    }

    public void updateSearch(String searchTerm) {
        this.updateSearch(searchTerm, true);
    }

    public void updateSearch(String searchTerm, boolean ignoreLastSearch) {
        List<EntryStack> workingItems;
        boolean checkCraftable;
        ArrayList list;
        long started = System.nanoTime();
        if (ignoreLastSearch || this.lastSearchTerm == null || !this.lastSearchTerm.equals(searchTerm)) {
            ItemListOrdering ordering;
            this.lastSearchTerm = searchTerm;
            this.lastSearchArguments = SearchArgument.processSearchTerm(searchTerm);
            list = Lists.newArrayList();
            checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
            workingItems = checkCraftable ? RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)) : null;
            List<EntryStack> stacks = EntryRegistry.getInstance().getPreFilteredList();
            if (stacks instanceof CopyOnWriteArrayList && !stacks.isEmpty()) {
                if (ConfigObject.getInstance().shouldAsyncSearch()) {
                    int size = ConfigObject.getInstance().getNumberAsyncSearch();
                    ArrayList completableFutures = Lists.newArrayList();
                    for (int i = 0; i < stacks.size(); i += size) {
                        int[] start = new int[]{i};
                        completableFutures.add(CompletableFuture.supplyAsync(() -> {
                            int end = Math.min(stacks.size(), start[0] + size);
                            ArrayList filtered = Lists.newArrayList();
                            while (start[0] < end) {
                                EntryStack stack = (EntryStack)stacks.get(start[0]);
                                if (this.canLastSearchTermsBeAppliedTo(stack) && (workingItems == null || CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(workingItems, stack) != null)) {
                                    filtered.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, RENDER_ENCHANTMENT_GLINT));
                                }
                                start[0] = start[0] + 1;
                            }
                            return filtered;
                        }));
                    }
                    try {
                        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        e.printStackTrace();
                    }
                    for (CompletableFuture future : completableFutures) {
                        List now = future.getNow(null);
                        if (now == null) continue;
                        list.addAll(now);
                    }
                } else {
                    for (EntryStack stack : stacks) {
                        if (!this.canLastSearchTermsBeAppliedTo(stack) || workingItems != null && CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(workingItems, stack) == null) continue;
                        list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, RENDER_ENCHANTMENT_GLINT));
                    }
                }
            }
            if ((ordering = ConfigObject.getInstance().getItemListOrdering()) == ItemListOrdering.name) {
                list.sort(ENTRY_NAME_COMPARER);
            }
            if (ordering == ItemListOrdering.item_groups) {
                list.sort(ENTRY_GROUP_COMPARER);
            }
            if (!ConfigObject.getInstance().isItemListAscending()) {
                Collections.reverse(list);
            }
            this.allStacks = list;
        }
        if (ConfigObject.getInstance().isFavoritesEnabled() && !ConfigObject.getInstance().doDisplayFavoritesOnTheLeft()) {
            list = Lists.newArrayList();
            checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
            workingItems = checkCraftable ? RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)) : null;
            for (EntryStack stack : ConfigObject.getInstance().getFavorites()) {
                if (!this.canLastSearchTermsBeAppliedTo(stack) || workingItems != null && CollectionUtils.findFirstOrNullEqualsEntryIgnoreAmount(workingItems, stack) == null) continue;
                list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, RENDER_ENCHANTMENT_GLINT));
            }
            ItemListOrdering ordering = ConfigObject.getInstance().getItemListOrdering();
            if (ordering == ItemListOrdering.name) {
                list.sort(ENTRY_NAME_COMPARER);
            }
            if (ordering == ItemListOrdering.item_groups) {
                list.sort(ENTRY_GROUP_COMPARER);
            }
            if (!ConfigObject.getInstance().isItemListAscending()) {
                Collections.reverse(list);
            }
            this.favorites = list;
        } else {
            this.favorites = Collections.emptyList();
        }
        this.debugTime = ConfigObject.getInstance().doDebugRenderTimeRequired();
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateSearch(this, searchTerm);
        }
        long ended = System.nanoTime();
        long time = ended - started;
        if (ConfigObject.getInstance().doDebugSearchTimeRequired()) {
            RoughlyEnoughItemsCore.LOGGER.info("Search Used: %.2fms", (Object)((double)time * 1.0E-6));
        }
        this.updateEntriesPosition();
    }

    public boolean canLastSearchTermsBeAppliedTo(EntryStack stack) {
        return this.lastSearchArguments.isEmpty() || SearchArgument.canSearchTermsBeAppliedTo(stack, this.lastSearchArguments);
    }

    public List<? extends Widget> method_25396() {
        return this.widgets;
    }

    public boolean method_25402(double double_1, double double_2, int int_1) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled() && this.scrolling.updateDraggingState(double_1, double_2, int_1)) {
            return true;
        }
        if (this.containsMouse(double_1, double_2)) {
            class_746 player = this.minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (!player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                return false;
            }
            for (Widget widget : this.method_25396()) {
                if (!widget.method_25402(double_1, double_2, int_1)) continue;
                return true;
            }
        }
        return false;
    }

    private class EntryListEntry
    extends EntryWidget {
        private int backupY;
        private boolean isFavorites;

        private EntryListEntry(int x, int y) {
            super(new Point(x, y));
            this.backupY = y;
            this.getBounds().width = this.getBounds().height = EntryListWidget.entrySize();
        }

        @Override
        public void drawBackground(class_4587 matrices, int mouseX, int mouseY, float delta) {
            super.drawBackground(matrices, mouseX, mouseY, delta);
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && EntryListWidget.this.bounds.contains(mouseX, mouseY);
        }

        @Override
        public void drawHighlighted(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (this.getCurrentEntry().getType() != EntryStack.Type.EMPTY) {
                super.drawHighlighted(matrices, mouseX, mouseY, delta);
            }
        }

        @Override
        public void queueTooltip(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (!ClientHelper.getInstance().isCheating() || this.minecraft.field_1724.field_7514.method_7399().method_7960()) {
                super.queueTooltip(matrices, mouseX, mouseY, delta);
            }
        }

        @Override
        protected boolean reverseFavoritesAction() {
            return this.isFavorites;
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            EntryStack entry;
            if (!this.interactable) {
                return super.method_25402(mouseX, mouseY, button);
            }
            if (this.containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating() && !(entry = this.getCurrentEntry().copy()).isEmpty()) {
                if (entry.getType() == EntryStack.Type.FLUID) {
                    entry = EntryStack.copyFluidToItem(entry);
                }
                if (entry.getType() == EntryStack.Type.ITEM) {
                    entry.setAmount(button != 1 && !class_437.method_25442() ? 1 : entry.getItemStack().method_7914());
                }
                ClientHelper.getInstance().tryCheatingEntry(entry);
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }
}

