/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.config.RecipeScreenType;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;

@ApiStatus.Internal
public class PreRecipeViewingScreen extends class_437 {
    
    private static final class_2960 IDENTIFIER = new class_2960("roughlyenoughitems", "textures/gui/screenshot.png");
    private final List<Widget> widgets;
    protected long start;
    protected long duration;
    private boolean isSet;
    private boolean original;
    private double frame = 0;
    private double target = 0;
    private BooleanConsumer callback;
    private class_437 parent;
    private boolean showTips;
    
    public PreRecipeViewingScreen(class_437 parent, RecipeScreenType type, boolean showTips, BooleanConsumer callback) {
        super(new class_2588("text.rei.recipe_screen_type.selection"));
        this.widgets = Lists.newArrayList();
        if (type == RecipeScreenType.UNSET) {
            this.isSet = false;
            this.original = true;
        } else {
            this.isSet = true;
            this.original = type == RecipeScreenType.ORIGINAL;
            moveFrameTo(original ? 0 : 1, false, 0);
        }
        this.callback = callback;
        this.parent = parent;
        this.showTips = showTips;
    }
    
    public final double clamp(double v) {
        return clamp(v, 30);
    }
    
    public final double clamp(double v, double clampExtension) {
        return class_3532.method_15350(v, -clampExtension, 1 + clampExtension);
    }
    
    private void moveFrameTo(double value, boolean animated, long duration) {
        target = clamp(value);
        
        if (animated) {
            start = System.currentTimeMillis();
            this.duration = duration;
        } else
            frame = target;
    }
    
    @Override
    public void method_25426() {
        this.field_22786.clear();
        this.widgets.clear();
        this.widgets.add(Widgets.createButton(new Rectangle(field_22789 / 2 - 100, field_22790 - 40, 200, 20), class_333.field_18967)
                .onRender((matrices, button) -> {
                    button.setEnabled(isSet);
                    button.setText(isSet ? new class_2588("text.rei.select") : new class_2588("config.roughlyenoughitems.recipeScreenType.unset"));
                })
                .onClick(button -> callback.accept(original)));
        this.widgets.add(new ScreenTypeSelection(field_22789 / 2 - 200 - 5, field_22790 / 2 - 112 / 2 - 10, 0));
        this.widgets.add(Widgets.createLabel(new Point(field_22789 / 2 - 200 - 5 + 104, field_22790 / 2 - 112 / 2 + 115), new class_2588("config.roughlyenoughitems.recipeScreenType.original")).noShadow().color(-1124073473));
        this.widgets.add(new ScreenTypeSelection(field_22789 / 2 + 5, field_22790 / 2 - 112 / 2 - 10, 112));
        this.widgets.add(Widgets.createLabel(new Point(field_22789 / 2 + 5 + 104, field_22790 / 2 - 112 / 2 + 115), new class_2588("config.roughlyenoughitems.recipeScreenType.villager")).noShadow().color(-1124073473));
        this.field_22786.addAll(widgets);
    }
    
    @Override
    public void method_25394(class_4587 matrices, int int_1, int int_2, float float_1) {
        if (this.field_22787.field_1687 != null) {
            this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        } else {
            this.method_25296(matrices, 0, 0, this.field_22789, this.field_22790, -16777216, -16777216);
        }
        this.method_27534(matrices, this.field_22793, this.field_22785, this.field_22789 / 2, 20, 16777215);
        if (showTips) {
            int i = 30;
            for (class_2561 s : this.field_22793.method_1728(new class_2588("text.rei.recipe_screen_type.selection.sub").method_27692(class_124.field_1080), field_22789 - 30)) {
                this.method_27534(matrices, this.field_22793, s, field_22789 / 2, i, -1);
                i += 10;
            }
        }
        super.method_25394(matrices, int_1, int_2, float_1);
        for (Widget widget : widgets) {
            widget.method_25394(matrices, int_1, int_2, float_1);
        }
        if (isSet) {
            updateFramePosition(float_1);
            int x = (int) (field_22789 / 2 - 205 + (210 * frame));
            int y = field_22790 / 2 - 112 / 2 - 10;
            method_25296(matrices, x - 2, y - 4, x - 6 + 208, y - 4 + 2, -1778384897, -1778384897);
            method_25296(matrices, x - 2, y - 4 + 120 - 2, x - 6 + 208, y - 4 + 120, -1778384897, -1778384897);
            method_25296(matrices, x - 4, y - 4, x - 4 + 2, y - 4 + 120, -1778384897, -1778384897);
            method_25296(matrices, x - 4 + 208 - 2, y - 4, x - 4 + 208, y - 4 + 120, -1778384897, -1778384897);
        }
    }
    
    private void updateFramePosition(float delta) {
        target = clamp(target);
        if (!DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals(frame, target, DynamicNewSmoothScrollingEntryListWidget.Precision.FLOAT_EPSILON))
            frame = ease(frame, target, Math.min((System.currentTimeMillis() - start) / (double) duration * delta * 3.0D, 1));
        else
            frame = target;
    }
    
    private double ease(double start, double end, double amount) {
        return start + (end - start) * EasingMethod.EasingMethodImpl.LINEAR.apply(amount);
    }
    
    @Override
    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (int_1 == 256 || this.field_22787.field_1690.field_1822.method_1417(int_1, int_2)) {
            class_310.method_1551().method_1507(parent);
            if (parent instanceof class_465)
                ScreenHelper.getLastOverlay().init();
            return true;
        }
        return super.method_25404(int_1, int_2, int_3);
    }
    
    public class ScreenTypeSelection extends WidgetWithBounds {
        
        private Rectangle bounds;
        private int u, v;
        
        public ScreenTypeSelection(int x, int y, int v) {
            this.bounds = new Rectangle(x - 4, y - 4, 208, 120);
            this.u = 0;
            this.v = v;
        }
        
        @NotNull
        @Override
        public Rectangle getBounds() {
            return bounds;
        }
        
        @Override
        public void method_25394(class_4587 matrices, int i, int i1, float delta) {
            class_310.method_1551().method_1531().method_22813(IDENTIFIER);
            method_25302(matrices, bounds.x + 4, bounds.y + 4, u, v, 200, 112);
        }
        
        @Override
        public boolean method_25402(double double_1, double double_2, int int_1) {
            if (containsMouse(double_1, double_2)) {
                original = (v == 0);
                if (!isSet) {
                    moveFrameTo(original ? 0 : 1, false, 0);
                }
                isSet = true;
                moveFrameTo(original ? 0 : 1, true, 500);
                return true;
            }
            return false;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
    }
}
