/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import net.minecraft.class_1159;
import net.minecraft.class_155;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_3000;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class TextFieldWidget
extends WidgetWithBounds
implements class_3000 {
    public Function<String, String> stripInvalid;
    protected int focusedTicks;
    protected boolean editable = true;
    protected int field_2103;
    protected int cursorMax;
    protected int cursorMin;
    protected int editableColor = 0xE0E0E0;
    protected int notEditableColor = 0x707070;
    protected BiFunction<String, Integer, String> renderTextProvider;
    private Rectangle bounds;
    private String text = "";
    private int maxLength = 32;
    private boolean hasBorder = true;
    private boolean field_2096 = true;
    private boolean focused;
    private boolean visible = true;
    private String suggestion;
    private Consumer<String> changedListener;
    private Predicate<String> textPredicate = s -> true;

    public TextFieldWidget(Rectangle rectangle) {
        this.renderTextProvider = (string_1, integer_1) -> string_1;
        this.bounds = rectangle;
        this.stripInvalid = class_155::method_644;
    }

    public TextFieldWidget(int x, int y, int width, int height) {
        this(new Rectangle(x, y, width, height));
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public void setSuggestion(String string_1) {
        this.suggestion = string_1;
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setChangedListener(Consumer<String> biConsumer_1) {
        this.changedListener = biConsumer_1;
    }

    public void method_1854(BiFunction<String, Integer, String> biFunction_1) {
        this.renderTextProvider = biFunction_1;
    }

    public void method_16896() {
        ++this.focusedTicks;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string_1) {
        if (this.textPredicate.test(string_1)) {
            this.text = string_1.length() > this.maxLength ? string_1.substring(0, this.maxLength) : string_1;
            this.onChanged(string_1);
            this.moveCursorToEnd();
        }
    }

    public String getSelectedText() {
        int int_1 = Math.min(this.cursorMax, this.cursorMin);
        int int_2 = Math.max(this.cursorMax, this.cursorMin);
        return this.text.substring(int_1, int_2);
    }

    public void method_1890(Predicate<String> predicate_1) {
        this.textPredicate = predicate_1;
    }

    public void addText(String string_1) {
        int int_5;
        String string_2 = "";
        String string_3 = this.stripInvalid.apply(string_1);
        int int_1 = Math.min(this.cursorMax, this.cursorMin);
        int int_2 = Math.max(this.cursorMax, this.cursorMin);
        int int_3 = this.maxLength - this.text.length() - (int_1 - int_2);
        if (!this.text.isEmpty()) {
            string_2 = string_2 + this.text.substring(0, int_1);
        }
        if (int_3 < string_3.length()) {
            string_2 = string_2 + string_3.substring(0, int_3);
            int_5 = int_3;
        } else {
            string_2 = string_2 + string_3;
            int_5 = string_3.length();
        }
        if (!this.text.isEmpty() && int_2 < this.text.length()) {
            string_2 = string_2 + this.text.substring(int_2);
        }
        if (this.textPredicate.test(string_2)) {
            this.text = string_2;
            this.setCursor(int_1 + int_5);
            this.method_1884(this.cursorMax);
            this.onChanged(this.text);
        }
    }

    public void onChanged(String string_1) {
        if (this.changedListener != null) {
            this.changedListener.accept(string_1);
        }
    }

    private void method_16873(int int_1) {
        if (class_437.method_25441()) {
            this.method_1877(int_1);
        } else {
            this.method_1878(int_1);
        }
    }

    public void method_1877(int int_1) {
        if (!this.text.isEmpty()) {
            if (this.cursorMin != this.cursorMax) {
                this.addText("");
            } else {
                this.method_1878(this.method_1853(int_1) - this.cursorMax);
            }
        }
    }

    public void method_1878(int int_1) {
        if (!this.text.isEmpty()) {
            if (this.cursorMin != this.cursorMax) {
                this.addText("");
            } else {
                boolean boolean_1 = int_1 < 0;
                int int_2 = boolean_1 ? this.cursorMax + int_1 : this.cursorMax;
                int int_3 = boolean_1 ? this.cursorMax : this.cursorMax + int_1;
                String string_1 = "";
                if (int_2 >= 0) {
                    string_1 = this.text.substring(0, int_2);
                }
                if (int_3 < this.text.length()) {
                    string_1 = string_1 + this.text.substring(int_3);
                }
                if (this.textPredicate.test(string_1)) {
                    this.text = string_1;
                    if (boolean_1) {
                        this.moveCursor(int_1, true);
                    }
                    this.onChanged(this.text);
                }
            }
        }
    }

    public int method_1853(int int_1) {
        return this.method_1869(int_1, this.getCursor());
    }

    public int method_1869(int int_1, int int_2) {
        return this.method_1864(int_1, int_2, true);
    }

    public int method_1864(int int_1, int int_2, boolean boolean_1) {
        int int_3 = int_2;
        boolean boolean_2 = int_1 < 0;
        int int_4 = Math.abs(int_1);
        for (int int_5 = 0; int_5 < int_4; ++int_5) {
            if (!boolean_2) {
                int int_6 = this.text.length();
                if ((int_3 = this.text.indexOf(32, int_3)) == -1) {
                    int_3 = int_6;
                    continue;
                }
                while (boolean_1 && int_3 < int_6 && this.text.charAt(int_3) == ' ') {
                    ++int_3;
                }
                continue;
            }
            while (boolean_1 && int_3 > 0 && this.text.charAt(int_3 - 1) == ' ') {
                --int_3;
            }
            while (int_3 > 0 && this.text.charAt(int_3 - 1) != ' ') {
                --int_3;
            }
        }
        return int_3;
    }

    public void moveCursor(int int_1, boolean resetSelect) {
        this.moveCursorTo(this.cursorMax + int_1, resetSelect);
    }

    public void moveCursorTo(int int_1, boolean resetSelect) {
        this.setCursor(int_1);
        if (resetSelect) {
            this.method_1884(this.cursorMax);
        }
        this.onChanged(this.text);
    }

    public void moveCursorToHead() {
        this.moveCursorTo(0, true);
    }

    public void moveCursorToEnd() {
        this.moveCursorTo(this.text.length(), true);
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (this.isVisible() && this.isFocused()) {
            if (class_437.method_25439((int)int_1)) {
                this.moveCursorToEnd();
                this.method_1884(0);
                return true;
            }
            if (class_437.method_25438((int)int_1)) {
                this.minecraft.field_1774.method_1455(this.getSelectedText());
                return true;
            }
            if (class_437.method_25437((int)int_1)) {
                if (this.editable) {
                    this.addText(this.minecraft.field_1774.method_1460());
                }
                return true;
            }
            if (class_437.method_25436((int)int_1)) {
                this.minecraft.field_1774.method_1455(this.getSelectedText());
                if (this.editable) {
                    this.addText("");
                }
                return true;
            }
            switch (int_1) {
                case 259: {
                    if (this.editable) {
                        this.method_16873(-1);
                    }
                    return true;
                }
                default: {
                    return int_1 != 256;
                }
                case 261: {
                    if (this.editable) {
                        this.method_16873(1);
                    }
                    return true;
                }
                case 262: {
                    if (class_437.method_25441()) {
                        this.moveCursorTo(this.method_1853(1), !class_437.method_25442());
                    } else {
                        this.moveCursor(1, !class_437.method_25442());
                    }
                    return true;
                }
                case 263: {
                    if (class_437.method_25441()) {
                        this.moveCursorTo(this.method_1853(-1), !class_437.method_25442());
                    } else {
                        this.moveCursor(-1, !class_437.method_25442());
                    }
                    return true;
                }
                case 268: {
                    this.moveCursorToHead();
                    return true;
                }
                case 269: 
            }
            this.moveCursorToEnd();
            return true;
        }
        return false;
    }

    public boolean method_25400(char char_1, int int_1) {
        if (this.isVisible() && this.isFocused()) {
            if (class_155.method_643((char)char_1)) {
                if (this.editable) {
                    this.addText(Character.toString(char_1));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public List<Widget> method_25396() {
        return Collections.emptyList();
    }

    public boolean method_25402(double double_1, double double_2, int int_1) {
        boolean boolean_1;
        if (!this.isVisible()) {
            return false;
        }
        boolean bl = boolean_1 = double_1 >= (double)this.bounds.x && double_1 < (double)(this.bounds.x + this.bounds.width) && double_2 >= (double)this.bounds.y && double_2 < (double)(this.bounds.y + this.bounds.height);
        if (this.field_2096) {
            this.setFocused(boolean_1);
        }
        if (this.focused && boolean_1 && int_1 == 0) {
            int int_2 = class_3532.method_15357((double)double_1) - this.bounds.x;
            if (this.hasBorder) {
                int_2 -= 4;
            }
            String string_1 = this.font.method_27523(this.text.substring(this.field_2103), this.getWidth());
            this.moveCursorTo(this.font.method_27523(string_1, int_2).length() + this.field_2103, true);
            return true;
        }
        return false;
    }

    public void renderBorder(class_4587 matrices) {
        if (this.hasBorder()) {
            if (this.containsMouse(PointHelper.ofMouse()) || this.focused) {
                TextFieldWidget.method_25294((class_4587)matrices, (int)(this.bounds.x - 1), (int)(this.bounds.y - 1), (int)(this.bounds.x + this.bounds.width + 1), (int)(this.bounds.y + this.bounds.height + 1), (int)(REIHelper.getInstance().isDarkThemeEnabled() ? -17587 : -1));
            } else {
                TextFieldWidget.method_25294((class_4587)matrices, (int)(this.bounds.x - 1), (int)(this.bounds.y - 1), (int)(this.bounds.x + this.bounds.width + 1), (int)(this.bounds.y + this.bounds.height + 1), (int)-6250336);
            }
            TextFieldWidget.method_25294((class_4587)matrices, (int)this.bounds.x, (int)this.bounds.y, (int)(this.bounds.x + this.bounds.width), (int)(this.bounds.y + this.bounds.height), (int)-16777216);
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.isVisible()) {
            this.renderBorder(matrices);
            int color = this.editable ? this.editableColor : this.notEditableColor;
            int int_4 = this.cursorMax - this.field_2103;
            int int_5 = this.cursorMin - this.field_2103;
            String string_1 = this.font.method_27523(this.text.substring(this.field_2103), this.getWidth());
            boolean boolean_1 = int_4 >= 0 && int_4 <= string_1.length();
            boolean boolean_2 = this.focused && this.focusedTicks / 6 % 2 == 0 && boolean_1;
            int x = this.hasBorder ? this.bounds.x + 4 : this.bounds.x;
            int y = this.hasBorder ? this.bounds.y + (this.bounds.height - 8) / 2 : this.bounds.y;
            int int_8 = x;
            if (int_5 > string_1.length()) {
                int_5 = string_1.length();
            }
            if (!string_1.isEmpty()) {
                String string_2 = boolean_1 ? string_1.substring(0, int_4) : string_1;
                int_8 = this.font.method_1720(matrices, this.renderTextProvider.apply(string_2, this.field_2103), (float)x, (float)y, color);
            }
            boolean isCursorInsideText = this.cursorMax < this.text.length() || this.text.length() >= this.getMaxLength();
            int int_9 = int_8--;
            if (!boolean_1) {
                int_9 = int_4 > 0 ? x + this.bounds.width : x;
            } else if (isCursorInsideText) {
                // empty if block
            }
            --int_9;
            if (!string_1.isEmpty() && boolean_1 && int_4 < string_1.length()) {
                this.font.method_1720(matrices, this.renderTextProvider.apply(string_1.substring(int_4), this.cursorMax), (float)int_8, (float)y, color);
            }
            if (!isCursorInsideText && this.text.isEmpty() && this.suggestion != null) {
                this.renderSuggestion(matrices, x, y);
            }
            if (boolean_2) {
                TextFieldWidget.method_25294((class_4587)matrices, (int)(int_9 + 1), (int)y, (int)(int_9 + 2), (int)(y + 9), (int)(0xFF000000 | ((color >> 16 & 0xFF) / 4 & 0xFF) << 16 | ((color >> 8 & 0xFF) / 4 & 0xFF) << 8 | (color & 0xFF) / 4 & 0xFF));
                TextFieldWidget.method_25294((class_4587)matrices, (int)int_9, (int)(y - 1), (int)(int_9 + 1), (int)(y + 8), (int)(0xFF000000 | color));
            }
            if (int_5 != int_4) {
                int int_10 = x + this.font.method_1727(string_1.substring(0, int_5));
                this.renderSelection(matrices, int_9, y - 1, int_10 - 1, y + 9, color);
            }
        }
    }

    protected void renderSuggestion(class_4587 matrices, int x, int y) {
        this.font.method_1720(matrices, this.font.method_27523(this.suggestion, this.getWidth()), (float)x, (float)y, -8355712);
    }

    protected void renderSelection(class_4587 matrices, int x1, int y1, int x2, int y2, int color) {
        int tmp;
        if (x1 < x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y1 < y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        if (x2 > this.bounds.x + this.bounds.width) {
            x2 = this.bounds.x + this.bounds.width;
        }
        if (x1 > this.bounds.x + this.bounds.width) {
            x1 = this.bounds.x + this.bounds.width;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.shadeModel((int)7425);
        class_1159 matrix = matrices.method_23760().method_23761();
        buffer.method_1328(7, class_290.field_1576);
        buffer.method_22918(matrix, (float)x1, (float)y2, (float)this.method_25305() + 50.0f).method_1336(r, g, b, 120).method_1344();
        buffer.method_22918(matrix, (float)x2, (float)y2, (float)this.method_25305() + 50.0f).method_1336(r, g, b, 120).method_1344();
        buffer.method_22918(matrix, (float)x2, (float)y1, (float)this.method_25305() + 50.0f).method_1336(r, g, b, 120).method_1344();
        buffer.method_22918(matrix, (float)x1, (float)y1, (float)this.method_25305() + 50.0f).method_1336(r, g, b, 120).method_1344();
        tessellator.method_1350();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int int_1) {
        this.maxLength = int_1;
        if (this.text.length() > int_1) {
            this.text = this.text.substring(0, int_1);
            this.onChanged(this.text);
        }
    }

    public int getCursor() {
        return this.cursorMax;
    }

    public void setCursor(int int_1) {
        this.cursorMax = class_3532.method_15340((int)int_1, (int)0, (int)this.text.length());
    }

    public boolean hasBorder() {
        return this.hasBorder;
    }

    public void setHasBorder(boolean boolean_1) {
        this.hasBorder = boolean_1;
    }

    public void setEditableColor(int int_1) {
        this.editableColor = int_1;
    }

    public void setNotEditableColor(int int_1) {
        this.notEditableColor = int_1;
    }

    public boolean method_25407(boolean boolean_1) {
        if (this.visible && this.editable) {
            this.setFocused(!this.focused);
            return this.focused;
        }
        return false;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean boolean_1) {
        if (boolean_1 && !this.focused) {
            this.focusedTicks = 0;
        }
        this.focused = boolean_1;
    }

    public void setIsEditable(boolean boolean_1) {
        this.editable = boolean_1;
    }

    public int getWidth() {
        return this.hasBorder() ? this.bounds.width - 8 : this.bounds.width;
    }

    public void method_1884(int int_1) {
        int int_2 = this.text.length();
        this.cursorMin = class_3532.method_15340((int)int_1, (int)0, (int)int_2);
        if (this.font != null) {
            if (this.field_2103 > int_2) {
                this.field_2103 = int_2;
            }
            int int_3 = this.getWidth();
            String string_1 = this.font.method_27523(this.text.substring(this.field_2103), int_3);
            int int_4 = string_1.length() + this.field_2103;
            if (this.cursorMin == this.field_2103) {
                this.field_2103 -= this.font.method_27524(this.text, int_3, true).length();
            }
            if (this.cursorMin > int_4) {
                this.field_2103 += this.cursorMin - int_4;
            } else if (this.cursorMin <= this.field_2103) {
                this.field_2103 -= this.field_2103 - this.cursorMin;
            }
            this.field_2103 = class_3532.method_15340((int)this.field_2103, (int)0, (int)int_2);
        }
    }

    public void method_1856(boolean boolean_1) {
        this.field_2096 = boolean_1;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean boolean_1) {
        this.visible = boolean_1;
    }

    public int method_1889(int int_1) {
        return int_1 > this.text.length() ? this.bounds.x : this.bounds.x + this.font.method_1727(this.text.substring(0, int_1));
    }
}

