/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.ItemStackHook;
import me.shedaniel.rei.api.OptimalEntryStack;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.impl.AbstractEntryStack;
import me.shedaniel.rei.impl.SearchArgument;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_809;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ItemEntryStack
extends AbstractEntryStack
implements OptimalEntryStack {
    private class_1799 itemStack;

    public ItemEntryStack(class_1799 itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public Optional<class_2960> getIdentifier() {
        return Optional.ofNullable(class_2378.field_11142.method_10221((Object)this.getItem()));
    }

    @Override
    public EntryStack.Type getType() {
        return EntryStack.Type.ITEM;
    }

    @Override
    public int getAmount() {
        return this.itemStack.method_7947();
    }

    @Override
    public double getFloatingAmount() {
        return this.itemStack.method_7947();
    }

    @Override
    public void setAmount(int amount) {
        this.itemStack.method_7939(amount);
    }

    @Override
    public void setFloatingAmount(double amount) {
        this.itemStack.method_7939(class_3532.method_15357((double)amount));
    }

    @Override
    public boolean isEmpty() {
        return this.itemStack.method_7960();
    }

    @Override
    public EntryStack copy() {
        EntryStack stack = EntryStack.create(this.getItemStack().method_7972());
        for (Map.Entry<EntryStack.Settings<?>, Object> entry : this.getSettings().entrySet()) {
            stack.setting(entry.getKey(), entry.getValue());
        }
        return stack;
    }

    @Override
    public Object getObject() {
        return this.itemStack;
    }

    private Boolean compareIfFluid(EntryStack stack, int type) {
        EntryStack fluid = EntryStack.copyItemToFluid(this);
        if (fluid.isEmpty()) {
            return null;
        }
        if (stack.getType() == EntryStack.Type.ITEM) {
            stack = EntryStack.copyItemToFluid(stack);
        }
        if (stack.isEmpty()) {
            return null;
        }
        switch (type) {
            case 0: {
                return fluid.equalsIgnoreTagsAndAmount(stack);
            }
            case 1: {
                return fluid.equalsIgnoreTags(stack);
            }
            case 2: {
                return fluid.equalsIgnoreAmount(stack);
            }
            case 3: {
                return fluid.equalsAll(stack);
            }
        }
        return null;
    }

    @Override
    public boolean equalsIgnoreTagsAndAmount(EntryStack stack) {
        Boolean ifFluid = this.compareIfFluid(stack, 0);
        if (ifFluid != null) {
            return ifFluid;
        }
        if (stack.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        return this.itemStack.method_7909() == stack.getItem();
    }

    @Override
    public boolean equalsAll(EntryStack stack) {
        Boolean ifFluid = this.compareIfFluid(stack, 3);
        if (ifFluid != null) {
            return ifFluid;
        }
        if (stack.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        return this.itemStack.method_7909() == stack.getItem() && this.getAmount() != stack.getAmount() && class_1799.method_7975((class_1799)this.itemStack, (class_1799)stack.getItemStack());
    }

    @Override
    public boolean equalsIgnoreAmount(EntryStack stack) {
        class_2487 o2;
        Boolean ifFluid = this.compareIfFluid(stack, 2);
        if (ifFluid != null) {
            return ifFluid;
        }
        if (stack.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        if (this.itemStack.method_7909() != stack.getItem()) {
            return false;
        }
        class_1799 otherStack = stack.getItemStack();
        class_2487 o1 = this.itemStack.method_7969();
        return o1 == (o2 = otherStack.method_7969()) || o1 != null && o2 != null && this.equals(o1, o2);
    }

    public boolean equals(class_2487 o1, class_2487 o2) {
        int o1Size = 0;
        int o2Size = 0;
        for (String key : o1.method_10541()) {
            if (key.equals("Count")) continue;
            ++o1Size;
        }
        for (String key : o2.method_10541()) {
            if (key.equals("Count") || ++o2Size <= o1Size) continue;
            return false;
        }
        if (o1Size != o2Size) {
            return false;
        }
        try {
            for (String key : o1.method_10541()) {
                if (key.equals("Count")) continue;
                class_2520 value = o1.method_10580(key);
                class_2520 otherValue = o2.method_10580(key);
                if (!(value == null ? otherValue != null || !o2.method_10545(key) : (value instanceof class_2487 && otherValue instanceof class_2487 ? value != otherValue && (value == null || otherValue == null || !this.equals((class_2487)value, (class_2487)otherValue)) : !value.method_10714().equals(otherValue.method_10714())))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsIgnoreTags(EntryStack stack) {
        Boolean ifFluid = this.compareIfFluid(stack, 1);
        if (ifFluid != null) {
            return ifFluid;
        }
        if (stack.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        if (this.itemStack.method_7909() != stack.getItem()) {
            return false;
        }
        return this.getAmount() == stack.getAmount();
    }

    @Override
    public int hashOfAll() {
        int result = this.hashIgnoreAmount();
        result = 31 * result + this.itemStack.method_7947();
        return result;
    }

    @Override
    public int hashIgnoreTags() {
        int result = this.hashIgnoreAmountAndTags();
        result = 31 * result + this.itemStack.method_7947();
        return result;
    }

    @Override
    public int hashIgnoreAmount() {
        int result = 1;
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + this.itemStack.method_7909().hashCode();
        result = this.itemStack.method_7985() ? 31 * result + this.itemStack.method_7969().method_10714().hashCode() : 31 * result;
        return result;
    }

    @Override
    public int hashIgnoreAmountAndTags() {
        int result = 1;
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + this.itemStack.method_7909().hashCode();
        return result;
    }

    @Override
    @Nullable
    public Tooltip getTooltip(Point point) {
        if (this.isEmpty() || !this.get(EntryStack.Settings.TOOLTIP_ENABLED).get().booleanValue()) {
            return null;
        }
        ArrayList toolTip = Lists.newArrayList(SearchArgument.tryGetItemStackToolTip(this.getItemStack(), true));
        toolTip.addAll((Collection)this.get(EntryStack.Settings.TOOLTIP_APPEND_EXTRA).apply(this));
        if (this.get(EntryStack.Settings.TOOLTIP_APPEND_MOD).get().booleanValue() && ConfigObject.getInstance().shouldAppendModNames()) {
            class_2561 modString = ClientHelper.getInstance().getFormattedModFromItem(this.getItem());
            String modId = ClientHelper.getInstance().getModFromItem(this.getItem());
            boolean alreadyHasMod = false;
            for (class_2561 s : toolTip) {
                if (!s.method_10851().equalsIgnoreCase(modId)) continue;
                alreadyHasMod = true;
                break;
            }
            if (!alreadyHasMod) {
                toolTip.add(modString);
            }
        }
        return Tooltip.create(toolTip);
    }

    @Override
    public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        this.optimisedRenderStart(matrices, delta);
        this.optimisedRenderBase(matrices, bounds, mouseX, mouseY, delta);
        this.optimisedRenderOverlay(matrices, bounds, mouseX, mouseY, delta);
        this.optimisedRenderEnd(matrices, delta);
    }

    @Override
    public void optimisedRenderStart(class_4587 matrices, float delta) {
        class_310.method_1551().method_1531().method_22813(class_1059.field_5275);
        class_4493.method_21920();
    }

    @Override
    public void optimisedRenderEnd(class_4587 matrices, float delta) {
        class_4493.method_21922();
    }

    private class_1087 getModelFromStack(class_1799 stack) {
        return class_310.method_1551().method_1480().method_4019(stack, null, null);
    }

    @Override
    public void optimisedRenderBase(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        if (!this.isEmpty() && this.get(EntryStack.Settings.RENDER).get().booleanValue()) {
            boolean sideLit;
            class_1799 stack = this.getItemStack();
            ((ItemStackHook)stack).rei_setRenderEnchantmentGlint(this.get(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT).get());
            matrices.method_22903();
            matrices.method_22904((double)bounds.getCenterX(), (double)bounds.getCenterY(), (double)(100.0f + (float)this.getZ()));
            matrices.method_22905((float)bounds.getWidth(), (float)(bounds.getWidth() + bounds.getHeight()) / -2.0f, (float)bounds.getHeight());
            class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
            class_1087 model = this.getModelFromStack(stack);
            boolean bl = sideLit = !model.method_24304();
            if (sideLit) {
                class_308.method_24210();
            }
            class_310.method_1551().method_1480().method_23179(stack, class_809.class_811.field_4317, false, matrices, (class_4597)immediate, 0xF000F0, class_4608.field_21444, model);
            immediate.method_22993();
            if (sideLit) {
                class_308.method_24211();
            }
            matrices.method_22909();
            ((ItemStackHook)stack).rei_setRenderEnchantmentGlint(false);
        }
    }

    @Override
    public void optimisedRenderOverlay(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        if (!this.isEmpty() && this.get(EntryStack.Settings.RENDER).get().booleanValue()) {
            class_310.method_1551().method_1480().field_4730 = this.getZ();
            class_310.method_1551().method_1480().method_4022(class_310.method_1551().field_1772, this.getItemStack(), bounds.x, bounds.y, this.get(EntryStack.Settings.RENDER_COUNTS).get() != false ? this.get(EntryStack.Settings.COUNTS).apply(this) : "");
            class_310.method_1551().method_1480().field_4730 = 0.0f;
        }
    }
}

