/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.widgets.Button;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1109;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class ButtonWidget extends Button {
    private static final class_2960 BUTTON_LOCATION = new class_2960("roughlyenoughitems", "textures/gui/button.png");
    private static final class_2960 BUTTON_LOCATION_DARK = new class_2960("roughlyenoughitems", "textures/gui/button_dark.png");
    @NotNull
    private Rectangle bounds;
    private boolean enabled = true;
    @NotNull
    private class_2561 text;
    @Nullable
    private Integer tint;
    @Nullable
    private Consumer<Button> onClick;
    @Nullable
    private BiConsumer<class_4587, Button> onRender;
    private boolean focusable = false;
    private boolean focused = false;
    @Nullable
    private Function<@NotNull Button, @Nullable String> tooltipFunction;
    @Nullable
    private BiFunction<@NotNull Button, @NotNull Point, @NotNull Integer> textColorFunction;
    @Nullable
    private BiFunction<@NotNull Button, @NotNull Point, @NotNull Integer> textureIdFunction;
    
    public ButtonWidget(Rectangle rectangle, class_2561 text) {
        this.bounds = new Rectangle(Objects.requireNonNull(rectangle));
        this.text = Objects.requireNonNull(text);
    }
    
    @Override
    public final boolean isFocused() {
        return focused;
    }
    
    @Override
    public final boolean isEnabled() {
        return enabled;
    }
    
    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
    
    @Override
    public final OptionalInt getTint() {
        return OptionalInt.empty();
    }
    
    @Override
    public final void setTint(int tint) {
        this.tint = tint;
    }
    
    @Override
    public final void removeTint() {
        this.tint = null;
    }
    
    @Override
    @NotNull
    public final class_2561 getText() {
        return text;
    }
    
    @Override
    public final void setText(@NotNull class_2561 text) {
        this.text = text;
    }
    
    @Override
    public final @Nullable Consumer<Button> getOnClick() {
        return onClick;
    }
    
    @Override
    public final void setOnClick(@Nullable Consumer<Button> onClick) {
        this.onClick = onClick;
    }
    
    @Nullable
    @Override
    public final BiConsumer<class_4587, Button> getOnRender() {
        return onRender;
    }
    
    @Override
    public final void setOnRender(BiConsumer<class_4587, Button> onRender) {
        this.onRender = onRender;
    }
    
    @Override
    public final boolean isFocusable() {
        return focusable;
    }
    
    @Override
    public final void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }
    
    @Override
    public final @Nullable String getTooltip() {
        if (tooltipFunction == null)
            return null;
        return tooltipFunction.apply(this);
    }
    
    @Override
    public final void setTooltip(@Nullable Function<@NotNull Button, @Nullable String> tooltip) {
        this.tooltipFunction = tooltip;
    }
    
    @Override
    public final void setTextColor(@Nullable BiFunction<@NotNull Button, @NotNull Point, @NotNull Integer> textColorFunction) {
        this.textColorFunction = textColorFunction;
    }
    
    @Override
    public final void setTextureId(@Nullable BiFunction<@NotNull Button, @NotNull Point, @NotNull Integer> textureIdFunction) {
        this.textureIdFunction = textureIdFunction;
    }
    
    @Override
    public final int getTextColor(Point mouse) {
        if (this.textColorFunction != null) {
            Integer apply = this.textColorFunction.apply(this, mouse);
            if (apply != null)
                return apply;
        }
        if (!this.enabled) {
            return 10526880;
        } else if (isFocused(mouse.x, mouse.y)) {
            return 16777120;
        }
        return 14737632;
    }
    
    @Override
    public final @NotNull Rectangle getBounds() {
        return bounds;
    }
    
    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (onRender != null) {
            onRender.accept(matrices, this);
        }
        int x = bounds.x, y = bounds.y, width = bounds.width, height = bounds.height;
        renderBackground(matrices, x, y, width, height, this.getTextureId(new Point(mouseX, mouseY)));
        
        int color = 14737632;
        if (!this.enabled) {
            color = 10526880;
        } else if (isFocused(mouseX, mouseY)) {
            color = 16777120;
        }
        
        if (tint != null)
            method_25296(matrices, x + 1, y + 1, x + width - 1, y + height - 1, tint, tint);
        
        this.method_27534(matrices, font, getText(), x + width / 2, y + (height - 8) / 2, color);
        
        String tooltip = getTooltip();
        if (tooltip != null)
            if (!focused && containsMouse(mouseX, mouseY))
                Tooltip.create(CollectionUtils.map(tooltip.split("\n"), class_2585::new)).queue();
            else if (focused)
                Tooltip.create(new Point(x + width / 2, y + height / 2), CollectionUtils.map(tooltip.split("\n"), class_2585::new)).queue();
    }
    
    protected boolean isFocused(int mouseX, int mouseY) {
        return containsMouse(mouseX, mouseY) || focused;
    }
    
    @Override
    public boolean method_25407(boolean boolean_1) {
        if (!enabled || !focusable)
            return false;
        this.focused = !this.focused;
        return true;
    }
    
    @Override
    public void onClick() {
        Consumer<Button> onClick = getOnClick();
        if (onClick != null)
            onClick.accept(this);
    }
    
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (containsMouse(mouseX, mouseY) && isEnabled() && button == 0) {
            minecraft.method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
            onClick();
            return true;
        }
        return false;
    }
    
    @Override
    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (this.isEnabled() && focused) {
            if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
                return false;
            } else {
                minecraft.method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
                onClick();
                return true;
            }
        }
        return false;
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }
    
    @Override
    public final int getTextureId(Point mouse) {
        if (this.textureIdFunction != null) {
            Integer apply = this.textureIdFunction.apply(this, mouse);
            if (apply != null)
                return apply;
        }
        if (!this.isEnabled()) {
            return 0;
        } else if (containsMouse(mouse) || focused) {
            return 4; // 2 is the old blue highlight, 3 is the 1.15 outline, 4 is the 1.15 online + light hover
        }
        return 1;
    }
    
    protected void renderBackground(class_4587 matrices, int x, int y, int width, int height, int textureOffset) {
        minecraft.method_1531().method_22813(REIHelper.getInstance().isDarkThemeEnabled() ? BUTTON_LOCATION_DARK : BUTTON_LOCATION);
        RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate(770, 771, 1, 0);
        RenderSystem.blendFunc(770, 771);
        
        // 9 Patch Texture
        
        // Four Corners
        method_25291(matrices, x, y, method_25305(), 0, textureOffset * 80, 8, 8, 512, 256);
        method_25291(matrices, x + width - 8, y, method_25305(), 248, textureOffset * 80, 8, 8, 512, 256);
        method_25291(matrices, x, y + height - 8, method_25305(), 0, textureOffset * 80 + 72, 8, 8, 512, 256);
        method_25291(matrices, x + width - 8, y + height - 8, method_25305(), 248, textureOffset * 80 + 72, 8, 8, 512, 256);
        
        class_1159 matrix = matrices.method_23760().method_23761();
        // Sides
        class_332.method_25295(matrix, x + 8, x + width - 8, y, y + 8, getZ(), (8) / 256f, (248) / 256f, (textureOffset * 80) / 512f, (textureOffset * 80 + 8) / 512f);
        class_332.method_25295(matrix, x + 8, x + width - 8, y + height - 8, y + height, getZ(), (8) / 256f, (248) / 256f, (textureOffset * 80 + 72) / 512f, (textureOffset * 80 + 80) / 512f);
        class_332.method_25295(matrix, x, x + 8, y + 8, y + height - 8, getZ(), (0) / 256f, (8) / 256f, (textureOffset * 80 + 8) / 512f, (textureOffset * 80 + 72) / 512f);
        class_332.method_25295(matrix, x + width - 8, x + width, y + 8, y + height - 8, getZ(), (248) / 256f, (256) / 256f, (textureOffset * 80 + 8) / 512f, (textureOffset * 80 + 72) / 512f);
        
        // Center
        class_332.method_25295(matrix, x + 8, x + width - 8, y + 8, y + height - 8, getZ(), (8) / 256f, (248) / 256f, (textureOffset * 80 + 8) / 512f, (textureOffset * 80 + 72) / 512f);
    }
}
