/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.crafting;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.TransferRecipeCategory;
import me.shedaniel.rei.api.widgets.Slot;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.plugin.DefaultPlugin;
import me.shedaniel.rei.plugin.crafting.DefaultCraftingDisplay;
import me.shedaniel.rei.plugin.crafting.DefaultShapedDisplay;
import me.shedaniel.rei.server.ContainerInfo;
import me.shedaniel.rei.server.ContainerInfoHandler;
import net.minecraft.class_1074;
import net.minecraft.class_1703;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class DefaultCraftingCategory
implements TransferRecipeCategory<DefaultCraftingDisplay> {
    public static int getSlotWithSize(DefaultCraftingDisplay recipeDisplay, int num, int craftingGridWidth) {
        int x = num % recipeDisplay.getWidth();
        int y = (num - x) / recipeDisplay.getWidth();
        return craftingGridWidth * y + x;
    }

    @Override
    public class_2960 getIdentifier() {
        return DefaultPlugin.CRAFTING;
    }

    @Override
    public EntryStack getLogo() {
        return EntryStack.create((class_1935)class_2246.field_9980);
    }

    @Override
    public String getCategoryName() {
        return class_1074.method_4662((String)"category.rei.crafting", (Object[])new Object[0]);
    }

    @Override
    public List<Widget> setupDisplay(DefaultCraftingDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 58, bounds.getCenterY() - 27);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase(bounds));
        widgets.add(Widgets.createArrow(new Point(startPoint.x + 60, startPoint.y + 18)));
        widgets.add(Widgets.createResultSlotBackground(new Point(startPoint.x + 95, startPoint.y + 19)));
        List<List<EntryStack>> input = display.getInputEntries();
        ArrayList slots = Lists.newArrayList();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                slots.add(Widgets.createSlot(new Point(startPoint.x + 1 + x * 18, startPoint.y + 1 + y * 18)).markInput());
            }
        }
        for (int i = 0; i < input.size(); ++i) {
            if (display instanceof DefaultShapedDisplay) {
                if (input.get(i).isEmpty()) continue;
                ((Slot)((Object)slots.get(DefaultCraftingCategory.getSlotWithSize(display, i, 3)))).entries((Collection<EntryStack>)input.get(i));
                continue;
            }
            if (input.get(i).isEmpty()) continue;
            ((Slot)((Object)slots.get(i))).entries((Collection<EntryStack>)input.get(i));
        }
        widgets.addAll(slots);
        widgets.add(Widgets.createSlot(new Point(startPoint.x + 95, startPoint.y + 19)).entries(display.getOutputEntries()).disableBackground().markOutput());
        return widgets;
    }

    @Override
    public void renderRedSlots(class_4587 matrices, List<Widget> widgets, Rectangle bounds, DefaultCraftingDisplay display, IntList redSlots) {
        ContainerInfo<? extends class_1703> info = ContainerInfoHandler.getContainerInfo(this.getIdentifier(), REIHelper.getInstance().getPreviousContainerScreen().method_17577().getClass());
        if (info == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 400.0);
        Point startPoint = new Point(bounds.getCenterX() - 58, bounds.getCenterY() - 27);
        int width = info.getCraftingWidth((class_1703)REIHelper.getInstance().getPreviousContainerScreen().method_17577());
        for (Integer slot : redSlots) {
            int i = slot;
            int x = i % width;
            int y = class_3532.method_15375((float)((float)i / (float)width));
            class_332.method_25294((class_4587)matrices, (int)(startPoint.x + 1 + x * 18), (int)(startPoint.y + 1 + y * 18), (int)(startPoint.x + 1 + x * 18 + 16), (int)(startPoint.y + 1 + y * 18 + 16), (int)0x60FF0000);
        }
        matrices.method_22909();
    }
}

