/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.gui.toast.ExportRecipeIdentifierToast;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_276;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3306;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@ApiStatus.Experimental
public final class RecipeDisplayExporter
extends Widget {
    private static final RecipeDisplayExporter INSTANCE = new RecipeDisplayExporter();

    private RecipeDisplayExporter() {
    }

    public static void exportRecipeDisplay(Rectangle rectangle, List<Widget> widgets) {
        INSTANCE.exportRecipe(rectangle, widgets);
        ExportRecipeIdentifierToast.addToast(class_1074.method_4662((String)"msg.rei.exported_recipe", (Object[])new Object[0]), class_1074.method_4662((String)"msg.rei.exported_recipe.desc", (Object[])new Object[0]));
    }

    private static File getExportFilename(File directory) {
        String string = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        int i = 1;
        File file;
        while ((file = new File(directory, string + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file;
    }

    private void exportRecipe(Rectangle rectangle, List<Widget> widgets) {
        RenderSystem.pushMatrix();
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        class_276 framebuffer = new class_276(window.method_4489(), window.method_4506(), false, false);
        framebuffer.method_1235(true);
        RenderSystem.viewport((int)0, (int)0, (int)window.method_4489(), (int)window.method_4506());
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)((double)window.method_4489() / window.method_4495()), (double)((double)window.method_4506() / window.method_4495()), (double)0.0, (double)1000.0, (double)3000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.loadIdentity();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        class_308.method_24211();
        class_4587 matrices = new class_4587();
        for (Widget widget : widgets) {
            widget.method_25394(matrices, -1, -1, 0.0f);
        }
        RenderSystem.popMatrix();
        class_1011 nativeImage = new class_1011(framebuffer.field_1482, framebuffer.field_1481, false);
        RenderSystem.bindTexture((int)framebuffer.field_1475);
        nativeImage.method_4327(0, false);
        nativeImage.method_4319();
        int outWidth = (int)((double)rectangle.width * window.method_4495());
        int outHeight = (int)((double)rectangle.height * window.method_4495());
        class_1011 strippedImage = new class_1011(outWidth, outHeight, false);
        for (int y = 0; y < outHeight; ++y) {
            for (int x = 0; x < outWidth; ++x) {
                strippedImage.method_4305(x, y, nativeImage.method_4315(x + (int)((double)rectangle.x * window.method_4495()), y + (int)((double)rectangle.y * window.method_4495())));
            }
        }
        class_3306.field_14301.execute(() -> {
            try {
                File export = new File(this.minecraft.field_1697, "rei_exports");
                export.mkdirs();
                strippedImage.method_4325(RecipeDisplayExporter.getExportFilename(export));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                nativeImage.close();
                strippedImage.close();
                RenderSystem.recordRenderCall(() -> ((class_276)framebuffer).method_1238());
            }
        });
    }

    public void method_25394(class_4587 matrixStack, int mouseY, int i, float f) {
    }

    public List<? extends class_364> method_25396() {
        return null;
    }
}

