/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui.config.entry;

import com.google.common.collect.ImmutableList;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.ConfigReloadingScreen;
import net.minecraft.class_1041;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3902;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;

import java.util.List;
import java.util.Optional;

@ApiStatus.Internal
public class ReloadPluginsEntry extends AbstractConfigListEntry<class_3902> {
    private int width;
    private class_339 buttonWidget = new class_4185(0, 0, 0, 20, class_333.field_18967, button -> RoughlyEnoughItemsCore.syncRecipes(null)) {
        @Override
        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (RecipeHelper.getInstance().arePluginsLoading()) {
                class_310.method_1551().method_1507(new ConfigReloadingScreen(class_310.method_1551().field_1755));
            } else
                super.method_25394(matrices, mouseX, mouseY, delta);
        }
    };
    private List<class_364> children = ImmutableList.of(buttonWidget);
    
    public ReloadPluginsEntry(int width) {
        super(class_333.field_18967, false);
        this.width = width;
        buttonWidget.method_25355(new class_2588("text.rei.reload_config"));
    }
    
    @Override
    public class_3902 getValue() {
        return class_3902.field_17274;
    }
    
    @Override
    public Optional<class_3902> getDefaultValue() {
        return Optional.of(class_3902.field_17274);
    }
    
    @Override
    public void save() {
        
    }
    
    @Override
    public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        class_1041 window = class_310.method_1551().method_22683();
        this.buttonWidget.field_22763 = this.isEditable();
        this.buttonWidget.field_22761 = y;
        this.buttonWidget.field_22760 = x + entryWidth / 2 - width / 2;
        this.buttonWidget.method_25358(width);
        this.buttonWidget.method_25394(matrices, mouseX, mouseY, delta);
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        return children;
    }
}
