/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.entries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.widgets.Slot;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SimpleRecipeEntry
extends RecipeEntry {
    private static final Comparator<EntryStack> ENTRY_COMPARATOR = Comparator.comparingLong(Object::hashCode);
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private List<Slot> inputWidgets;
    private Slot outputWidget;

    @ApiStatus.Internal
    protected SimpleRecipeEntry(List<List<EntryStack>> input, List<EntryStack> output) {
        ArrayList newList = Lists.newArrayList();
        List<class_3545> a = CollectionUtils.map(input, stacks -> new class_3545(stacks, (Object)stacks.stream().map(EntryStack::getAmount).max(Integer::compareTo).orElse(1)));
        for (class_3545 pair : a) {
            class_3545 any = CollectionUtils.findFirstOrNull(newList, pairr -> SimpleRecipeEntry.equalsList((List)pair.method_15442(), (List)pairr.method_15442()));
            if (any != null) {
                ((AtomicInteger)any.method_15441()).addAndGet((Integer)pair.method_15441());
                continue;
            }
            newList.add(new class_3545(pair.method_15442(), (Object)new AtomicInteger((Integer)pair.method_15441())));
        }
        ArrayList b = Lists.newArrayList();
        for (class_3545 pair : newList) {
            b.add(((List)pair.method_15442()).stream().map(stack -> {
                EntryStack s = stack.copy();
                s.setAmount(((AtomicInteger)pair.method_15441()).get());
                return s;
            }).collect(Collectors.toList()));
        }
        this.inputWidgets = b.stream().filter(stacks -> !stacks.isEmpty()).map(stacks -> Widgets.createSlot(new Point(0, 0)).entries((Collection<EntryStack>)stacks).disableBackground().disableHighlight().disableTooltips()).collect(Collectors.toList());
        this.outputWidget = Widgets.createSlot(new Point(0, 0)).entries(CollectionUtils.filter(output, stack -> !stack.isEmpty())).disableBackground().disableHighlight().disableTooltips();
    }

    public static RecipeEntry create(Supplier<List<List<EntryStack>>> input, Supplier<List<EntryStack>> output) {
        return SimpleRecipeEntry.create(input.get(), output.get());
    }

    public static RecipeEntry create(List<List<EntryStack>> input, List<EntryStack> output) {
        return new SimpleRecipeEntry(input, output);
    }

    public static boolean equalsList(List<EntryStack> list_1, List<EntryStack> list_2) {
        List stacks_2;
        List stacks_1 = list_1.stream().distinct().sorted(ENTRY_COMPARATOR).collect(Collectors.toList());
        if (stacks_1.equals(stacks_2 = list_2.stream().distinct().sorted(ENTRY_COMPARATOR).collect(Collectors.toList()))) {
            return true;
        }
        if (stacks_1.size() != stacks_2.size()) {
            return false;
        }
        for (int i = 0; i < stacks_1.size(); ++i) {
            if (((EntryStack)stacks_1.get(i)).equalsIgnoreTagsAndAmount((EntryStack)stacks_2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        int xx = bounds.x + 4;
        int yy = bounds.y + 2;
        int j = 0;
        int itemsPerLine = this.getItemsPerLine();
        for (Slot entryWidget : this.inputWidgets) {
            entryWidget.setZ(this.getZ() + 50);
            entryWidget.getBounds().setLocation(xx, yy);
            entryWidget.method_25394(matrices, mouseX, mouseY, delta);
            xx += 18;
            if (++j < this.getItemsPerLine() - 2) continue;
            yy += 18;
            xx = bounds.x + 4;
            j = 0;
        }
        xx = bounds.x + 4 + 18 * (this.getItemsPerLine() - 2);
        yy = bounds.y + this.getHeight() / 2 - 8;
        class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
        this.method_25302(matrices, xx, yy, 0, 28, 18, 18);
        this.outputWidget.setZ(this.getZ() + 50);
        this.outputWidget.getBounds().setLocation(xx += 18, yy);
        this.outputWidget.method_25394(matrices, mouseX, mouseY, delta);
    }

    @Override
    @Nullable
    public Tooltip getTooltip(Point point) {
        for (Slot widget : this.inputWidgets) {
            if (!widget.containsMouse(point)) continue;
            return widget.getCurrentTooltip(point);
        }
        if (this.outputWidget.containsMouse(point)) {
            return this.outputWidget.getCurrentTooltip(point);
        }
        return null;
    }

    @Override
    public int getHeight() {
        return 4 + this.getItemsHeight() * 18;
    }

    public int getItemsHeight() {
        return class_3532.method_15386((float)((float)this.inputWidgets.size() / (float)(this.getItemsPerLine() - 2)));
    }

    public int getItemsPerLine() {
        return class_3532.method_15375((float)(((float)this.getWidth() - 4.0f) / 18.0f));
    }
}

