/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.impl.AbstractEntryStack;
import me.shedaniel.rei.impl.SimpleFluidRenderer;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1074;
import net.minecraft.class_1159;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FluidEntryStack
extends AbstractEntryStack {
    private static final double IGNORE_AMOUNT = -1.319182373E9;
    private class_3611 fluid;
    private double amount;

    public FluidEntryStack(class_3611 fluid) {
        this(fluid, -1.319182373E9);
    }

    public FluidEntryStack(class_3611 fluid, int amount) {
        this(fluid, (double)amount);
    }

    public FluidEntryStack(class_3611 fluid, double amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    @Override
    public Optional<class_2960> getIdentifier() {
        return Optional.ofNullable(class_2378.field_11154.method_10221((Object)this.getFluid()));
    }

    @Override
    public EntryStack.Type getType() {
        return EntryStack.Type.FLUID;
    }

    @Override
    public double getFloatingAmount() {
        return this.amount;
    }

    @Override
    public void setFloatingAmount(double amount) {
        double d = this.amount = amount == -1.319182373E9 ? -1.319182373E9 : Math.max(amount, 0.0);
        if (this.isEmpty()) {
            this.fluid = class_3612.field_15906;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.amount != -1.319182373E9 && this.amount <= 0.0 || this.fluid == class_3612.field_15906;
    }

    @Override
    public EntryStack copy() {
        EntryStack stack = EntryStack.create(this.fluid, this.amount);
        for (Map.Entry<EntryStack.Settings<?>, Object> entry : this.getSettings().entrySet()) {
            stack.setting(entry.getKey(), entry.getValue());
        }
        return stack;
    }

    @Override
    public Object getObject() {
        return this.fluid;
    }

    @Override
    public boolean equalsIgnoreTagsAndAmount(EntryStack stack) {
        if (stack.getType() == EntryStack.Type.ITEM) {
            return this.equalsIgnoreTagsAndAmount(EntryStack.copyItemToFluid(stack));
        }
        if (stack.getType() != EntryStack.Type.FLUID) {
            return false;
        }
        return this.fluid == stack.getFluid();
    }

    @Override
    public boolean equalsIgnoreTags(EntryStack stack) {
        if (stack.getType() == EntryStack.Type.ITEM) {
            return this.equalsIgnoreTags(EntryStack.copyItemToFluid(stack));
        }
        if (stack.getType() != EntryStack.Type.FLUID) {
            return false;
        }
        return this.fluid == stack.getFluid() && (this.amount == -1.319182373E9 || (double)stack.getAmount() == -1.319182373E9 || this.amount == (double)stack.getAmount());
    }

    @Override
    public boolean equalsIgnoreAmount(EntryStack stack) {
        if (stack.getType() == EntryStack.Type.ITEM) {
            return this.equalsIgnoreAmount(EntryStack.copyItemToFluid(stack));
        }
        if (stack.getType() != EntryStack.Type.FLUID) {
            return false;
        }
        return this.fluid == stack.getFluid();
    }

    @Override
    public boolean equalsAll(EntryStack stack) {
        if (stack.getType() != EntryStack.Type.FLUID) {
            return false;
        }
        return this.fluid == stack.getFluid() && (this.amount == -1.319182373E9 || (double)stack.getAmount() == -1.319182373E9 || this.amount == (double)stack.getAmount());
    }

    @Override
    public int hashOfAll() {
        int result = this.hashIgnoreAmountAndTags();
        result = 31 * result + Double.hashCode(this.amount);
        return result;
    }

    @Override
    public int hashIgnoreAmountAndTags() {
        int result = 1;
        result = 31 * result + this.getType().ordinal();
        result = 31 * result + this.fluid.hashCode();
        return result;
    }

    @Override
    public int hashIgnoreTags() {
        return this.hashOfAll();
    }

    @Override
    public int hashIgnoreAmount() {
        return this.hashIgnoreAmountAndTags();
    }

    @Override
    @Nullable
    public Tooltip getTooltip(Point point) {
        String amountTooltip;
        if (!this.get(EntryStack.Settings.TOOLTIP_ENABLED).get().booleanValue() || this.isEmpty()) {
            return null;
        }
        ArrayList toolTip = Lists.newArrayList((Object[])new class_2561[]{this.asFormattedText()});
        if (this.amount >= 0.0 && (amountTooltip = this.get(EntryStack.Settings.Fluid.AMOUNT_TOOLTIP).apply(this)) != null) {
            toolTip.addAll(Stream.of(amountTooltip.split("\n")).map(class_2585::new).collect(Collectors.toList()));
        }
        toolTip.addAll((Collection)this.get(EntryStack.Settings.TOOLTIP_APPEND_EXTRA).apply(this));
        if (this.get(EntryStack.Settings.TOOLTIP_APPEND_MOD).get().booleanValue() && ConfigObject.getInstance().shouldAppendModNames()) {
            class_2960 id = class_2378.field_11154.method_10221((Object)this.fluid);
            class_2561 modString = ClientHelper.getInstance().getFormattedModFromIdentifier(id);
            String modId = ClientHelper.getInstance().getModFromIdentifier(id);
            boolean alreadyHasMod = false;
            for (class_2561 s : toolTip) {
                if (!s.method_10851().equalsIgnoreCase(modId)) continue;
                alreadyHasMod = true;
                break;
            }
            if (!alreadyHasMod) {
                toolTip.add(modString);
            }
        }
        return Tooltip.create(toolTip);
    }

    @Override
    public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        SimpleFluidRenderer.FluidRenderingData renderingData;
        if (this.get(EntryStack.Settings.RENDER).get().booleanValue() && (renderingData = SimpleFluidRenderer.fromFluid(this.fluid)) != null) {
            class_1058 sprite = renderingData.getSprite();
            int color = renderingData.getColor();
            int a = 255;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            class_310.method_1551().method_1531().method_22813(class_1059.field_5275);
            class_289 tess = class_289.method_1348();
            class_287 bb = tess.method_1349();
            class_1159 matrix = matrices.method_23760().method_23761();
            bb.method_1328(7, class_290.field_1575);
            bb.method_22918(matrix, (float)bounds.getMaxX(), (float)bounds.y, (float)this.getZ()).method_22913(sprite.method_4577(), sprite.method_4593()).method_1336(r, g, b, a).method_1344();
            bb.method_22918(matrix, (float)bounds.x, (float)bounds.y, (float)this.getZ()).method_22913(sprite.method_4594(), sprite.method_4593()).method_1336(r, g, b, a).method_1344();
            bb.method_22918(matrix, (float)bounds.x, (float)bounds.getMaxY(), (float)this.getZ()).method_22913(sprite.method_4594(), sprite.method_4575()).method_1336(r, g, b, a).method_1344();
            bb.method_22918(matrix, (float)bounds.getMaxX(), (float)bounds.getMaxY(), (float)this.getZ()).method_22913(sprite.method_4577(), sprite.method_4575()).method_1336(r, g, b, a).method_1344();
            tess.method_1350();
        }
    }

    @Override
    @NotNull
    public class_2561 asFormattedText() {
        class_2960 id = class_2378.field_11154.method_10221((Object)this.fluid);
        if (class_1074.method_4663((String)("block." + id.toString().replaceFirst(":", ".")))) {
            return new class_2588("block." + id.toString().replaceFirst(":", "."));
        }
        return new class_2585(CollectionUtils.mapAndJoinToString(id.method_12832().split("_"), StringUtils::capitalize, " "));
    }
}

