/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.fluid.FluidSupportProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
@ApiStatus.Internal
public class FluidSupportProviderImpl
implements FluidSupportProvider {
    private final List<FluidSupportProvider.FluidProvider> providers = Lists.newArrayList();

    public void reset() {
        this.providers.clear();
    }

    @Override
    public void registerFluidProvider(@NotNull FluidSupportProvider.FluidProvider provider) {
        this.providers.add(Objects.requireNonNull(provider, "Registered provider is null!"));
    }

    @Override
    @NotNull
    public EntryStack itemToFluid(@NotNull EntryStack itemStack) {
        if (itemStack.isEmpty()) {
            return EntryStack.empty();
        }
        if (itemStack.getType() != EntryStack.Type.ITEM) {
            throw new IllegalArgumentException("EntryStack must be item!");
        }
        for (FluidSupportProvider.FluidProvider provider : this.providers) {
            EntryStack stack = Objects.requireNonNull(provider.itemToFluid(itemStack), provider.getClass() + " is creating null objects for itemToFluid!");
            if (stack.isEmpty()) continue;
            return stack;
        }
        return EntryStack.empty();
    }
}

