/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.AutoTransferHandler;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.DisplayVisibilityHandler;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.LiveRecipeGenerator;
import me.shedaniel.rei.api.OverlayDecider;
import me.shedaniel.rei.api.REIPluginEntry;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.plugins.REIPluginV0;
import me.shedaniel.rei.api.subsets.SubsetsRegistry;
import me.shedaniel.rei.impl.BaseBoundsHandlerImpl;
import me.shedaniel.rei.impl.DisplayHelperImpl;
import me.shedaniel.rei.impl.EntryRegistryImpl;
import me.shedaniel.rei.impl.FluidSupportProviderImpl;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.subsets.SubsetsRegistryImpl;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_465;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class RecipeHelperImpl
implements RecipeHelper {
    private static final Comparator<DisplayVisibilityHandler> VISIBILITY_HANDLER_COMPARATOR;
    private static final Comparator<class_1860> RECIPE_COMPARATOR;
    private final List<AutoTransferHandler> autoTransferHandlers = Lists.newLinkedList();
    private final List<RecipeFunction> recipeFunctions = Lists.newLinkedList();
    private final List<RecipeHelper.ScreenClickArea> screenClickAreas = Lists.newLinkedList();
    private final int[] recipeCount = new int[]{0};
    private final Map<class_2960, List<RecipeDisplay>> recipeCategoryListMap = Maps.newLinkedHashMap();
    private final Map<RecipeCategory<?>, class_2960> categories = Maps.newLinkedHashMap();
    private final Map<class_2960, RecipeCategory<?>> reversedCategories = Maps.newHashMap();
    private final Map<class_2960, ButtonAreaSupplier> autoCraftAreaSupplierMap = Maps.newLinkedHashMap();
    private final Map<class_2960, List<List<EntryStack>>> categoryWorkingStations = Maps.newLinkedHashMap();
    private final List<DisplayVisibilityHandler> displayVisibilityHandlers = Lists.newLinkedList();
    private final List<LiveRecipeGenerator<RecipeDisplay>> liveRecipeGenerators = Lists.newLinkedList();
    private class_1863 recipeManager;
    private boolean arePluginsLoading = false;

    @Override
    public List<EntryStack> findCraftableEntriesByItems(List<EntryStack> inventoryItems) {
        ArrayList<EntryStack> craftables = new ArrayList<EntryStack>();
        for (List<RecipeDisplay> value : this.recipeCategoryListMap.values()) {
            for (RecipeDisplay recipeDisplay : Lists.newArrayList(value)) {
                int slotsCraftable = 0;
                List<List<EntryStack>> requiredInput = recipeDisplay.getRequiredEntries();
                block2: for (List<EntryStack> slot : requiredInput) {
                    if (slot.isEmpty()) {
                        ++slotsCraftable;
                        continue;
                    }
                    for (EntryStack possibleType : inventoryItems) {
                        for (EntryStack slotPossible : slot) {
                            if (!possibleType.equals(slotPossible)) continue;
                            ++slotsCraftable;
                            continue block2;
                        }
                    }
                }
                if (slotsCraftable != recipeDisplay.getRequiredEntries().size()) continue;
                craftables.addAll(recipeDisplay.getOutputEntries());
            }
        }
        return craftables.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public boolean arePluginsLoading() {
        return this.arePluginsLoading;
    }

    @Override
    public void registerCategory(RecipeCategory<?> category) {
        this.categories.put(category, category.getIdentifier());
        this.reversedCategories.put(category.getIdentifier(), category);
        this.recipeCategoryListMap.put(category.getIdentifier(), Lists.newArrayList());
        this.categoryWorkingStations.put(category.getIdentifier(), Lists.newArrayList());
    }

    @Override
    @SafeVarargs
    public final void registerWorkingStations(class_2960 category, List<EntryStack> ... workingStations) {
        this.categoryWorkingStations.get(category).addAll(Arrays.asList(workingStations));
    }

    @Override
    public void registerWorkingStations(class_2960 category, EntryStack ... workingStations) {
        this.categoryWorkingStations.get(category).addAll(Arrays.stream(workingStations).map(Collections::singletonList).collect(Collectors.toList()));
    }

    @Override
    public List<List<EntryStack>> getWorkingStations(class_2960 category) {
        return this.categoryWorkingStations.get(category);
    }

    @Override
    @Deprecated
    public void registerDisplay(class_2960 categoryIdentifier, RecipeDisplay display) {
        if (!this.recipeCategoryListMap.containsKey(categoryIdentifier)) {
            return;
        }
        this.recipeCount[0] = this.recipeCount[0] + 1;
        this.recipeCategoryListMap.get(categoryIdentifier).add(display);
    }

    @Override
    public void registerDisplay(RecipeDisplay display) {
        class_2960 identifier = Objects.requireNonNull(display.getRecipeCategory());
        if (!this.recipeCategoryListMap.containsKey(identifier)) {
            return;
        }
        this.recipeCount[0] = this.recipeCount[0] + 1;
        this.recipeCategoryListMap.get(identifier).add(display);
    }

    private void registerDisplay(class_2960 categoryIdentifier, RecipeDisplay display, int index) {
        if (!this.recipeCategoryListMap.containsKey(categoryIdentifier)) {
            return;
        }
        this.recipeCount[0] = this.recipeCount[0] + 1;
        this.recipeCategoryListMap.get(categoryIdentifier).add(index, display);
    }

    @Override
    public Map<RecipeCategory<?>, List<RecipeDisplay>> buildMapFor(ClientHelper.ViewSearchBuilder builder) {
        long start = class_156.method_648();
        Set<class_2960> categories = builder.getCategories();
        List<EntryStack> recipesFor = builder.getRecipesFor();
        List<EntryStack> usagesFor = builder.getUsagesFor();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<RecipeCategory<?>, class_2960> entry : this.categories.entrySet()) {
            RecipeCategory<?> category = entry.getKey();
            class_2960 categoryId = entry.getValue();
            List<RecipeDisplay> allRecipesFromCategory = this.getAllRecipesFromCategory(category);
            LinkedHashSet set = Sets.newLinkedHashSet();
            if (categories.contains(categoryId)) {
                for (RecipeDisplay display : allRecipesFromCategory) {
                    if (!this.isDisplayVisible(display)) continue;
                    set.add(display);
                }
                if (set.isEmpty()) continue;
                CollectionUtils.getOrPutEmptyList(result, category).addAll(set);
                continue;
            }
            block2: for (RecipeDisplay display : allRecipesFromCategory) {
                if (!this.isDisplayVisible(display)) continue;
                if (!recipesFor.isEmpty()) {
                    block3: for (EntryStack entryStack : display.getOutputEntries()) {
                        for (EntryStack stack : recipesFor) {
                            if (!stack.equals(entryStack)) continue;
                            set.add(display);
                            break block3;
                        }
                    }
                }
                if (usagesFor.isEmpty()) continue;
                for (List list : display.getInputEntries()) {
                    for (EntryStack otherEntry : list) {
                        for (EntryStack stack : usagesFor) {
                            if (!otherEntry.equals(stack)) continue;
                            set.add(display);
                            continue block2;
                        }
                    }
                }
            }
            for (EntryStack stack : usagesFor) {
                if (!this.isStackWorkStationOfCategory(categoryId, stack)) continue;
                set.addAll(allRecipesFromCategory);
                break;
            }
            if (set.isEmpty()) continue;
            CollectionUtils.getOrPutEmptyList(result, category).addAll(set);
        }
        for (LiveRecipeGenerator liveRecipeGenerator : this.liveRecipeGenerators) {
            LinkedHashSet set = Sets.newLinkedHashSet();
            for (EntryStack stack : recipesFor) {
                Optional recipeForDisplays = liveRecipeGenerator.getRecipeFor(stack);
                if (!recipeForDisplays.isPresent()) continue;
                for (RecipeDisplay display : recipeForDisplays.get()) {
                    if (!this.isDisplayVisible(display)) continue;
                    set.add(display);
                }
            }
            for (EntryStack stack : usagesFor) {
                Optional usageForDisplays = liveRecipeGenerator.getUsageFor(stack);
                if (!usageForDisplays.isPresent()) continue;
                for (RecipeDisplay display : usageForDisplays.get()) {
                    if (!this.isDisplayVisible(display)) continue;
                    set.add(display);
                }
            }
            Optional displaysGenerated = liveRecipeGenerator.getDisplaysGenerated(builder);
            if (displaysGenerated.isPresent()) {
                for (RecipeDisplay display : displaysGenerated.get()) {
                    if (!this.isDisplayVisible(display)) continue;
                    set.add(display);
                }
            }
            if (set.isEmpty()) continue;
            CollectionUtils.getOrPutEmptyList(result, this.getCategory(liveRecipeGenerator.getCategoryIdentifier())).addAll(set);
        }
        long end = class_156.method_648();
        String message = String.format("Built Recipe View in %d\u03bcs for %d categories, %d recipes for, %d usages for and %d live recipe generators.", (end - start) / 1000L, categories.size(), recipesFor.size(), usagesFor.size(), this.liveRecipeGenerators.size());
        if (ConfigObject.getInstance().doDebugSearchTimeRequired()) {
            RoughlyEnoughItemsCore.LOGGER.info(message);
        } else {
            RoughlyEnoughItemsCore.LOGGER.trace(message);
        }
        return result;
    }

    @Override
    public Map<RecipeCategory<?>, List<RecipeDisplay>> getRecipesFor(EntryStack stack) {
        return this.buildMapFor(ClientHelper.ViewSearchBuilder.builder().addRecipesFor(stack));
    }

    @Override
    public RecipeCategory<?> getCategory(class_2960 identifier) {
        return this.reversedCategories.get(identifier);
    }

    @Override
    public class_1863 getRecipeManager() {
        return this.recipeManager;
    }

    private boolean isStackWorkStationOfCategory(class_2960 category, EntryStack stack) {
        for (List<EntryStack> stacks : this.getWorkingStations(category)) {
            for (EntryStack entryStack : stacks) {
                if (!entryStack.equalsIgnoreTagsAndAmount(stack)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<RecipeCategory<?>, List<RecipeDisplay>> getUsagesFor(EntryStack stack) {
        return this.buildMapFor(ClientHelper.ViewSearchBuilder.builder().addUsagesFor(stack));
    }

    @Override
    public List<RecipeCategory<?>> getAllCategories() {
        return Lists.newArrayList(this.categories.keySet());
    }

    @Override
    public Optional<ButtonAreaSupplier> getAutoCraftButtonArea(RecipeCategory<?> category) {
        if (!this.autoCraftAreaSupplierMap.containsKey(category.getIdentifier())) {
            return Optional.ofNullable(bounds -> new Rectangle(bounds.getMaxX() - 16, bounds.getMaxY() - 16, 10, 10));
        }
        return Optional.ofNullable(this.autoCraftAreaSupplierMap.get(category.getIdentifier()));
    }

    @Override
    public void registerAutoCraftButtonArea(class_2960 category, ButtonAreaSupplier rectangle) {
        if (rectangle == null) {
            this.autoCraftAreaSupplierMap.remove(category);
        } else {
            this.autoCraftAreaSupplierMap.put(category, rectangle);
        }
    }

    private void startSection(Object[] sectionData, String section) {
        sectionData[0] = class_156.method_648();
        sectionData[2] = section;
        RoughlyEnoughItemsCore.LOGGER.debug("Reloading Section: \"%s\"", (Object)section);
    }

    private void endSection(Object[] sectionData) {
        sectionData[1] = class_156.method_648();
        long time = (Long)sectionData[1] - (Long)sectionData[0];
        String section = (String)sectionData[2];
        if (time >= 1000000L) {
            RoughlyEnoughItemsCore.LOGGER.debug("Reloading Section: \"%s\" done in %.2fms", (Object)section, (Object)Float.valueOf((float)time / 1000000.0f));
        } else {
            RoughlyEnoughItemsCore.LOGGER.debug("Reloading Section: \"%s\" done in %.2f\u03bcs", (Object)section, (Object)Float.valueOf((float)time / 1000.0f));
        }
    }

    private void pluginSection(Object[] sectionData, String sectionName, List<REIPluginV0> list, Consumer<REIPluginV0> consumer) {
        for (REIPluginV0 plugin : list) {
            try {
                this.startSection(sectionData, sectionName + " for " + plugin.getPluginIdentifier().toString());
                consumer.accept(plugin);
                this.endSection(sectionData);
            }
            catch (Throwable e) {
                RoughlyEnoughItemsCore.LOGGER.error(plugin.getPluginIdentifier().toString() + " plugin failed to " + sectionName + "!", e);
            }
        }
    }

    public void recipesLoaded(class_1863 recipeManager) {
        long startTime = class_156.method_658();
        Object[] sectionData = new Object[]{0L, 0L, ""};
        this.startSection(sectionData, "reset-data");
        this.arePluginsLoading = true;
        ScreenHelper.clearLastRecipeScreenData();
        this.recipeCount[0] = 0;
        this.recipeManager = recipeManager;
        this.recipeCategoryListMap.clear();
        this.categories.clear();
        this.reversedCategories.clear();
        this.autoCraftAreaSupplierMap.clear();
        this.screenClickAreas.clear();
        this.categoryWorkingStations.clear();
        this.recipeFunctions.clear();
        this.displayVisibilityHandlers.clear();
        this.liveRecipeGenerators.clear();
        this.autoTransferHandlers.clear();
        ((SubsetsRegistryImpl)SubsetsRegistry.INSTANCE).reset();
        ((FluidSupportProviderImpl)FluidSupportProvider.INSTANCE).reset();
        ((DisplayHelperImpl)DisplayHelper.getInstance()).resetData();
        ((DisplayHelperImpl)DisplayHelper.getInstance()).resetCache();
        BaseBoundsHandlerImpl baseBoundsHandler = new BaseBoundsHandlerImpl();
        DisplayHelper.getInstance().registerHandler(baseBoundsHandler);
        ((DisplayHelperImpl)DisplayHelper.getInstance()).setBaseBoundsHandler(baseBoundsHandler);
        List<REIPluginEntry> plugins = RoughlyEnoughItemsCore.getPlugins();
        plugins.sort(Comparator.comparingInt(REIPluginEntry::getPriority).reversed());
        RoughlyEnoughItemsCore.LOGGER.info("Reloading REI, registered %d plugins: %s", (Object)plugins.size(), (Object)plugins.stream().map(REIPluginEntry::getPluginIdentifier).map(class_2960::toString).collect(Collectors.joining(", ")));
        Collections.reverse(plugins);
        ((EntryRegistryImpl)EntryRegistry.getInstance()).reset();
        ArrayList<REIPluginV0> reiPluginV0s = new ArrayList<REIPluginV0>();
        this.endSection(sectionData);
        for (REIPluginEntry plugin2 : plugins) {
            try {
                if (!(plugin2 instanceof REIPluginV0)) continue;
                this.startSection(sectionData, "pre-register for " + plugin2.getPluginIdentifier().toString());
                ((REIPluginV0)plugin2).preRegister();
                reiPluginV0s.add((REIPluginV0)plugin2);
                this.endSection(sectionData);
            }
            catch (Throwable e) {
                RoughlyEnoughItemsCore.LOGGER.error(plugin2.getPluginIdentifier().toString() + " plugin failed to pre register!", e);
            }
        }
        DisplayHelper displayHelper = DisplayHelper.getInstance();
        EntryRegistry entryRegistry = EntryRegistry.getInstance();
        this.pluginSection(sectionData, "register-bounds", reiPluginV0s, plugin -> plugin.registerBounds(displayHelper));
        this.pluginSection(sectionData, "register-entries", reiPluginV0s, plugin -> plugin.registerEntries(entryRegistry));
        this.pluginSection(sectionData, "register-categories", reiPluginV0s, plugin -> plugin.registerPluginCategories(this));
        this.pluginSection(sectionData, "register-displays", reiPluginV0s, plugin -> plugin.registerRecipeDisplays(this));
        this.pluginSection(sectionData, "register-others", reiPluginV0s, plugin -> plugin.registerOthers(this));
        this.pluginSection(sectionData, "post-register", reiPluginV0s, REIPluginV0::postRegister);
        this.startSection(sectionData, "recipe-functions");
        if (!this.recipeFunctions.isEmpty()) {
            List<class_1860> allSortedRecipes = this.getAllSortedRecipes();
            Collections.reverse(allSortedRecipes);
            for (RecipeFunction recipeFunction : this.recipeFunctions) {
                try {
                    for (class_1860 recipe2 : CollectionUtils.filter(allSortedRecipes, recipe -> recipeFunction.recipeFilter.test((class_1860)recipe))) {
                        this.registerDisplay(recipeFunction.category, (RecipeDisplay)recipeFunction.mappingFunction.apply(recipe2), 0);
                    }
                }
                catch (Exception e) {
                    RoughlyEnoughItemsCore.LOGGER.error("Failed to add recipes!", (Throwable)e);
                }
            }
        }
        this.endSection(sectionData);
        this.startSection(sectionData, "fill-handlers");
        if (this.getDisplayVisibilityHandlers().isEmpty()) {
            this.registerRecipeVisibilityHandler(new DisplayVisibilityHandler(){

                @Override
                public class_1269 handleDisplay(RecipeCategory<?> category, RecipeDisplay display) {
                    return class_1269.field_5812;
                }

                @Override
                public float getPriority() {
                    return -1.0f;
                }
            });
        }
        DisplayHelper.getInstance().registerHandler(new OverlayDecider(){

            @Override
            public boolean isHandingScreen(Class<?> screen) {
                return true;
            }

            @Override
            public class_1269 shouldScreenBeOverlayed(Class<?> screen) {
                return class_465.class.isAssignableFrom(screen) ? class_1269.field_5812 : class_1269.field_5811;
            }

            @Override
            public float getPriority() {
                return -10.0f;
            }
        });
        this.endSection(sectionData);
        ((DisplayHelperImpl)DisplayHelper.getInstance()).resetCache();
        ScreenHelper.getOptionalOverlay().ifPresent(overlay -> {
            overlay.shouldReInit = true;
        });
        this.startSection(sectionData, "entry-registry-distinct");
        ((EntryRegistryImpl)EntryRegistry.getInstance()).distinct();
        this.endSection(sectionData);
        this.startSection(sectionData, "entry-registry-refilter");
        this.arePluginsLoading = false;
        ((EntryRegistryImpl)EntryRegistry.getInstance()).refilter();
        this.endSection(sectionData);
        this.startSection(sectionData, "finalizing");
        ((DisplayHelperImpl)DisplayHelper.getInstance()).resetCache();
        ScreenHelper.getOptionalOverlay().ifPresent(overlay -> {
            overlay.shouldReInit = true;
        });
        this.displayVisibilityHandlers.sort(VISIBILITY_HANDLER_COMPARATOR);
        this.endSection(sectionData);
        long usedTime = class_156.method_658() - startTime;
        RoughlyEnoughItemsCore.LOGGER.info("Reloaded %d stack entries, %d recipes displays, %d exclusion zones suppliers, %d overlay deciders, %d visibility handlers and %d categories (%s) in %dms.", (Object)EntryRegistry.getInstance().getStacksList().size(), (Object)this.recipeCount[0], (Object)BaseBoundsHandler.getInstance().supplierSize(), (Object)DisplayHelper.getInstance().getAllOverlayDeciders().size(), (Object)this.getDisplayVisibilityHandlers().size(), (Object)this.categories.size(), (Object)this.categories.keySet().stream().map(RecipeCategory::getCategoryName).collect(Collectors.joining(", ")), (Object)usedTime);
    }

    @Override
    public AutoTransferHandler registerAutoCraftingHandler(AutoTransferHandler handler) {
        this.autoTransferHandlers.add(handler);
        return handler;
    }

    @Override
    public List<AutoTransferHandler> getSortedAutoCraftingHandler() {
        return this.autoTransferHandlers.stream().sorted(Comparator.comparingDouble(AutoTransferHandler::getPriority).reversed()).collect(Collectors.toList());
    }

    @Override
    public int getRecipeCount() {
        return this.recipeCount[0];
    }

    @Override
    public List<class_1860> getAllSortedRecipes() {
        return this.getRecipeManager().method_8126().stream().sorted(RECIPE_COMPARATOR).collect(Collectors.toList());
    }

    @Override
    public Map<RecipeCategory<?>, List<RecipeDisplay>> getAllRecipes() {
        return this.buildMapFor(ClientHelper.ViewSearchBuilder.builder().addAllCategories());
    }

    @Override
    public Map<RecipeCategory<?>, List<RecipeDisplay>> getAllRecipesNoHandlers() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<RecipeCategory<?>, class_2960> entry : this.categories.entrySet()) {
            RecipeCategory<?> category = entry.getKey();
            class_2960 categoryId = entry.getValue();
            ArrayList displays = Lists.newArrayList((Iterable)this.recipeCategoryListMap.get(categoryId));
            if (displays == null || displays.isEmpty()) continue;
            result.put(category, displays);
        }
        return result;
    }

    @Override
    public List<RecipeDisplay> getAllRecipesFromCategory(RecipeCategory<?> category) {
        return Lists.newArrayList((Iterable)this.recipeCategoryListMap.get(category.getIdentifier()));
    }

    @Override
    public void registerRecipeVisibilityHandler(DisplayVisibilityHandler visibilityHandler) {
        this.displayVisibilityHandlers.add(visibilityHandler);
    }

    @Override
    public void unregisterRecipeVisibilityHandler(DisplayVisibilityHandler visibilityHandler) {
        this.displayVisibilityHandlers.remove(visibilityHandler);
    }

    @Override
    public List<DisplayVisibilityHandler> getDisplayVisibilityHandlers() {
        return Collections.unmodifiableList(this.displayVisibilityHandlers);
    }

    @Override
    public boolean isDisplayNotVisible(RecipeDisplay display) {
        return !this.isDisplayVisible(display);
    }

    @Override
    public boolean isDisplayVisible(RecipeDisplay display) {
        RecipeCategory<?> category = this.getCategory(display.getRecipeCategory());
        try {
            for (DisplayVisibilityHandler displayVisibilityHandler : this.displayVisibilityHandlers) {
                class_1269 visibility = displayVisibilityHandler.handleDisplay(category, display);
                if (visibility == class_1269.field_5811) continue;
                return visibility == class_1269.field_5812;
            }
        }
        catch (Throwable throwable) {
            RoughlyEnoughItemsCore.LOGGER.error("Failed to check if the recipe is visible!", throwable);
        }
        return true;
    }

    @Override
    public void registerScreenClickArea(Rectangle rectangle, Class<? extends class_465<?>> screenClass, class_2960 ... categories) {
        this.screenClickAreas.add(new ScreenClickAreaImpl(screenClass, rectangle, categories));
    }

    @Override
    public <T extends class_1860<?>> void registerRecipes(class_2960 category, Class<T> recipeClass, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipe -> recipeClass.isAssignableFrom(recipe.getClass()), mappingFunction));
    }

    @Override
    public <T extends class_1860<?>> void registerRecipes(class_2960 category, Function<class_1860, Boolean> recipeFilter, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipeFilter::apply, mappingFunction));
    }

    @Override
    public <T extends class_1860<?>> void registerRecipes(class_2960 category, Predicate<class_1860> recipeFilter, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipeFilter, mappingFunction));
    }

    @Override
    public void registerLiveRecipeGenerator(LiveRecipeGenerator<?> liveRecipeGenerator) {
        this.liveRecipeGenerators.add(liveRecipeGenerator);
    }

    @Override
    public List<RecipeHelper.ScreenClickArea> getScreenClickAreas() {
        return this.screenClickAreas;
    }

    static {
        RECIPE_COMPARATOR = Comparator.comparing(o -> o.method_8114().method_12836()).thenComparing(o -> o.method_8114().method_12832());
        Comparator<DisplayVisibilityHandler> comparator = Comparator.comparingDouble(DisplayVisibilityHandler::getPriority);
        VISIBILITY_HANDLER_COMPARATOR = comparator.reversed();
    }

    private static class RecipeFunction {
        class_2960 category;
        Predicate<class_1860> recipeFilter;
        Function mappingFunction;

        public RecipeFunction(class_2960 category, Predicate<class_1860> recipeFilter, Function<?, RecipeDisplay> mappingFunction) {
            this.category = category;
            this.recipeFilter = recipeFilter;
            this.mappingFunction = mappingFunction;
        }
    }

    private static class ScreenClickAreaImpl
    implements RecipeHelper.ScreenClickArea {
        Class<? extends class_465<?>> screenClass;
        Rectangle rectangle;
        class_2960[] categories;

        private ScreenClickAreaImpl(Class<? extends class_465<?>> screenClass, Rectangle rectangle, class_2960[] categories) {
            this.screenClass = screenClass;
            this.rectangle = rectangle;
            this.categories = categories;
        }

        public Class<? extends class_465<?>> getScreenClass() {
            return this.screenClass;
        }

        @Override
        public Rectangle getRectangle() {
            return this.rectangle;
        }

        @Override
        public class_2960[] getCategories() {
            return this.categories;
        }
    }
}

