/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import me.shedaniel.cloth.api.client.events.v0.ClothClientHooks;
import me.shedaniel.math.Point;
import me.shedaniel.math.api.Executor;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.OverlaySearchField;
import me.shedaniel.rei.gui.RecipeScreen;
import me.shedaniel.rei.gui.WarningAndErrorScreen;
import me.shedaniel.rei.gui.widget.TextFieldWidget;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.event.client.ClientTickCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ScreenHelper
implements ClientModInitializer,
REIHelper {
    private OverlaySearchField searchField;
    @ApiStatus.Internal
    public static List<class_1799> inventoryStacks = Lists.newArrayList();
    private static ContainerScreenOverlay overlay;
    private static class_465<?> previousContainerScreen;
    private static LinkedHashSet<RecipeScreen> lastRecipeScreen;
    private static ScreenHelper instance;

    @ApiStatus.Internal
    public static ScreenHelper getInstance() {
        return instance;
    }

    @Override
    public void queueTooltip(@Nullable Tooltip tooltip) {
        if (overlay != null && tooltip != null) {
            overlay.addTooltip(tooltip);
        }
    }

    @Override
    public TextFieldWidget getSearchTextField() {
        return this.searchField;
    }

    @Override
    public List<class_1799> getInventoryStacks() {
        return inventoryStacks;
    }

    public static OverlaySearchField getSearchField() {
        return (OverlaySearchField)ScreenHelper.getInstance().getSearchTextField();
    }

    @ApiStatus.Internal
    public static void setSearchField(OverlaySearchField searchField) {
        ScreenHelper.getInstance().searchField = searchField;
    }

    public static void storeRecipeScreen(RecipeScreen screen) {
        while (lastRecipeScreen.size() >= 5) {
            lastRecipeScreen.remove(Iterables.get(lastRecipeScreen, (int)0));
        }
        lastRecipeScreen.add(screen);
    }

    public static boolean hasLastRecipeScreen() {
        return !lastRecipeScreen.isEmpty();
    }

    public static class_437 getLastRecipeScreen() {
        RecipeScreen screen = (RecipeScreen)Iterables.getLast(lastRecipeScreen);
        lastRecipeScreen.remove(screen);
        screen.recalculateCategoryPage();
        return (class_437)screen;
    }

    @ApiStatus.Internal
    public static void clearLastRecipeScreenData() {
        lastRecipeScreen.clear();
    }

    public static boolean isOverlayVisible() {
        return ConfigObject.getInstance().isOverlayVisible();
    }

    public static void toggleOverlayVisible() {
        ConfigObject.getInstance().setOverlayVisible(!ConfigObject.getInstance().isOverlayVisible());
        ConfigManager.getInstance().saveConfig();
    }

    public static Optional<ContainerScreenOverlay> getOptionalOverlay() {
        return Optional.ofNullable(overlay);
    }

    public static ContainerScreenOverlay getLastOverlay(boolean reset, boolean setPage) {
        if (overlay == null || reset) {
            overlay = new ContainerScreenOverlay();
            overlay.init();
            ScreenHelper.getSearchField().setFocused(false);
        }
        return overlay;
    }

    public static ContainerScreenOverlay getLastOverlay() {
        return ScreenHelper.getLastOverlay(false, false);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static class_465<?> getLastHandledScreen() {
        return previousContainerScreen;
    }

    @Override
    public class_465<?> getPreviousContainerScreen() {
        return previousContainerScreen;
    }

    public static void setPreviousContainerScreen(class_465<?> previousContainerScreen) {
        ScreenHelper.previousContainerScreen = previousContainerScreen;
    }

    public static void drawHoveringWidget(class_4587 matrices, int x, int y, TriConsumer<class_4587, Point, Float> consumer, int width, int height, float delta) {
        class_1041 window = class_310.method_1551().method_22683();
        ScreenHelper.drawHoveringWidget(matrices, window.method_4486(), window.method_4502(), x, y, consumer, width, height, delta);
    }

    public static void drawHoveringWidget(class_4587 matrices, int screenWidth, int screenHeight, int x, int y, TriConsumer<class_4587, Point, Float> consumer, int width, int height, float delta) {
        int actualX = Math.max(x + 12, 6);
        int actualY = Math.min(y - height / 2, screenHeight - height - 6);
        if (actualX + width > screenWidth) {
            actualX -= 24 + width;
        }
        if (actualY < 6) {
            actualY += 24;
        }
        consumer.accept((Object)matrices, (Object)new Point(actualX, actualY), (Object)Float.valueOf(delta));
    }

    @Deprecated
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    public static boolean isDarkModeEnabled() {
        return ConfigObject.getInstance().isUsingDarkTheme();
    }

    @Override
    public boolean isDarkThemeEnabled() {
        return ScreenHelper.isDarkModeEnabled();
    }

    public ScreenHelper() {
        instance = this;
    }

    public void onInitializeClient() {
        ClothClientHooks.SCREEN_INIT_PRE.register((client, screen, screenHooks) -> {
            if (!(RoughlyEnoughItemsState.getErrors().isEmpty() && RoughlyEnoughItemsState.getWarnings().isEmpty() || screen instanceof WarningAndErrorScreen)) {
                WarningAndErrorScreen warningAndErrorScreen = (WarningAndErrorScreen)((Object)((Object)WarningAndErrorScreen.INSTANCE.method_15332()));
                warningAndErrorScreen.setParent(screen);
                try {
                    if (client.field_1755 != null) {
                        client.field_1755.method_25432();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                client.field_1755 = null;
                client.method_1507((class_437)warningAndErrorScreen);
            } else if (previousContainerScreen != screen && screen instanceof class_465) {
                previousContainerScreen = (class_465)screen;
            }
            return class_1269.field_5811;
        });
        boolean loaded = FabricLoader.getInstance().isModLoaded("fabric-events-lifecycle-v0");
        if (!loaded) {
            RoughlyEnoughItemsState.error("Fabric API is not installed!", "https://www.curseforge.com/minecraft/mc-mods/fabric-api/files/all");
            return;
        }
        Executor.run(() -> () -> ClientTickCallback.EVENT.register(minecraftClient -> {
            if (ScreenHelper.isOverlayVisible() && ScreenHelper.getSearchField() != null) {
                ScreenHelper.getSearchField().method_16896();
            }
        }));
    }

    static {
        previousContainerScreen = null;
        lastRecipeScreen = Sets.newLinkedHashSetWithExpectedSize((int)5);
    }
}

