/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.impl.search.AlwaysMatchingArgument;
import me.shedaniel.rei.impl.search.Argument;
import me.shedaniel.rei.impl.search.ArgumentsRegistry;
import me.shedaniel.rei.impl.search.MatchStatus;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SearchArgument {
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    private static final SearchArgument ALWAYS = new SearchArgument(AlwaysMatchingArgument.INSTANCE, "", true);
    private Argument argument;
    private String text;
    private Object data;
    private boolean regular;
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?:\"([^\"]*)\")|([^\\s]+)");

    public SearchArgument(Argument argument, String text, boolean regular) {
        this(argument, text, regular, true);
    }

    public SearchArgument(Argument argument, String text, boolean regular, boolean lowercase) {
        this.argument = argument;
        this.text = lowercase ? text.toLowerCase(Locale.ROOT) : text;
        this.regular = regular;
        this.data = null;
    }

    @ApiStatus.Internal
    public static List<SearchArguments> processSearchTerm(String searchTerm) {
        ArrayList searchArguments = Lists.newArrayList();
        for (String split : StringUtils.splitByWholeSeparatorPreserveAllTokens((String)searchTerm, (String)"|")) {
            Matcher terms = SPLIT_PATTERN.matcher(split);
            ArrayList arguments = Lists.newArrayList();
            block1: while (terms.find()) {
                String term = (String)MoreObjects.firstNonNull((Object)terms.group(1), (Object)terms.group(2));
                for (Argument argument : ArgumentsRegistry.ARGUMENTS) {
                    MatchStatus status = argument.matchesArgumentPrefix(term);
                    if (!status.isMatched()) continue;
                    arguments.add(new SearchArgument(argument, status.getText(), !status.isInverted(), !status.shouldPreserveCasing()));
                    continue block1;
                }
            }
            if (arguments.isEmpty()) {
                searchArguments.add(SearchArguments.ALWAYS);
                continue;
            }
            searchArguments.add(new SearchArguments(arguments.toArray(new SearchArgument[0])));
        }
        for (SearchArguments arguments : searchArguments) {
            for (SearchArgument argument : arguments.getArguments()) {
                argument.data = argument.argument.prepareSearchData(argument.getText());
            }
        }
        return searchArguments;
    }

    @ApiStatus.Internal
    public static boolean canSearchTermsBeAppliedTo(EntryStack stack, List<SearchArguments> searchArguments) {
        if (searchArguments.isEmpty()) {
            return true;
        }
        class_310 minecraft = class_310.method_1551();
        Object[] data = new Object[ArgumentsRegistry.ARGUMENTS.size()];
        for (SearchArguments arguments : searchArguments) {
            boolean applicable = true;
            for (SearchArgument argument : arguments.getArguments()) {
                if (argument.getArgument().matches(data, stack, argument.getText(), argument.data) == argument.isRegular()) continue;
                applicable = false;
                break;
            }
            if (!applicable) continue;
            return true;
        }
        return false;
    }

    public static String tryGetEntryStackTooltip(EntryStack stack) {
        Tooltip tooltip = stack.getTooltip(new Point());
        if (tooltip != null) {
            return CollectionUtils.mapAndJoinToString(tooltip.getText(), class_2561::getString, "\n");
        }
        return EMPTY;
    }

    public Argument getArgument() {
        return this.argument;
    }

    public String getText() {
        return this.text;
    }

    public boolean isRegular() {
        return this.regular;
    }

    public String toString() {
        return String.format("Argument[%s]: name = %s, regular = %b", this.argument.getName(), this.text, this.regular);
    }

    static /* synthetic */ SearchArgument access$000() {
        return ALWAYS;
    }

    public static class SearchArguments {
        public static final SearchArguments ALWAYS = new SearchArguments(new SearchArgument[]{SearchArgument.access$000()});
        private SearchArgument[] arguments;

        public SearchArguments(SearchArgument[] arguments) {
            this.arguments = arguments;
        }

        public SearchArgument[] getArguments() {
            return this.arguments;
        }
    }
}

