/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.search;

import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.impl.search.ArgumentsRegistry;
import me.shedaniel.rei.impl.search.MatchStatus;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class Argument {
    private int dataOrdinal = -1;

    public abstract String getName();

    @Nullable
    public String getPrefix() {
        return null;
    }

    public MatchStatus matchesArgumentPrefix(String text) {
        String prefix = this.getPrefix();
        if (prefix == null) {
            return MatchStatus.unmatched();
        }
        if (text.startsWith("-" + prefix)) {
            return MatchStatus.invertMatched(text.substring(1 + prefix.length()));
        }
        if (text.startsWith(prefix + "-")) {
            return MatchStatus.invertMatched(text.substring(1 + prefix.length()));
        }
        return text.startsWith(prefix) ? MatchStatus.matched(text.substring(prefix.length())) : MatchStatus.unmatched();
    }

    public final int getDataOrdinal() {
        if (this.dataOrdinal == -1) {
            this.dataOrdinal = ArgumentsRegistry.ARGUMENTS.indexOf(this);
        }
        return this.dataOrdinal;
    }

    public abstract boolean matches(Object[] var1, EntryStack var2, String var3, Object var4);

    public Object prepareSearchData(String searchText) {
        return null;
    }
}

