/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.gui.toast.ExportRecipeIdentifierToast;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_276;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@ApiStatus.Internal
@ApiStatus.Experimental
public final class RecipeDisplayExporter extends Widget {
    private static final RecipeDisplayExporter INSTANCE = new RecipeDisplayExporter();
    
    private RecipeDisplayExporter() {}
    
    public static void exportRecipeDisplay(Rectangle rectangle, List<Widget> widgets) {
        INSTANCE.exportRecipe(rectangle, widgets);
        ExportRecipeIdentifierToast.addToast(class_1074.method_4662("msg.rei.exported_recipe"), class_1074.method_4662("msg.rei.exported_recipe.desc"));
    }
    
    private static File getExportFilename(File directory) {
        String string = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        int i = 1;
        
        while (true) {
            File file = new File(directory, string + (i == 1 ? "" : "_" + i) + ".png");
            if (!file.exists()) {
                return file;
            }
            
            ++i;
        }
    }
    
    @SuppressWarnings("deprecation")
    private void exportRecipe(Rectangle rectangle, List<Widget> widgets) {
        RenderSystem.pushMatrix();
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        class_276 framebuffer = new class_276(window.method_4489(), window.method_4506(), true, false);
        framebuffer.method_1235(true);
        RenderSystem.viewport(0, 0, window.method_4489(), window.method_4506());
        RenderSystem.clear(256, class_310.field_1703);
        RenderSystem.matrixMode(5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho(0.0D, (double) window.method_4489() / window.method_4495(), (double) window.method_4506() / window.method_4495(), 0.0D, 1000.0D, 3000.0D);
        RenderSystem.matrixMode(5888);
        RenderSystem.loadIdentity();
        RenderSystem.translatef(0.0F, 0.0F, -2000.0F);
        class_308.method_24211();
        class_4587 matrices = new class_4587();
        for (Widget widget : widgets) {
            widget.method_25394(matrices, -1, -1, 0);
        }
        RenderSystem.popMatrix();
        
        class_1011 nativeImage = new class_1011(framebuffer.field_1482, framebuffer.field_1481, false);
        RenderSystem.bindTexture(framebuffer.field_1475);
        nativeImage.method_4327(0, false);
        nativeImage.method_4319();
        int outWidth = (int) (rectangle.width * window.method_4495());
        int outHeight = (int) (rectangle.height * window.method_4495());
        class_1011 strippedImage = new class_1011(outWidth, outHeight, false);
        for (int y = 0; y < outHeight; ++y) {
            for (int x = 0; x < outWidth; ++x) {
                strippedImage.method_4305(x, y, nativeImage.method_4315(x + (int) (rectangle.x * window.method_4495()), y + (int) (rectangle.y * window.method_4495())));
            }
        }
        class_156.method_27958().execute(() -> {
            try {
                File export = new File(minecraft.field_1697, "rei_exports");
                export.mkdirs();
                strippedImage.method_4325(getExportFilename(export));
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                nativeImage.close();
                strippedImage.close();
                RenderSystem.recordRenderCall(framebuffer::method_1238);
            }
        });
    }
    
    @Override
    public void method_25394(class_4587 matrixStack, int mouseY, int i, float f) {
        
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        return null;
    }
}
