/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui.config.entry;

import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.rei.impl.filtering.FilteringRule;
import me.shedaniel.rei.impl.filtering.rules.ManualFilteringRule;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

public class FilteringAddRuleScreen extends class_437 {
    private final FilteringEntry entry;
    private RulesList rulesList;
    class_437 parent;
    
    public FilteringAddRuleScreen(FilteringEntry entry) {
        super(new class_2588("config.roughlyenoughitems.filteringRulesScreen.new"));
        this.entry = entry;
    }
    
    @Override
    protected void method_25426() {
        super.method_25426();
        {
            class_2561 backText = new class_2585("↩ ").method_10852(new class_2588("gui.back"));
            method_25411(new class_4185(4, 4, class_310.method_1551().field_1772.method_27525(backText) + 10, 20, backText, button -> {
                field_22787.method_1507(parent);
                this.parent = null;
            }));
        }
        rulesList = method_25429(new RulesList(field_22787, field_22789, field_22790, 30, field_22790, field_22735));
        for (FilteringRule<?> rule : FilteringRule.REGISTRY) {
            if (!(rule instanceof ManualFilteringRule))
                rulesList.addItem(new DefaultRuleEntry(parent, entry, rule.createNew(), null));
        }
        rulesList.selectItem(rulesList.method_25396().get(0));
    }
    
    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.rulesList.method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.field_22793.method_27517(matrices, this.field_22785, this.field_22789 / 2.0F - this.field_22793.method_27525(this.field_22785) / 2.0F, 12.0F, -1);
    }
    
    public static class RulesList extends DynamicElementListWidget<RuleEntry> {
        private boolean inFocus;
        
        public RulesList(class_310 client, int width, int height, int top, int bottom, class_2960 backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
        }
        
        @Override
        public boolean method_25407(boolean lookForwards) {
            if (!this.inFocus && this.getItemCount() == 0) {
                return false;
            } else {
                this.inFocus = !this.inFocus;
                if (this.inFocus && this.getSelectedItem() == null && this.getItemCount() > 0) {
                    this.moveSelection(1);
                } else if (this.inFocus && this.getSelectedItem() != null) {
                    this.getSelectedItem();
                }
                
                return this.inFocus;
            }
        }
        
        @Override
        protected boolean isSelected(int index) {
            return Objects.equals(this.getSelectedItem(), this.method_25396().get(index));
        }
        
        @Override
        protected int addItem(RuleEntry item) {
            return super.addItem(item);
        }
        
        @Override
        public int getItemWidth() {
            return width - 40;
        }
        
        @Override
        protected int getScrollbarPosition() {
            return width - 14;
        }
    }
    
    public static abstract class RuleEntry extends DynamicElementListWidget.ElementEntry<RuleEntry> {
        private final FilteringRule<?> rule;
        
        public RuleEntry(FilteringRule<?> rule) {
            this.rule = rule;
        }
        
        public FilteringRule<?> getRule() {
            return rule;
        }
        
        @Override
        public int getItemHeight() {
            return 26;
        }
        
        @Override
        public boolean method_25407(boolean lookForwards) {
            return false;
        }
    }
    
    public static class DefaultRuleEntry extends RuleEntry {
        private final class_4185 addButton;
        private final BiFunction<FilteringEntry, class_437, class_437> screenFunction;
        
        public DefaultRuleEntry(class_437 parent, FilteringEntry entry, FilteringRule<?> rule, BiFunction<FilteringEntry, class_437, class_437> screenFunction) {
            super(rule);
            this.screenFunction = (screenFunction == null ? rule.createEntryScreen().orElse(null) : screenFunction);
            addButton = new class_4185(0, 0, 20, 20, class_2561.method_30163(" + "), button -> {
                entry.edited = true;
                class_310.method_1551().method_1507(this.screenFunction.apply(entry, parent));
                entry.rules.add(0, rule);
            });
            addButton.field_22763 = this.screenFunction != null;
        }
        
        @Override
        public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            class_310 client = class_310.method_1551();
            {
                class_2561 title = getRule().getTitle();
                int i = client.field_1772.method_27525(title);
                if (i > entryWidth - 28) {
                    class_5348 titleTrimmed = class_5348.method_29433(client.field_1772.method_1714(title, entryWidth - 28 - client.field_1772.method_1727("...")), class_5348.method_29430("..."));
                    client.field_1772.method_27517(matrices, titleTrimmed, x + 2, y + 1, 16777215);
                } else {
                    client.field_1772.method_27517(matrices, title, x + 2, y + 1, 16777215);
                }
            }
            {
                class_2561 subtitle = getRule().getSubtitle();
                int i = client.field_1772.method_27525(subtitle);
                if (i > entryWidth - 28) {
                    class_5348 subtitleTrimmed = class_5348.method_29433(client.field_1772.method_1714(subtitle, entryWidth - 28 - client.field_1772.method_1727("...")), class_5348.method_29430("..."));
                    client.field_1772.method_27517(matrices, subtitleTrimmed, x + 2, y + 12, 8421504);
                } else {
                    client.field_1772.method_27517(matrices, subtitle, x + 2, y + 12, 8421504);
                }
            }
            addButton.field_22760 = x + entryWidth - 25;
            addButton.field_22761 = y + 1;
            addButton.method_25394(matrices, mouseX, mouseY, delta);
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(addButton);
        }
    }
}
