/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui.config.entry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.impl.filtering.FilteringRule;
import net.minecraft.class_1041;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;

import java.util.*;
import java.util.function.Consumer;

@ApiStatus.Internal
public class FilteringEntry extends AbstractConfigListEntry<List<EntryStack>> {
    private int width;
    Consumer<List<EntryStack>> saveConsumer;
    Consumer<List<FilteringRule<?>>> rulesSaveConsumer;
    List<EntryStack> defaultValue;
    Set<EntryStack> configFiltered;
    List<FilteringRule<?>> rules;
    boolean edited = false;
    final FilteringScreen filteringScreen = new FilteringScreen(this);
    final FilteringRulesScreen filteringRulesScreen = new FilteringRulesScreen(this);
    private final class_339 buttonWidget = new class_4185(0, 0, 0, 20, new class_2588("config.roughlyenoughitems.filteringScreen"), button -> {
        filteringRulesScreen.parent = class_310.method_1551().field_1755;
        class_310.method_1551().method_1507(filteringRulesScreen);
    });
    private final List<class_364> children = ImmutableList.of(buttonWidget);
    
    public FilteringEntry(int width, List<EntryStack> configFiltered, List<FilteringRule<?>> rules, List<EntryStack> defaultValue, Consumer<List<EntryStack>> saveConsumer, Consumer<List<FilteringRule<?>>> rulesSaveConsumer) {
        super(class_333.field_18967, false);
        this.width = width;
        this.configFiltered = new TreeSet<>(Comparator.comparing(EntryStack::hashIgnoreAmount));
        this.configFiltered.addAll(configFiltered);
        this.rules = Lists.newArrayList(rules);
        this.defaultValue = defaultValue;
        this.saveConsumer = saveConsumer;
        this.rulesSaveConsumer = rulesSaveConsumer;
    }
    
    @Override
    public List<EntryStack> getValue() {
        return Lists.newArrayList(configFiltered);
    }
    
    @Override
    public Optional<List<EntryStack>> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }
    
    @Override
    public void save() {
        saveConsumer.accept(getValue());
        rulesSaveConsumer.accept(rules);
        this.edited = false;
    }
    
    @Override
    public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        class_1041 window = class_310.method_1551().method_22683();
        this.buttonWidget.field_22763 = this.isEditable();
        this.buttonWidget.field_22761 = y;
        this.buttonWidget.field_22760 = x + entryWidth / 2 - width / 2;
        this.buttonWidget.method_25358(width);
        this.buttonWidget.method_25394(matrices, mouseX, mouseY, delta);
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        return children;
    }
    
    @Override
    public boolean isEdited() {
        return super.isEdited() || edited;
    }
}
