/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.gui.config.entry;

import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.rei.impl.filtering.FilteringRule;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class FilteringRuleOptionsScreen<T extends FilteringRule<?>> extends class_437 {
    private final FilteringEntry entry;
    private RulesList rulesList;
    class_437 parent;
    public T rule;
    
    public FilteringRuleOptionsScreen(FilteringEntry entry, T rule, class_437 screen) {
        super(new class_2588("config.roughlyenoughitems.filteringRulesScreen"));
        this.entry = entry;
        this.rule = rule;
        this.parent = screen;
    }
    
    @Override
    protected void method_25426() {
        super.method_25426();
        if (rulesList != null) save();
        {
            class_2561 doneText = new class_2588("gui.done");
            int width = class_310.method_1551().field_1772.method_27525(doneText);
            method_25411(new class_4185(this.field_22789 - 4 - width - 10, 4, width + 10, 20, doneText, button -> {
                save();
                field_22787.method_1507(parent);
            }));
        }
        rulesList = method_25429(new RulesList(field_22787, field_22789, field_22790, 30, field_22790, field_22735));
        addEntries(ruleEntry -> rulesList.addItem(ruleEntry));
    }
    
    public abstract void addEntries(Consumer<RuleEntry> entryConsumer);
    
    public abstract void save();
    
    public void addText(Consumer<RuleEntry> entryConsumer, class_5348 text) {
        for (class_5348 s : field_22793.method_1728(text, field_22789 - 80)) {
            entryConsumer.accept(new TextRuleEntry(rule, s));
        }
    }
    
    public void addEmpty(Consumer<RuleEntry> entryConsumer, int height) {
        entryConsumer.accept(new EmptyRuleEntry(rule, height));
    }
    
    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.rulesList.method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.field_22793.method_27517(matrices, this.field_22785, this.field_22789 / 2.0F - this.field_22793.method_27525(this.field_22785) / 2.0F, 12.0F, -1);
    }
    
    public static class RulesList extends DynamicElementListWidget<RuleEntry> {
        public RulesList(class_310 client, int width, int height, int top, int bottom, class_2960 backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
        }
        
        @Override
        protected int addItem(RuleEntry item) {
            return super.addItem(item);
        }
        
        @Override
        public int getItemWidth() {
            return width - 40;
        }
        
        @Override
        protected int getScrollbarPosition() {
            return width - 14;
        }
    }
    
    public static abstract class RuleEntry extends DynamicElementListWidget.ElementEntry<RuleEntry> {
        private final FilteringRule<?> rule;
        
        public RuleEntry(FilteringRule<?> rule) {
            this.rule = rule;
        }
        
        public FilteringRule<?> getRule() {
            return rule;
        }
    }
    
    public static class TextRuleEntry extends RuleEntry {
        private final class_5348 text;
        
        public TextRuleEntry(FilteringRule<?> rule, class_5348 text) {
            super(rule);
            this.text = text;
        }
        
        @Override
        public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            class_310.method_1551().field_1772.method_27517(matrices, text, x + 5, y, -1);
        }
        
        @Override
        public int getItemHeight() {
            return 12;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
    }
    
    public static class EmptyRuleEntry extends RuleEntry {
        private final int height;
        
        public EmptyRuleEntry(FilteringRule<?> rule, int height) {
            super(rule);
            this.height = height;
        }
        
        @Override
        public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        }
        
        @Override
        public int getItemHeight() {
            return height;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
    }
    
    public static class TextFieldRuleEntry extends RuleEntry {
        private final class_342 widget;
        
        public TextFieldRuleEntry(int width, FilteringRule<?> rule, Consumer<class_342> widgetConsumer) {
            super(rule);
            this.widget = new class_342(class_310.method_1551().field_1772, 0, 0, width, 18, class_2561.method_30163(""));
            widgetConsumer.accept(widget);
        }
        
        @Override
        public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            widget.field_22760 = x + 2;
            widget.field_22761 = y + 2;
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
        
        @Override
        public int getItemHeight() {
            return 20;
        }
        
        public class_342 getWidget() {
            return widget;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(widget);
        }
    }
    
    public static class BooleanRuleEntry extends RuleEntry {
        private boolean b;
        private final class_4185 widget;
        
        public BooleanRuleEntry(int width, boolean b, FilteringRule<?> rule, Function<Boolean, class_2561> textFunction) {
            super(rule);
            this.b = b;
            this.widget = new class_4185(0, 0, 100, 20, textFunction.apply(b), button -> {
                this.b = !this.b;
                button.method_25355(textFunction.apply(this.b));
            });
        }
        
        public boolean getBoolean() {
            return b;
        }
        
        @Override
        public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            widget.field_22760 = x + 2;
            widget.field_22761 = y;
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
        
        @Override
        public int getItemHeight() {
            return 20;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(widget);
        }
    }
}
