/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.utils.CollectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public interface EntryRegistry {
    @NotNull
    public static EntryRegistry getInstance() {
        return RoughlyEnoughItemsCore.getEntryRegistry();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    default public List<EntryStack> getStacksList() {
        return this.getEntryStacks().collect(Collectors.toList());
    }

    @NotNull
    public Stream<EntryStack> getEntryStacks();

    @NotNull
    public List<EntryStack> getPreFilteredList();

    @NotNull
    public List<class_1799> appendStacksForItem(@NotNull class_1792 var1);

    @NotNull
    public class_1799[] getAllStacksFromItem(@NotNull class_1792 var1);

    default public void registerEntry(@NotNull EntryStack stack) {
        this.registerEntryAfter(null, stack);
    }

    default public void registerEntryAfter(@Nullable EntryStack afterEntry, @NotNull EntryStack stack) {
        this.registerEntriesAfter(afterEntry, Collections.singletonList(stack));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    default public void registerEntryAfter(@Nullable EntryStack afterEntry, @NotNull EntryStack stack, boolean checkAlreadyContains) {
        this.registerEntryAfter(afterEntry, stack);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    default public void queueRegisterEntryAfter(@Nullable EntryStack afterEntry, @NotNull @NotNull Collection<@NotNull ? extends EntryStack> stacks) {
        this.registerEntriesAfter(afterEntry, stacks);
    }

    default public void registerEntriesAfter(@Nullable EntryStack afterStack, EntryStack ... stacks) {
        this.registerEntriesAfter(afterStack, Arrays.asList(stacks));
    }

    public void registerEntriesAfter(@Nullable EntryStack var1, @NotNull @NotNull Collection<@NotNull ? extends EntryStack> var2);

    default public void registerEntries(EntryStack ... stacks) {
        this.registerEntriesAfter(null, stacks);
    }

    default public boolean alreadyContain(EntryStack stack) {
        return CollectionUtils.anyMatchEqualsAll(this.getStacksList(), stack);
    }
}

