/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.gui.config.EntryPanelOrdering;
import me.shedaniel.rei.gui.widget.EntryListEntryWidget;
import me.shedaniel.rei.gui.widget.EntryListWidget;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FavoritesListWidget
extends WidgetWithBounds {
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return FavoritesListWidget.this.bounds;
        }

        public int getMaxScrollHeight() {
            return class_3532.method_15386((float)((float)(FavoritesListWidget.this.favorites.size() + FavoritesListWidget.this.blockedCount) / ((float)((FavoritesListWidget)FavoritesListWidget.this).innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
        }

        public int getScrollBarX() {
            if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
                return ((FavoritesListWidget)FavoritesListWidget.this).bounds.x + 1;
            }
            return FavoritesListWidget.this.bounds.getMaxX() - 7;
        }
    };
    protected int blockedCount;
    List<EntryStack> favorites = null;
    private Rectangle bounds;
    private Rectangle innerBounds;
    private List<EntryListEntry> entries = Collections.emptyList();
    private boolean draggingScrollBar = false;

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / (float)EntryListWidget.entrySize())), 1);
        if (!ConfigObject.getInstance().isLeftHandSidePanel()) {
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f) + 3.0f), bounds.y, width * EntryListWidget.entrySize(), bounds.height);
        }
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)EntryListWidget.entrySize() / 2.0f) - 3.0f), bounds.y, width * EntryListWidget.entrySize(), bounds.height);
    }

    public boolean method_25401(double double_1, double double_2, double double_3) {
        if (this.bounds.contains(double_1, double_2)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            return true;
        }
        return super.method_25401(double_1, double_2, double_3);
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        EntryStack stack;
        int nextIndex;
        if (this.bounds.isEmpty()) {
            return;
        }
        for (EntryListEntry entry : this.entries) {
            entry.clearStacks();
        }
        ScissorsHandler.INSTANCE.scissor(this.bounds);
        int skip = Math.max(0, class_3532.method_15357((double)(this.scrolling.scrollAmount / (double)EntryListWidget.entrySize())));
        this.blockedCount = 0;
        block1: for (int i = nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize(); i < this.favorites.size(); ++i) {
            stack = this.favorites.get(i);
            while (true) {
                EntryListEntry entry = this.entries.get(nextIndex);
                entry.getBounds().y = (int)((double)entry.backupY - this.scrolling.scrollAmount);
                if (entry.getBounds().y > this.bounds.getMaxY()) break block1;
                if (EntryListWidget.notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, this.innerBounds)) {
                    entry.entry(stack);
                    entry.method_25394(matrices, mouseX, mouseY, delta);
                    ++nextIndex;
                    continue block1;
                }
                ++this.blockedCount;
                ++nextIndex;
            }
        }
        this.updatePosition(delta);
        this.scrolling.renderScrollBar(0, 1.0f, REIHelper.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        ScissorsHandler.INSTANCE.removeLastScissor();
        if (this.containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating() && !this.minecraft.field_1724.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.canDeleteItems()) {
            class_1792 bucketItem;
            stack = EntryStack.create(this.minecraft.field_1724.field_7514.method_7399().method_7972());
            if (stack.getType() == EntryStack.Type.FLUID && (bucketItem = stack.getFluid().method_15774()) != null) {
                stack = EntryStack.create((class_1935)bucketItem);
            }
            for (Widget widget : this.method_25396()) {
                if (!widget.containsMouse(mouseX, mouseY) || !(widget instanceof EntryWidget) || !((EntryWidget)widget).cancelDeleteItems(stack)) continue;
                return;
            }
            Tooltip.create(new class_2561[]{new class_2588("text.rei.delete_items")}).queue();
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, int_1, double_3, double_4, ConfigObject.getInstance().doesSnapToRows(), (double)EntryListWidget.entrySize())) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, int_1, double_3, double_4);
    }

    private void updatePosition(float delta) {
        if (ConfigObject.getInstance().doesSnapToRows() && this.scrolling.scrollTarget >= 0.0 && this.scrolling.scrollTarget <= (double)this.scrolling.getMaxScroll()) {
            double nearestRow = (double)Math.round(this.scrolling.scrollTarget / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
            this.scrolling.scrollTarget = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.scrolling.scrollTarget, (double)nearestRow, (double)0.001f) ? (this.scrolling.scrollTarget += (nearestRow - this.scrolling.scrollTarget) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        this.scrolling.updatePosition(delta);
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (this.containsMouse(PointHelper.ofMouse())) {
            for (Widget widget : this.method_25396()) {
                if (!widget.method_25404(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateFavoritesBounds(@Nullable String searchTerm) {
        this.bounds = ScreenHelper.getFavoritesListArea(DisplayHelper.getInstance().getOverlayBounds(ConfigObject.getInstance().getDisplayPanelLocation().mirror(), class_310.method_1551().field_1755));
    }

    public void updateSearch(EntryListWidget listWidget, String searchTerm) {
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            if (ConfigObject.getInstance().doSearchFavorites()) {
                HashSet workingItems;
                ArrayList list = Lists.newArrayList();
                boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
                HashSet hashSet = workingItems = checkCraftable ? Sets.newHashSet() : null;
                if (checkCraftable) {
                    workingItems.addAll(CollectionUtils.map(RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)), EntryStack::hashIgnoreAmount));
                }
                for (EntryStack stack : ConfigObject.getInstance().getFavorites()) {
                    if (!listWidget.canLastSearchTermsBeAppliedTo(stack) || checkCraftable && !workingItems.contains(stack.hashIgnoreAmount())) continue;
                    list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, EntryListWidget.RENDER_ENCHANTMENT_GLINT));
                }
                EntryPanelOrdering ordering = ConfigObject.getInstance().getItemListOrdering();
                if (ordering == EntryPanelOrdering.NAME) {
                    list.sort(EntryListWidget.ENTRY_NAME_COMPARER);
                }
                if (ordering == EntryPanelOrdering.GROUPS) {
                    list.sort(EntryListWidget.ENTRY_GROUP_COMPARER);
                }
                if (!ConfigObject.getInstance().isItemListAscending()) {
                    Collections.reverse(list);
                }
                this.favorites = list;
            } else {
                HashSet workingItems;
                ArrayList list = Lists.newArrayList();
                boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
                HashSet hashSet = workingItems = checkCraftable ? Sets.newHashSet() : null;
                if (checkCraftable) {
                    workingItems.addAll(CollectionUtils.map(RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)), EntryStack::hashIgnoreAmount));
                }
                for (EntryStack stack : ConfigObject.getInstance().getFavorites()) {
                    if (checkCraftable && !workingItems.contains(stack.hashIgnoreAmount())) continue;
                    list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, EntryListWidget.RENDER_ENCHANTMENT_GLINT));
                }
                Object ordering = ConfigObject.getInstance().getItemListOrdering();
                if (ordering == EntryPanelOrdering.NAME) {
                    list.sort(EntryListWidget.ENTRY_NAME_COMPARER);
                }
                if (ordering == EntryPanelOrdering.GROUPS) {
                    list.sort(EntryListWidget.ENTRY_GROUP_COMPARER);
                }
                if (!ConfigObject.getInstance().isItemListAscending()) {
                    Collections.reverse(list);
                }
                this.favorites = list;
            }
        } else {
            this.favorites = Collections.emptyList();
        }
    }

    public void updateEntriesPosition() {
        this.innerBounds = FavoritesListWidget.updateInnerBounds(this.bounds);
        int width = this.innerBounds.width / EntryListWidget.entrySize();
        int pageHeight = this.innerBounds.height / EntryListWidget.entrySize();
        int slotsToPrepare = Math.max(this.favorites.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * EntryListWidget.entrySize() + this.innerBounds.x;
            int yPos = currentY * EntryListWidget.entrySize() + this.innerBounds.y;
            entries.add((EntryListEntry)new EntryListEntry(xPos, yPos).noBackground());
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
    }

    public List<? extends Widget> method_25396() {
        return this.entries;
    }

    public boolean method_25402(double double_1, double double_2, int int_1) {
        if (this.scrolling.updateDraggingState(double_1, double_2, int_1)) {
            return true;
        }
        for (Widget widget : this.method_25396()) {
            if (!widget.method_25402(double_1, double_2, int_1)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX, mouseY)) {
            for (Widget widget : this.method_25396()) {
                if (!widget.method_25406(mouseX, mouseY, button)) continue;
                return true;
            }
            class_746 player = this.minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && player != null && player.field_7514 != null && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.canDeleteItems()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (player != null && player.field_7514 != null && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                return false;
            }
        }
        return false;
    }

    private class EntryListEntry
    extends EntryListEntryWidget {
        private EntryListEntry(int x, int y) {
            super(new Point(x, y));
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && FavoritesListWidget.this.bounds.contains(mouseX, mouseY);
        }

        @Override
        protected boolean reverseFavoritesAction() {
            return true;
        }
    }
}

