/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.REIHelper;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.PreRecipeViewingScreen;
import me.shedaniel.rei.gui.RecipeScreen;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.gui.config.RecipeScreenType;
import me.shedaniel.rei.impl.ScreenHelper;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3528;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_481;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class ClientHelperImpl
implements ClientHelper,
ClientModInitializer {
    private static ClientHelperImpl instance;
    @ApiStatus.Internal
    public final class_3528<Boolean> isYog = new class_3528(() -> {
        try {
            if (class_310.method_1551().method_1548().method_1677().getId().equals(UUID.fromString("f9546389-9415-4358-9c29-2c26b25bff5b"))) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    });
    @ApiStatus.Internal
    public final class_3528<Boolean> isAprilFools = new class_3528(() -> {
        try {
            LocalDateTime now = LocalDateTime.now();
            return now.getMonthValue() == 4 && now.getDayOfMonth() == 1;
        }
        catch (Throwable throwable) {
            return false;
        }
    });
    private final Map<String, String> modNameCache = Maps.newHashMap();

    @ApiStatus.Internal
    public static ClientHelperImpl getInstance() {
        return instance;
    }

    @Override
    public class_2561 getFormattedModFromItem(class_1792 item) {
        String mod = this.getModFromItem(item);
        if (mod.isEmpty()) {
            return class_333.field_18967;
        }
        return new class_2585(mod).method_27695(new class_124[]{class_124.field_1078, class_124.field_1056});
    }

    @Override
    public class_2561 getFormattedModFromIdentifier(class_2960 identifier) {
        String mod = this.getModFromIdentifier(identifier);
        if (mod.isEmpty()) {
            return class_333.field_18967;
        }
        return new class_2585(mod).method_27695(new class_124[]{class_124.field_1078, class_124.field_1056});
    }

    @Override
    public String getModFromItem(class_1792 item) {
        if (item.equals(class_1802.field_8162)) {
            return "";
        }
        return this.getModFromIdentifier(class_2378.field_11142.method_10221((Object)item));
    }

    @Override
    public String getModFromModId(String modid) {
        if (modid == null) {
            return "";
        }
        String any = this.modNameCache.getOrDefault(modid, null);
        if (any != null) {
            return any;
        }
        String s = FabricLoader.getInstance().getModContainer(modid).map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(modid);
        this.modNameCache.put(modid, s);
        return s;
    }

    @Override
    public boolean isCheating() {
        return ConfigObject.getInstance().isCheating();
    }

    @Override
    public void setCheating(boolean cheating) {
        ConfigObject.getInstance().setCheating(cheating);
        ConfigManager.getInstance().saveConfig();
    }

    @Override
    public void sendDeletePacket() {
        if (class_310.method_1551().field_1755 instanceof class_481) {
            class_310.method_1551().field_1724.field_7514.method_7396(class_1799.field_8037);
            ((class_481)class_310.method_1551().field_1755).field_2794 = false;
            return;
        }
        ClientSidePacketRegistry.INSTANCE.sendToServer(RoughlyEnoughItemsNetwork.DELETE_ITEMS_PACKET, new class_2540(Unpooled.buffer()));
    }

    @Override
    public boolean tryCheatingEntry(EntryStack entry) {
        if (entry.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        if (class_310.method_1551().field_1724.field_7514 == null) {
            return false;
        }
        class_1799 cheatedStack = entry.getItemStack().method_7972();
        if (ConfigObject.getInstance().isGrabbingItems() && class_310.method_1551().field_1755 instanceof class_481) {
            class_1661 inventory = class_310.method_1551().field_1724.field_7514;
            EntryStack stack = entry.copy();
            if (!inventory.method_7399().method_7960() && EntryStack.create(inventory.method_7399()).equalsIgnoreAmount(stack)) {
                stack.setAmount(class_3532.method_15340((int)(stack.getAmount() + inventory.method_7399().method_7947()), (int)1, (int)stack.getItemStack().method_7914()));
            } else if (!inventory.method_7399().method_7960()) {
                return false;
            }
            inventory.method_7396(stack.getItemStack().method_7972());
            return true;
        }
        if (RoughlyEnoughItemsCore.canUsePackets()) {
            class_1661 inventory = class_310.method_1551().field_1724.field_7514;
            EntryStack stack = entry.copy();
            if (!inventory.method_7399().method_7960() && !EntryStack.create(inventory.method_7399()).equalsIgnoreAmount(stack)) {
                return false;
            }
            try {
                ClientSidePacketRegistry.INSTANCE.sendToServer(ConfigObject.getInstance().isGrabbingItems() ? RoughlyEnoughItemsNetwork.CREATE_ITEMS_GRAB_PACKET : RoughlyEnoughItemsNetwork.CREATE_ITEMS_PACKET, new class_2540(Unpooled.buffer()).method_10793(cheatedStack));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        class_2960 identifier = entry.getIdentifier().orElse(null);
        if (identifier == null) {
            return false;
        }
        String tagMessage = cheatedStack.method_7972().method_7969() != null && !cheatedStack.method_7972().method_7969().isEmpty() ? cheatedStack.method_7972().method_7969().method_10714() : "";
        String og = cheatedStack.method_7947() == 1 ? ConfigObject.getInstance().getGiveCommand().replaceAll(" \\{count}", "") : ConfigObject.getInstance().getGiveCommand();
        String madeUpCommand = og.replaceAll("\\{player_name}", class_310.method_1551().field_1724.method_5820()).replaceAll("\\{item_name}", identifier.method_12832()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", tagMessage).replaceAll("\\{count}", String.valueOf(cheatedStack.method_7947()));
        if (madeUpCommand.length() > 256) {
            madeUpCommand = og.replaceAll("\\{player_name}", class_310.method_1551().field_1724.method_5820()).replaceAll("\\{item_name}", identifier.method_12832()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", "").replaceAll("\\{count}", String.valueOf(cheatedStack.method_7947()));
            class_310.method_1551().field_1724.method_7353((class_2561)new class_2588("text.rei.too_long_nbt"), false);
        }
        class_310.method_1551().field_1724.method_3142(madeUpCommand);
        return true;
    }

    @Override
    public List<class_1799> getInventoryItemsTypes() {
        ArrayList<class_1799> inventoryStacks = new ArrayList<class_1799>((Collection<class_1799>)class_310.method_1551().field_1724.field_7514.field_7547);
        inventoryStacks.addAll((Collection<class_1799>)class_310.method_1551().field_1724.field_7514.field_7548);
        inventoryStacks.addAll((Collection<class_1799>)class_310.method_1551().field_1724.field_7514.field_7544);
        return inventoryStacks;
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void openRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> map) {
        this.openRecipeViewingScreen(map, null, null, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @ApiStatus.Internal
    public void openRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> map, @Nullable class_2960 category, @Nullable EntryStack ingredientNotice, @Nullable EntryStack resultNotice) {
        this.openView(new LegacyWrapperViewSearchBuilder(map).setPreferredOpenedCategory(category).setInputNotice(ingredientNotice).setOutputNotice(resultNotice).fillPreferredOpenedCategory());
    }

    @Override
    public boolean openView(ClientHelper.ViewSearchBuilder builder) {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = builder.buildMap();
        if (map.isEmpty()) {
            return false;
        }
        class_437 screen = ConfigObject.getInstance().getRecipeScreenType() == RecipeScreenType.VILLAGER ? new VillagerRecipeViewingScreen(map, builder.getPreferredOpenedCategory()) : (ConfigObject.getInstance().getRecipeScreenType() == RecipeScreenType.UNSET ? new PreRecipeViewingScreen((class_437)REIHelper.getInstance().getPreviousContainerScreen(), RecipeScreenType.UNSET, true, original -> {
            ConfigObject.getInstance().setRecipeScreenType(original ? RecipeScreenType.ORIGINAL : RecipeScreenType.VILLAGER);
            ConfigManager.getInstance().saveConfig();
            this.openView(builder);
        }) : new RecipeViewingScreen(map, builder.getPreferredOpenedCategory()));
        if (screen instanceof RecipeScreen) {
            if (builder.getInputNotice() != null) {
                ((RecipeScreen)screen).addIngredientStackToNotice(builder.getInputNotice());
            }
            if (builder.getOutputNotice() != null) {
                ((RecipeScreen)screen).addResultStackToNotice(builder.getOutputNotice());
            }
        }
        if (class_310.method_1551().field_1755 instanceof RecipeScreen) {
            ScreenHelper.storeRecipeScreen((RecipeScreen)class_310.method_1551().field_1755);
        }
        class_310.method_1551().method_1507(screen);
        return true;
    }

    public void onInitializeClient() {
        instance = this;
        this.modNameCache.put("minecraft", "Minecraft");
        this.modNameCache.put("c", "Global");
        this.modNameCache.put("global", "Global");
    }

    public static final class LegacyWrapperViewSearchBuilder
    implements ClientHelper.ViewSearchBuilder {
        @NotNull
        private final Map<RecipeCategory<?>, List<RecipeDisplay>> map;
        @Nullable
        private class_2960 preferredOpenedCategory = null;
        @Nullable
        private EntryStack inputNotice;
        @Nullable
        private EntryStack outputNotice;

        public LegacyWrapperViewSearchBuilder(@NotNull Map<RecipeCategory<?>, List<RecipeDisplay>> map) {
            this.map = map;
        }

        @Override
        public ClientHelper.ViewSearchBuilder addCategory(class_2960 category) {
            return this;
        }

        @Override
        public ClientHelper.ViewSearchBuilder addCategories(Collection<class_2960> categories) {
            return this;
        }

        @Override
        @NotNull
        public Set<class_2960> getCategories() {
            return Collections.emptySet();
        }

        @Override
        public ClientHelper.ViewSearchBuilder addRecipesFor(EntryStack stack) {
            return this;
        }

        @Override
        @NotNull
        public List<EntryStack> getRecipesFor() {
            return Collections.emptyList();
        }

        @Override
        public ClientHelper.ViewSearchBuilder addUsagesFor(EntryStack stack) {
            return this;
        }

        @Override
        @NotNull
        public List<EntryStack> getUsagesFor() {
            return Collections.emptyList();
        }

        @Override
        public ClientHelper.ViewSearchBuilder setPreferredOpenedCategory(@Nullable class_2960 category) {
            this.preferredOpenedCategory = category;
            return this;
        }

        @Override
        @Nullable
        public class_2960 getPreferredOpenedCategory() {
            return this.preferredOpenedCategory;
        }

        @Override
        public ClientHelper.ViewSearchBuilder setInputNotice(@Nullable EntryStack stack) {
            this.inputNotice = stack;
            return this;
        }

        @Override
        @Nullable
        public EntryStack getInputNotice() {
            return this.inputNotice;
        }

        @Override
        public ClientHelper.ViewSearchBuilder setOutputNotice(@Nullable EntryStack stack) {
            this.outputNotice = stack;
            return this;
        }

        @Override
        @Nullable
        public EntryStack getOutputNotice() {
            return this.outputNotice;
        }

        @Override
        @NotNull
        public Map<RecipeCategory<?>, List<RecipeDisplay>> buildMap() {
            return this.map;
        }
    }

    public static final class ViewSearchBuilder
    implements ClientHelper.ViewSearchBuilder {
        @NotNull
        private final Set<class_2960> categories = new HashSet<class_2960>();
        @NotNull
        private final List<EntryStack> recipesFor = new ArrayList<EntryStack>();
        @NotNull
        private final List<EntryStack> usagesFor = new ArrayList<EntryStack>();
        @Nullable
        private class_2960 preferredOpenedCategory = null;
        @Nullable
        private EntryStack inputNotice;
        @Nullable
        private EntryStack outputNotice;
        @NotNull
        private final class_3528<Map<RecipeCategory<?>, List<RecipeDisplay>>> map = new class_3528(() -> RecipeHelper.getInstance().buildMapFor(this));

        @Override
        public ClientHelper.ViewSearchBuilder addCategory(class_2960 category) {
            this.categories.add(category);
            return this;
        }

        @Override
        public ClientHelper.ViewSearchBuilder addCategories(Collection<class_2960> categories) {
            this.categories.addAll(categories);
            return this;
        }

        @Override
        @NotNull
        public Set<class_2960> getCategories() {
            return this.categories;
        }

        @Override
        public ClientHelper.ViewSearchBuilder addRecipesFor(EntryStack stack) {
            this.recipesFor.add(stack);
            return this;
        }

        @Override
        @NotNull
        public List<EntryStack> getRecipesFor() {
            return this.recipesFor;
        }

        @Override
        public ClientHelper.ViewSearchBuilder addUsagesFor(EntryStack stack) {
            this.usagesFor.add(stack);
            return this;
        }

        @Override
        @NotNull
        public List<EntryStack> getUsagesFor() {
            return this.usagesFor;
        }

        @Override
        public ClientHelper.ViewSearchBuilder setPreferredOpenedCategory(@Nullable class_2960 category) {
            this.preferredOpenedCategory = category;
            return this;
        }

        @Override
        @Nullable
        public class_2960 getPreferredOpenedCategory() {
            return this.preferredOpenedCategory;
        }

        @Override
        public ClientHelper.ViewSearchBuilder setInputNotice(@Nullable EntryStack stack) {
            this.inputNotice = stack;
            return this;
        }

        @Override
        @Nullable
        public EntryStack getInputNotice() {
            return this.inputNotice;
        }

        @Override
        public ClientHelper.ViewSearchBuilder setOutputNotice(@Nullable EntryStack stack) {
            this.outputNotice = stack;
            return this;
        }

        @Override
        @Nullable
        public EntryStack getOutputNotice() {
            return this.outputNotice;
        }

        @Override
        @NotNull
        public Map<RecipeCategory<?>, List<RecipeDisplay>> buildMap() {
            return (Map)this.map.method_15332();
        }
    }
}

