/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.filtering;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.impl.AmountIgnoredEntryStackWrapper;
import me.shedaniel.rei.impl.filtering.FilteringResultImpl;
import me.shedaniel.rei.utils.CollectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
@ApiStatus.Experimental
public interface FilteringResult {
    public static FilteringResult create() {
        return FilteringResult.create(Lists.newArrayList(), Lists.newArrayList());
    }

    public static FilteringResult create(List<EntryStack> hiddenStacks, List<EntryStack> shownStacks) {
        return new FilteringResultImpl(hiddenStacks, shownStacks);
    }

    public Set<AmountIgnoredEntryStackWrapper> getHiddenStacks();

    public Set<AmountIgnoredEntryStackWrapper> getShownStacks();

    default public FilteringResult hide(EntryStack stack) {
        this.getHiddenStacks().add(new AmountIgnoredEntryStackWrapper(stack));
        return this;
    }

    default public FilteringResult hide(Collection<EntryStack> stacks) {
        this.getHiddenStacks().addAll(CollectionUtils.map(stacks, AmountIgnoredEntryStackWrapper::new));
        return this;
    }

    default public FilteringResult show(EntryStack stack) {
        this.getShownStacks().add(new AmountIgnoredEntryStackWrapper(stack));
        return this;
    }

    default public FilteringResult show(Collection<EntryStack> stacks) {
        this.getShownStacks().addAll(CollectionUtils.map(stacks, AmountIgnoredEntryStackWrapper::new));
        return this;
    }

    default public FilteringResult hideW(AmountIgnoredEntryStackWrapper stack) {
        this.getHiddenStacks().add(stack);
        return this;
    }

    default public FilteringResult hideW(Collection<AmountIgnoredEntryStackWrapper> stacks) {
        this.getHiddenStacks().addAll(stacks);
        return this;
    }

    default public FilteringResult showW(AmountIgnoredEntryStackWrapper stack) {
        this.getShownStacks().add(stack);
        return this;
    }

    default public FilteringResult showW(Collection<AmountIgnoredEntryStackWrapper> stacks) {
        this.getShownStacks().addAll(stacks);
        return this;
    }
}

