/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.filtering.rules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.gui.config.entry.FilteringEntry;
import me.shedaniel.rei.gui.config.entry.FilteringRuleOptionsScreen;
import me.shedaniel.rei.impl.SearchArgument;
import me.shedaniel.rei.impl.filtering.AbstractFilteringRule;
import me.shedaniel.rei.impl.filtering.FilteringContext;
import me.shedaniel.rei.impl.filtering.FilteringResult;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class SearchFilteringRule
extends AbstractFilteringRule<SearchFilteringRule> {
    private String filter;
    private List<SearchArgument.SearchArguments> arguments;
    private boolean show;

    public SearchFilteringRule() {
    }

    public SearchFilteringRule(String filter, List<SearchArgument.SearchArguments> arguments, boolean show) {
        this.filter = filter;
        this.arguments = arguments;
        this.show = show;
    }

    @Override
    public class_2487 toTag(class_2487 tag) {
        tag.method_10582("filter", this.filter);
        tag.method_10556("show", this.show);
        return tag;
    }

    @Override
    public SearchFilteringRule createFromTag(class_2487 tag) {
        String filter = tag.method_10558("filter");
        boolean show = tag.method_10577("show");
        return new SearchFilteringRule(filter, SearchArgument.processSearchTerm(filter), show);
    }

    @Override
    @NotNull
    public FilteringResult processFilteredStacks(@NotNull FilteringContext context) {
        ArrayList completableFutures = Lists.newArrayList();
        this.processList(context.getUnsetStacks(), completableFutures);
        if (this.show) {
            this.processList(context.getHiddenStacks(), completableFutures);
        } else {
            this.processList(context.getShownStacks(), completableFutures);
        }
        try {
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        FilteringResult result = FilteringResult.create();
        for (CompletableFuture future : completableFutures) {
            List now = future.getNow(null);
            if (now == null) continue;
            if (this.show) {
                result.show(now);
                continue;
            }
            result.hide(now);
        }
        return result;
    }

    @Override
    public SearchFilteringRule createNew() {
        return new SearchFilteringRule("", Collections.singletonList(SearchArgument.SearchArguments.ALWAYS), true);
    }

    private void processList(Collection<EntryStack> stacks, List<CompletableFuture<List<EntryStack>>> completableFutures) {
        int size = 100;
        Iterator<EntryStack> iterator = stacks.iterator();
        for (int i = 0; i < stacks.size(); i += size) {
            int[] start = new int[]{i};
            completableFutures.add(CompletableFuture.supplyAsync(() -> {
                int end = Math.min(stacks.size(), start[0] + size);
                ArrayList output = Lists.newArrayList();
                while (start[0] < end) {
                    EntryStack stack = (EntryStack)((List)stacks).get(start[0]);
                    boolean shown = SearchArgument.canSearchTermsBeAppliedTo(stack, this.arguments);
                    if (shown) {
                        output.add(stack);
                    }
                    start[0] = start[0] + 1;
                }
                return output;
            }));
        }
    }

    @Override
    public class_2561 getTitle() {
        return new class_2588("rule.roughlyenoughitems.filtering.search");
    }

    @Override
    public class_2561 getSubtitle() {
        return new class_2588("rule.roughlyenoughitems.filtering.search.subtitle");
    }

    @Override
    public Optional<BiFunction<FilteringEntry, class_437, class_437>> createEntryScreen() {
        return Optional.of((entry, screen) -> new FilteringRuleOptionsScreen<SearchFilteringRule>(entry, this, screen){
            FilteringRuleOptionsScreen.TextFieldRuleEntry entry;
            FilteringRuleOptionsScreen.BooleanRuleEntry show;
            {
                this.entry = null;
                this.show = null;
            }

            @Override
            public void addEntries(Consumer<FilteringRuleOptionsScreen.RuleEntry> entryConsumer) {
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (class_5348)new class_2588("rule.roughlyenoughitems.filtering.search.filter").method_27692(class_124.field_1080));
                this.entry = new FilteringRuleOptionsScreen.TextFieldRuleEntry(this.field_22789 - 36, this.rule, widget -> {
                    widget.method_1880(9999);
                    if (this.entry != null) {
                        widget.method_1852(this.entry.getWidget().method_1882());
                    } else {
                        widget.method_1852(((SearchFilteringRule)this.rule).filter);
                    }
                });
                entryConsumer.accept(this.entry);
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (class_5348)new class_2588("rule.roughlyenoughitems.filtering.search.show").method_27692(class_124.field_1080));
                this.show = new FilteringRuleOptionsScreen.BooleanRuleEntry(this.field_22789 - 36, this.show == null ? ((SearchFilteringRule)this.rule).show : this.show.getBoolean(), this.rule, bool -> new class_2588("rule.roughlyenoughitems.filtering.search.show." + bool));
                entryConsumer.accept(this.show);
            }

            @Override
            public void save() {
                ((SearchFilteringRule)this.rule).filter = this.entry.getWidget().method_1882();
                ((SearchFilteringRule)this.rule).arguments = SearchArgument.processSearchTerm(((SearchFilteringRule)this.rule).filter);
                ((SearchFilteringRule)this.rule).show = this.show.getBoolean();
            }
        });
    }
}

