/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.search;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.impl.search.AlwaysMatchingArgument;
import me.shedaniel.rei.impl.search.Argument;
import me.shedaniel.rei.impl.search.ModArgument;
import me.shedaniel.rei.impl.search.RegexArgument;
import me.shedaniel.rei.impl.search.TagArgument;
import me.shedaniel.rei.impl.search.TextArgument;
import me.shedaniel.rei.impl.search.TooltipArgument;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ArgumentsRegistry {
    public static final Map<String, Argument> ARGUMENTS = Maps.newHashMap();
    public static final List<Argument> ARGUMENT_LIST = Lists.newArrayList();

    private static void register(Argument argument) {
        ARGUMENTS.put(argument.getName(), argument);
        ARGUMENT_LIST.add(argument);
    }

    static {
        ArgumentsRegistry.register(AlwaysMatchingArgument.INSTANCE);
        ArgumentsRegistry.register(ModArgument.INSTANCE);
        ArgumentsRegistry.register(TooltipArgument.INSTANCE);
        ArgumentsRegistry.register(TagArgument.INSTANCE);
        ArgumentsRegistry.register(RegexArgument.INSTANCE);
        ArgumentsRegistry.register(TextArgument.INSTANCE);
    }
}

