/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.impl.search.Argument;
import me.shedaniel.rei.impl.search.MatchStatus;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class RegexArgument
extends Argument {
    public static final RegexArgument INSTANCE = new RegexArgument();

    @Override
    public String getName() {
        return "regex";
    }

    @Override
    public MatchStatus matchesArgumentPrefix(String text) {
        boolean inverted = false;
        String matchText = text;
        if (matchText.startsWith("-")) {
            inverted = true;
            matchText = matchText.substring(1);
        }
        if (matchText.length() >= 3 && matchText.startsWith("r/") && matchText.endsWith("/")) {
            return !inverted ? MatchStatus.matched(matchText.substring(2, matchText.length() - 1), true) : MatchStatus.invertMatched(matchText.substring(2, matchText.length() - 1), true);
        }
        return MatchStatus.unmatched();
    }

    @Override
    public Object prepareSearchData(String searchText) {
        try {
            return Pattern.compile(searchText);
        }
        catch (PatternSyntaxException ignored) {
            return null;
        }
    }

    @Override
    public boolean matches(Object[] data, EntryStack stack, String searchText, Object searchData) {
        Matcher matcher;
        Pattern pattern = (Pattern)searchData;
        if (pattern == null) {
            return false;
        }
        if (data[this.getDataOrdinal()] == null) {
            String name = stack.asFormatStrippedText().getString();
            data[this.getDataOrdinal()] = name;
        }
        return (matcher = pattern.matcher((String)data[this.getDataOrdinal()])) != null && matcher.matches();
    }

    private RegexArgument() {
    }
}

