/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.api.SyntaxError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.Marshaller;
import me.zeroeightsix.fiber.exception.FiberException;
import me.zeroeightsix.fiber.tree.Commentable;
import me.zeroeightsix.fiber.tree.HasValue;
import me.zeroeightsix.fiber.tree.Node;
import me.zeroeightsix.fiber.tree.Property;
import me.zeroeightsix.fiber.tree.Transparent;
import me.zeroeightsix.fiber.tree.TreeItem;

public class JanksonSettings {
    @Nonnull
    private final Marshaller<JsonElement> marshaller;

    public JanksonSettings(@Nonnull Marshaller<JsonElement> marshaller) {
        this.marshaller = marshaller;
    }

    public JanksonSettings() {
        this(JanksonFallbackMarshaller.INSTANCE);
    }

    public void deserialize(Node node, InputStream stream) throws IOException, FiberException {
        JsonObject object;
        Jankson jankson = Jankson.builder().build();
        try {
            object = jankson.load(stream);
        }
        catch (SyntaxError syntaxError) {
            throw new FiberException("Configuration file was malformed", syntaxError);
        }
        this.deserialize(node, object);
    }

    private void deserialize(Node node, JsonObject element) throws FiberException {
        for (Map.Entry<String, JsonElement> entry : element.entrySet()) {
            String key = entry.getKey();
            JsonElement child = entry.getValue();
            TreeItem item = node.lookup(key);
            if (item != null) {
                if (item instanceof Property) {
                    this.setPropertyValue((Property)((Object)item), child);
                    continue;
                }
                if (item instanceof Node && child instanceof JsonObject) {
                    this.deserialize((Node)item, (JsonObject)child);
                    continue;
                }
                throw new FiberException("Value read for non-property node: " + item.getName());
            }
            JanksonTransparentNode transparentNode = new JanksonTransparentNode(key, child);
            node.add(transparentNode);
        }
    }

    private <T> void setPropertyValue(Property<T> property, JsonElement child) {
        Class type = property.getType();
        property.setValue(this.marshall(type, child));
    }

    public void serialize(Node node, OutputStream stream, boolean compress) throws IOException {
        JsonObject object = this.serialize(node);
        stream.write(object.toJson(!compress, !compress).getBytes(StandardCharsets.UTF_8));
    }

    private JsonObject serialize(Node node) {
        JsonObject object = new JsonObject();
        for (TreeItem treeItem : node.getItems()) {
            String name = null;
            if (treeItem instanceof Node) {
                Node subNode = (Node)treeItem;
                if (!subNode.isSerializedSeparately()) {
                    name = subNode.getName();
                    object.put(name, this.serialize(subNode));
                }
            } else if (treeItem instanceof HasValue) {
                name = treeItem.getName();
                object.put(name, this.serialize((HasValue)((Object)treeItem)));
            }
            if (name == null || !(treeItem instanceof Commentable)) continue;
            object.setComment(name, ((Commentable)((Object)treeItem)).getComment());
        }
        return object;
    }

    private JsonElement serialize(HasValue<?> hasValue) {
        return this.marshaller.marshall(hasValue.getValue());
    }

    private <A> A marshall(Class<A> type, JsonElement value) {
        return this.marshaller.marshallReverse(type, value);
    }

    private static class JanksonFallbackMarshaller
    implements Marshaller<JsonElement> {
        private static JanksonFallbackMarshaller INSTANCE = new JanksonFallbackMarshaller();
        private final blue.endless.jankson.api.Marshaller marshaller = Jankson.builder().build().getMarshaller();

        private JanksonFallbackMarshaller() {
        }

        @Override
        public JsonElement marshall(Object value) {
            return this.marshaller.serialize(value);
        }

        @Override
        public <A> A marshallReverse(Class<A> type, JsonElement value) {
            return this.marshaller.marshall(type, value);
        }
    }

    private class JanksonTransparentNode
    implements Transparent {
        private final String name;
        private final JsonElement value;

        public JanksonTransparentNode(String name, JsonElement value) {
            this.name = name;
            this.value = value;
        }

        @Override
        @Nullable
        public <A> A marshall(Class<A> type) {
            return (A)JanksonSettings.this.marshall(type, this.value);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[name=" + this.getName() + "]";
        }
    }
}

