/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.annotation.AnnotatedSettings;
import me.zeroeightsix.fiber.builder.constraint.ConstraintsBuilder;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;
import me.zeroeightsix.fiber.tree.ConfigValue;
import me.zeroeightsix.fiber.tree.Node;

public abstract class ConfigValueBuilder<T, B extends ConfigValueBuilder<T, B>> {
    @Nonnull
    protected final Class<T> type;
    @Nullable
    private String name;
    @Nullable
    private String comment = null;
    @Nullable
    private T defaultValue = null;
    private boolean isFinal = false;
    private BiConsumer<T, T> consumer = (t, t2) -> {};
    protected List<Constraint<? super T>> constraintList = new ArrayList<Constraint<? super T>>();
    private Node parentNode = null;

    public static boolean isAggregate(Class<?> type) {
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    public static <E> Aggregate<E[], E> aggregate(@Nonnull Class<E[]> arrayType) {
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException(arrayType + " is not a valid array type");
        }
        return new Aggregate(arrayType, AnnotatedSettings.wrapPrimitive(arrayType.getComponentType()));
    }

    public static <C extends Collection<E>, E> Aggregate<C, E> aggregate(@Nonnull Class<? super C> collectionType, @Nonnull Class<E> componentType) {
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException(collectionType + " is not a valid Collection type");
        }
        return new Aggregate<C, E>(collectionType, componentType);
    }

    public static <T> Scalar<T> scalar(Class<T> type) {
        return new Scalar<T>(type);
    }

    ConfigValueBuilder(@Nonnull Class<T> type) {
        this.type = type;
    }

    public B withName(String name) {
        this.name = name;
        return this.self();
    }

    public B withComment(String comment) {
        this.comment = comment;
        return this.self();
    }

    public B withListener(BiConsumer<T, T> consumer) {
        BiConsumer prevConsumer = this.consumer;
        this.consumer = (t, t2) -> {
            prevConsumer.accept(t, t2);
            consumer.accept(t, t2);
        };
        return this.self();
    }

    public B withDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this.self();
    }

    public B setFinal() {
        this.isFinal = true;
        return this.self();
    }

    public B setFinal(boolean isFinal) {
        this.isFinal = isFinal;
        return this.self();
    }

    public B withParent(Node node) {
        this.parentNode = node;
        return this.self();
    }

    protected final B self() {
        return (B)this;
    }

    public abstract ConstraintsBuilder<B, T, ?, ?> constraints();

    public ConfigValue<T> build() {
        ConfigValue<? super T> built = new ConfigValue<T>(this.name, this.comment, this.defaultValue, this.defaultValue, this.consumer, this.constraintList, this.type, this.isFinal);
        if (this.parentNode != null) {
            try {
                this.parentNode.add(built);
            }
            catch (Exception e) {
                throw new RuntimeFiberException("Failed to register leaf to node", e);
            }
        }
        return built;
    }

    public static final class Aggregate<A, E>
    extends ConfigValueBuilder<A, Aggregate<A, E>> {
        @Nonnull
        private final Class<E> componentType;

        Aggregate(@Nonnull Class<A> type, @Nonnull Class<E> componentType) {
            super(type);
            this.componentType = componentType;
        }

        public ConstraintsBuilder.Aggregate<Aggregate<A, E>, A, E> constraints() {
            return ConstraintsBuilder.aggregate(this, this.constraintList, this.type, this.componentType);
        }
    }

    public static class Scalar<T>
    extends ConfigValueBuilder<T, Scalar<T>> {
        Scalar(@Nonnull Class<T> type) {
            super(type);
        }

        public ConstraintsBuilder.Scalar<Scalar<T>, T> constraints() {
            return ConstraintsBuilder.scalar(this, this.constraintList, this.type);
        }
    }
}

