/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder.constraint;

import java.util.List;
import me.zeroeightsix.fiber.builder.constraint.AbstractConstraintsBuilder;
import me.zeroeightsix.fiber.builder.constraint.ComponentConstraintsBuilder;
import me.zeroeightsix.fiber.builder.constraint.CompositeConstraintBuilder;
import me.zeroeightsix.fiber.constraint.CompositeType;
import me.zeroeightsix.fiber.constraint.Constraint;

public abstract class ConstraintsBuilder<S, A, T, B extends ConstraintsBuilder<S, A, T, B>>
extends AbstractConstraintsBuilder<S, A, T, B> {
    public static <S, T> Scalar<S, T> scalar(S source, List<Constraint<? super T>> constraints, Class<T> type) {
        return new Scalar(source, constraints, type);
    }

    public static <S, A, T> Aggregate<S, A, T> aggregate(S source, List<Constraint<? super A>> constraints, Class<A> aggregateType, Class<T> componentType) {
        return new Aggregate(source, constraints, aggregateType, componentType);
    }

    ConstraintsBuilder(S source, List<Constraint<? super A>> sourceConstraints, Class<T> type) {
        super(source, sourceConstraints, type);
    }

    public abstract CompositeConstraintBuilder<B, A> composite(CompositeType var1);

    public abstract S finish();

    public static class Aggregate<S, A, T>
    extends ConstraintsBuilder<S, A, A, Aggregate<S, A, T>> {
        private final Class<T> componentType;

        private Aggregate(S source, List<Constraint<? super A>> sourceConstraints, Class<A> type, Class<T> componentType) {
            super(source, sourceConstraints, type);
            this.componentType = componentType;
        }

        @Override
        public CompositeConstraintBuilder<Aggregate<S, A, T>, A> composite(CompositeType type) {
            return new CompositeConstraintBuilder(this, type, this.sourceConstraints, this.type);
        }

        public ComponentConstraintsBuilder<Aggregate<S, A, T>, A, T> component() {
            if (this.type.isArray()) {
                List sourceConstraints = this.sourceConstraints;
                return ComponentConstraintsBuilder.array(this, sourceConstraints, this.componentType);
            }
            List sourceConstraints = this.sourceConstraints;
            return ComponentConstraintsBuilder.collection(this, sourceConstraints, this.componentType);
        }

        @Override
        public S finish() {
            this.sourceConstraints.addAll(this.newConstraints);
            return (S)this.source;
        }
    }

    public static final class Scalar<S, T>
    extends ConstraintsBuilder<S, T, T, Scalar<S, T>> {
        private Scalar(S source, List<Constraint<? super T>> sourceConstraints, Class<T> type) {
            super(source, sourceConstraints, type);
        }

        @Override
        public CompositeConstraintBuilder<Scalar<S, T>, T> composite(CompositeType type) {
            return new CompositeConstraintBuilder(this, type, this.sourceConstraints, this.type);
        }

        @Override
        public S finish() {
            this.sourceConstraints.addAll(this.newConstraints);
            return (S)this.source;
        }
    }
}

