/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.schema;

import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import blue.endless.jankson.impl.MarshallerImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.Identifier;
import me.zeroeightsix.fiber.Marshaller;
import me.zeroeightsix.fiber.builder.constraint.CompositeConstraintBuilder;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.constraint.ValuedConstraint;
import me.zeroeightsix.fiber.tree.ConfigValue;
import me.zeroeightsix.fiber.tree.Node;

public class SchemaGenerator {
    private HashMap<Class<?>, Identifier> classIdentifierHashMap = new HashMap();
    @Nullable
    private Marshaller<JsonElement> marshaller;

    public SchemaGenerator(@Nullable Marshaller<JsonElement> marshaller) {
        this.marshaller = marshaller;
        this.classIdentifierHashMap.put(Boolean.class, this.identifier("boolean"));
        this.classIdentifierHashMap.put(Byte.class, this.identifier("byte"));
        this.classIdentifierHashMap.put(Short.class, this.identifier("short"));
        this.classIdentifierHashMap.put(Integer.class, this.identifier("int"));
        this.classIdentifierHashMap.put(Long.class, this.identifier("long"));
        this.classIdentifierHashMap.put(Float.class, this.identifier("float"));
        this.classIdentifierHashMap.put(Double.class, this.identifier("double"));
        this.classIdentifierHashMap.put(String.class, this.identifier("string"));
    }

    public SchemaGenerator() {
        this(null);
    }

    public JsonObject createSchema(Node node) {
        JsonObject object = new JsonObject();
        node.getItems().forEach(item -> {
            if (item instanceof Node) {
                object.put(item.getName(), this.createSchema((Node)item));
            } else if (item instanceof ConfigValue) {
                object.put(item.getName(), this.createSchema((ConfigValue)item));
            }
        });
        return object;
    }

    private JsonObject createSchema(ConfigValue<?> item) {
        JsonObject object = new JsonObject();
        if (item.getType() != null && this.classIdentifierHashMap.containsKey(item.getType())) {
            object.put("type", new JsonPrimitive(this.classIdentifierHashMap.get(item.getType())));
        }
        if (item.getComment() != null) {
            object.put("comment", new JsonPrimitive(item.getComment()));
        }
        if (item.getDefaultValue() != null) {
            Object o = item.getDefaultValue();
            object.put("defaultValue", (JsonElement)Optional.ofNullable(this.marshaller != null ? this.marshaller.marshall(o) : null).orElse(MarshallerImpl.getFallback().serialize(o)));
        }
        if (!item.getConstraints().isEmpty()) {
            object.put("constraints", this.createSchema(item.getConstraints()));
        }
        return object;
    }

    private JsonElement createSchema(List<? extends Constraint<?>> constraintList) {
        JsonArray array = new JsonArray();
        for (Constraint<?> constraint : constraintList) {
            JsonObject object = new JsonObject();
            object.put("identifier", new JsonPrimitive(constraint.getType().getIdentifier().toString()));
            if (constraint instanceof ValuedConstraint) {
                object.put("value", new JsonPrimitive(((ValuedConstraint)constraint).getValue()));
            }
            if (constraint instanceof CompositeConstraintBuilder.AbstractCompositeConstraint) {
                object.put("constraints", this.createSchema(((CompositeConstraintBuilder.AbstractCompositeConstraint)constraint).constraints));
            }
            array.add(object);
        }
        return array;
    }

    private Identifier identifier(String name) {
        return new Identifier("fiber", name);
    }
}

