/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder.constraint;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.RegEx;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.constraint.ConstraintType;
import me.zeroeightsix.fiber.constraint.LengthConstraint;
import me.zeroeightsix.fiber.constraint.NumberConstraint;
import me.zeroeightsix.fiber.constraint.RegexConstraint;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;

public abstract class AbstractConstraintsBuilder<S, A, T, B extends AbstractConstraintsBuilder<S, A, T, B>> {
    protected final S source;
    protected final List<Constraint<? super A>> sourceConstraints;
    protected final Class<T> type;
    final List<Constraint<? super T>> newConstraints = new ArrayList<Constraint<? super T>>();

    AbstractConstraintsBuilder(S source, List<Constraint<? super A>> sourceConstraints, Class<T> type) {
        this.source = source;
        this.sourceConstraints = sourceConstraints;
        this.type = type;
    }

    public B atLeast(T min) throws RuntimeFiberException {
        this.checkNumerical();
        this.checkNumerical(min);
        this.newConstraints.add(new NumberConstraint<Number>(ConstraintType.NUMERICAL_LOWER_BOUND, (Number)min));
        return this.self();
    }

    public B atMost(T max) {
        this.checkNumerical();
        this.checkNumerical(max);
        this.newConstraints.add(new NumberConstraint<Number>(ConstraintType.NUMERICAL_UPPER_BOUND, (Number)max));
        return this.self();
    }

    public B range(T min, T max) {
        this.atLeast(min);
        this.atMost(max);
        return this.self();
    }

    public B minLength(int min) {
        if (min < 0) {
            throw new IllegalArgumentException(min + " is not a valid length");
        }
        this.newConstraints.add(LengthConstraint.min(this.type, min));
        return this.self();
    }

    public B maxLength(int max) {
        if (max < 0) {
            throw new IllegalArgumentException(max + " is not a valid length");
        }
        this.newConstraints.add(LengthConstraint.max(this.type, max));
        return this.self();
    }

    public B regex(@RegEx String regexPattern) {
        this.checkCharSequence();
        this.newConstraints.add(new RegexConstraint(Pattern.compile(regexPattern)));
        return this.self();
    }

    private void checkNumerical() {
        if (!Number.class.isAssignableFrom(this.type)) {
            throw new UnsupportedOperationException("Can't apply numerical constraint to non-numerical setting");
        }
    }

    private void checkNumerical(T value) {
        if (!Number.class.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("'" + value + "' is not a number");
        }
    }

    private void checkCharSequence() {
        if (!CharSequence.class.isAssignableFrom(this.type)) {
            throw new UnsupportedOperationException("Can only apply regex pattern constraint to character sequences");
        }
    }

    protected B self() {
        return (B)this;
    }
}

