/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder.constraint;

import java.util.List;
import me.zeroeightsix.fiber.builder.constraint.AbstractConstraintsBuilder;
import me.zeroeightsix.fiber.builder.constraint.ComponentConstraintsBuilder;
import me.zeroeightsix.fiber.builder.constraint.CompositeConstraintBuilder;
import me.zeroeightsix.fiber.constraint.CompositeType;
import me.zeroeightsix.fiber.constraint.Constraint;

public abstract class ConstraintsBuilder<S, T, B extends ConstraintsBuilder<S, T, B>>
extends AbstractConstraintsBuilder<S, T, T, B> {
    public static <S, T> Scalar<S, T> scalar(S source, List<Constraint<? super T>> constraints, Class<T> type) {
        return new Scalar(source, constraints, type);
    }

    public static <S, A, T> Aggregate<S, A, T> aggregate(S source, List<Constraint<? super A>> constraints, Class<A> aggregateType, Class<T> componentType) {
        return new Aggregate(source, constraints, aggregateType, componentType);
    }

    ConstraintsBuilder(S source, List<Constraint<? super T>> sourceConstraints, Class<T> type) {
        super(source, sourceConstraints, type);
    }

    public CompositeConstraintBuilder<B, T> composite(CompositeType type) {
        return new CompositeConstraintBuilder(this.self(), type, this.sourceConstraints, this.type);
    }

    public S finish() {
        this.sourceConstraints.addAll(this.newConstraints);
        return (S)this.source;
    }

    public static class Aggregate<S, T, C>
    extends ConstraintsBuilder<S, T, Aggregate<S, T, C>> {
        private final Class<C> componentType;

        private Aggregate(S source, List<Constraint<? super T>> sourceConstraints, Class<T> type, Class<C> componentType) {
            super(source, sourceConstraints, type);
            this.componentType = componentType;
        }

        public ComponentConstraintsBuilder<Aggregate<S, T, C>, T, C> component() {
            if (this.type.isArray()) {
                List sourceConstraints = this.sourceConstraints;
                return ComponentConstraintsBuilder.array(this, sourceConstraints, this.componentType);
            }
            List sourceConstraints = this.sourceConstraints;
            return ComponentConstraintsBuilder.collection(this, sourceConstraints, this.componentType);
        }
    }

    public static final class Scalar<S, T>
    extends ConstraintsBuilder<S, T, Scalar<S, T>> {
        private Scalar(S source, List<Constraint<? super T>> sourceConstraints, Class<T> type) {
            super(source, sourceConstraints, type);
        }
    }
}

