/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.constraint;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import me.zeroeightsix.fiber.constraint.ConstraintType;
import me.zeroeightsix.fiber.constraint.ValuedConstraint;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;

public class LengthConstraint<T>
extends ValuedConstraint<Integer, T> {
    private final ToIntFunction<T> lengthGetter;

    public static <T> LengthConstraint<T> min(Class<T> type, int min) {
        return new LengthConstraint<T>(ConstraintType.MINIMUM_LENGTH, LengthConstraint.getLengthFunction(type), min);
    }

    public static <T> LengthConstraint<T> max(Class<T> type, int min) {
        return new LengthConstraint<T>(ConstraintType.MAXIMUM_LENGTH, LengthConstraint.getLengthFunction(type), min);
    }

    @Nonnull
    private static <T> ToIntFunction<T> getLengthFunction(Class<T> type) {
        ToIntFunction<Object> length;
        if (type.isArray()) {
            length = Array::getLength;
        } else if (CharSequence.class.isAssignableFrom(type)) {
            length = t -> ((CharSequence)t).length();
        } else if (Collection.class.isAssignableFrom(type)) {
            length = t -> ((Collection)t).size();
        } else if (Map.class.isAssignableFrom(type)) {
            length = t -> ((Map)t).size();
        } else {
            throw new RuntimeFiberException("Instances of " + type + " do not have a known length or size");
        }
        return length;
    }

    private LengthConstraint(ConstraintType type, ToIntFunction<T> lengthGetter, Integer value) {
        super(type, value);
        this.lengthGetter = lengthGetter;
    }

    @Override
    public boolean test(T value) {
        switch (this.getType()) {
            case MINIMUM_LENGTH: {
                return this.lengthGetter.applyAsInt(value) >= (Integer)this.getValue();
            }
            case MAXIMUM_LENGTH: {
                return this.lengthGetter.applyAsInt(value) <= (Integer)this.getValue();
            }
        }
        throw new RuntimeFiberException("A StringLengthConstraint must be of type " + (Object)((Object)ConstraintType.MINIMUM_LENGTH) + " or " + (Object)((Object)ConstraintType.MAXIMUM_LENGTH));
    }
}

