/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.zeroeightsix.fiber.NodeOperations;
import me.zeroeightsix.fiber.annotation.Listener;
import me.zeroeightsix.fiber.annotation.Setting;
import me.zeroeightsix.fiber.annotation.Settings;
import me.zeroeightsix.fiber.annotation.convention.NoNamingConvention;
import me.zeroeightsix.fiber.annotation.convention.SettingNamingConvention;
import me.zeroeightsix.fiber.annotation.exception.MalformedFieldException;
import me.zeroeightsix.fiber.annotation.magic.TypeMagic;
import me.zeroeightsix.fiber.builder.ConfigValueBuilder;
import me.zeroeightsix.fiber.builder.constraint.AbstractConstraintsBuilder;
import me.zeroeightsix.fiber.builder.constraint.ConstraintsBuilder;
import me.zeroeightsix.fiber.exception.FiberException;
import me.zeroeightsix.fiber.tree.ConfigNode;
import me.zeroeightsix.fiber.tree.Node;
import me.zeroeightsix.fiber.tree.TreeItem;

public class AnnotatedSettings {
    public static <P> ConfigNode asNode(P pojo) throws FiberException {
        return AnnotatedSettings.asNode(pojo, ConfigNode::new);
    }

    public static <N extends Node, P> N asNode(P pojo, Supplier<N> nodeSupplier) throws FiberException {
        Node node = (Node)nodeSupplier.get();
        AnnotatedSettings.applyToNode(node, pojo);
        return (N)node;
    }

    public static <P> void applyToNode(Node mergeTo, P pojo) throws FiberException {
        SettingNamingConvention convention;
        boolean onlyAnnotated;
        Class<?> pojoClass = pojo.getClass();
        if (pojoClass.isAnnotationPresent(Settings.class)) {
            Settings settingsAnnotation = pojoClass.getAnnotation(Settings.class);
            onlyAnnotated = settingsAnnotation.onlyAnnotated();
            convention = AnnotatedSettings.createConvention(settingsAnnotation.namingConvention());
        } else {
            onlyAnnotated = false;
            convention = new NoNamingConvention();
        }
        NodeOperations.mergeTo(AnnotatedSettings.constructNode(pojoClass, pojo, onlyAnnotated, convention), mergeTo);
    }

    private static <P> Node constructNode(Class<P> pojoClass, P pojo, boolean onlyAnnotated, SettingNamingConvention convention) throws FiberException {
        ConfigNode node = new ConfigNode();
        ArrayList defaultEmpty = new ArrayList();
        Map<String, List<Member>> listenerMap = AnnotatedSettings.findListeners(pojoClass);
        for (Field field : pojoClass.getDeclaredFields()) {
            if (field.isSynthetic() || !AnnotatedSettings.isIncluded(field, onlyAnnotated)) continue;
            AnnotatedSettings.checkViolation(field);
            String name = AnnotatedSettings.findName(field, convention);
            if (field.isAnnotationPresent(Setting.Node.class)) {
                Node sub = node.fork(name);
                try {
                    boolean accesssible = field.isAccessible();
                    field.setAccessible(true);
                    AnnotatedSettings.applyToNode(sub, field.get(pojo));
                    field.setAccessible(accesssible);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new FiberException("Couldn't fork and apply sub-node", e);
                }
            }
            node.add(AnnotatedSettings.fieldToItem(field, pojo, name, listenerMap.getOrDefault(name, defaultEmpty)));
        }
        return node;
    }

    private static Map<String, List<Member>> findListeners(Class<?> pojoClass) {
        return Stream.concat(Arrays.stream(pojoClass.getDeclaredFields()), Arrays.stream(pojoClass.getDeclaredMethods())).filter(accessibleObject -> accessibleObject.isAnnotationPresent(Listener.class)).collect(Collectors.groupingBy(accessibleObject -> ((AccessibleObject)((Object)accessibleObject)).getAnnotation(Listener.class).value()));
    }

    private static boolean isIncluded(Field field, boolean onlyAnnotated) {
        if (AnnotatedSettings.isIgnored(field)) {
            return false;
        }
        return !onlyAnnotated || field.isAnnotationPresent(Setting.class);
    }

    private static boolean isIgnored(Field field) {
        return AnnotatedSettings.getSettingAnnotation(field).map(Setting::ignore).orElse(false) != false || Modifier.isTransient(field.getModifiers());
    }

    private static void checkViolation(Field field) throws FiberException {
        if (Modifier.isFinal(field.getModifiers())) {
            throw new FiberException("Field '" + field.getName() + "' can not be final");
        }
    }

    private static Optional<Setting> getSettingAnnotation(Field field) {
        return field.isAnnotationPresent(Setting.class) ? Optional.of(field.getAnnotation(Setting.class)) : Optional.empty();
    }

    private static <T, P> TreeItem fieldToItem(Field field, P pojo, String name, List<Member> listeners) throws FiberException {
        Class<T> type = AnnotatedSettings.getSettingTypeFromField(field);
        Object builder = ((ConfigValueBuilder)((ConfigValueBuilder)((ConfigValueBuilder)AnnotatedSettings.createConfigValueBuilder(type, field).withName(name)).withComment(AnnotatedSettings.findComment(field))).withDefaultValue(AnnotatedSettings.findDefaultValue(field, pojo))).setFinal(AnnotatedSettings.getSettingAnnotation(field).map(Setting::constant).orElse(false));
        AnnotatedSettings.constrain(((ConfigValueBuilder)builder).constraints(), field.getAnnotatedType()).finish();
        for (Member listener : listeners) {
            BiConsumer<T, T> consumer = AnnotatedSettings.constructListener(listener, pojo, type);
            if (consumer == null) continue;
            ((ConfigValueBuilder)builder).withListener(consumer);
        }
        ((ConfigValueBuilder)builder).withListener((t, newValue) -> {
            try {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                field.set(pojo, newValue);
                field.setAccessible(accessible);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        return ((ConfigValueBuilder)builder).build();
    }

    @Nonnull
    private static <T, E> ConfigValueBuilder<T, ?> createConfigValueBuilder(Class<T> type, Field field) {
        AnnotatedType annotatedType = field.getAnnotatedType();
        if (ConfigValueBuilder.isAggregate(type)) {
            if (Collection.class.isAssignableFrom(type)) {
                AnnotatedType typeArg;
                Class<?> componentType;
                AnnotatedType[] typeArgs;
                if (annotatedType instanceof AnnotatedParameterizedType && (typeArgs = ((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments()).length == 1 && (componentType = TypeMagic.classForType((typeArg = typeArgs[0]).getType())) != null) {
                    Class<E[]> collectionType = type;
                    ConfigValueBuilder.Aggregate<E[], ?> aggregate = ConfigValueBuilder.aggregate(collectionType, componentType);
                    AnnotatedSettings.constrain(((ConstraintsBuilder.Aggregate)aggregate.constraints()).component(), typeArg).finishComponent().finish();
                    return aggregate;
                }
            } else {
                assert (type.isArray());
                if (annotatedType instanceof AnnotatedArrayType) {
                    Class<E[]> arrayType = type;
                    ConfigValueBuilder.Aggregate aggregate = ConfigValueBuilder.aggregate(arrayType);
                    AnnotatedSettings.constrain(((ConstraintsBuilder.Aggregate)aggregate.constraints()).component(), ((AnnotatedArrayType)annotatedType).getAnnotatedGenericComponentType()).finishComponent().finish();
                    return aggregate;
                }
            }
        }
        return ConfigValueBuilder.scalar(type);
    }

    private static <T, B extends AbstractConstraintsBuilder<?, ?, T, ?>> B constrain(B constraints, AnnotatedElement field) {
        Annotation annotation;
        if (field.isAnnotationPresent(Setting.Constrain.Range.class)) {
            annotation = field.getAnnotation(Setting.Constrain.Range.class);
            if (annotation.min() > Double.NEGATIVE_INFINITY) {
                constraints.atLeast(annotation.min());
            }
            if (annotation.max() < Double.POSITIVE_INFINITY) {
                constraints.atMost(annotation.max());
            }
        }
        if (field.isAnnotationPresent(Setting.Constrain.BigRange.class)) {
            annotation = field.getAnnotation(Setting.Constrain.BigRange.class);
            if (!annotation.min().isEmpty()) {
                constraints.atLeast((BigDecimal)new BigDecimal(annotation.min()));
            }
            if (!annotation.max().isEmpty()) {
                constraints.atMost((BigDecimal)new BigDecimal(annotation.max()));
            }
        }
        if (field.isAnnotationPresent(Setting.Constrain.MinLength.class)) {
            constraints.minLength(field.getAnnotation(Setting.Constrain.MinLength.class).value());
        }
        if (field.isAnnotationPresent(Setting.Constrain.MaxLength.class)) {
            constraints.maxLength(field.getAnnotation(Setting.Constrain.MaxLength.class).value());
        }
        if (field.isAnnotationPresent(Setting.Constrain.Regex.class)) {
            constraints.regex(field.getAnnotation(Setting.Constrain.Regex.class).value());
        }
        return constraints;
    }

    private static <T, P> T findDefaultValue(Field field, P pojo) throws FiberException {
        Object value;
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            value = field.get(pojo);
        }
        catch (IllegalAccessException e) {
            throw new FiberException("Couldn't get value for field '" + field.getName() + "'", e);
        }
        field.setAccessible(accessible);
        return (T)value;
    }

    private static <T, P, A> BiConsumer<T, T> constructListener(Member listener, P pojo, Class<A> wantedType) throws FiberException {
        if (listener instanceof Field) {
            return AnnotatedSettings.constructListenerFromField((Field)listener, pojo, wantedType);
        }
        if (listener instanceof Method) {
            return AnnotatedSettings.constructListenerFromMethod((Method)listener, pojo, wantedType);
        }
        throw new FiberException("Cannot create listener from " + listener + ": must be a field or method");
    }

    private static <T, P, A> BiConsumer<T, T> constructListenerFromMethod(Method method, P pojo, Class<A> wantedType) throws FiberException {
        int i = AnnotatedSettings.checkListenerMethod(method, wantedType);
        method.setAccessible(true);
        boolean staticMethod = Modifier.isStatic(method.getModifiers());
        switch (i) {
            case 1: {
                return (oldValue, newValue) -> {
                    try {
                        method.invoke(staticMethod ? null : pojo, newValue);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                };
            }
            case 2: {
                return (oldValue, newValue) -> {
                    try {
                        method.invoke(staticMethod ? null : pojo, oldValue, newValue);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                };
            }
        }
        throw new FiberException("Listener failed due to an invalid number of arguments.");
    }

    private static <A> int checkListenerMethod(Method method, Class<A> wantedType) throws FiberException {
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new FiberException("Listener method must return void");
        }
        int paramCount = method.getParameterCount();
        if (paramCount != 1 && paramCount != 2 || !method.getParameterTypes()[0].equals(wantedType)) {
            throw new FiberException("Listener method must have exactly two parameters of type that it listens for");
        }
        return paramCount;
    }

    private static <T, P, A> BiConsumer<T, T> constructListenerFromField(Field field, P pojo, Class<A> wantedType) throws FiberException {
        BiConsumer consumer;
        AnnotatedSettings.checkListenerField(field, wantedType);
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        try {
            BiConsumer biConsumer = consumer = (BiConsumer)field.get(pojo);
        }
        catch (IllegalAccessException e) {
            throw new FiberException("Couldn't construct listener", e);
        }
        field.setAccessible(isAccessible);
        return consumer;
    }

    private static <A> void checkListenerField(Field field, Class<A> wantedType) throws MalformedFieldException {
        if (!field.getType().equals(BiConsumer.class)) {
            throw new MalformedFieldException("Field " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must be a BiConsumer");
        }
        ParameterizedType genericTypes = (ParameterizedType)field.getGenericType();
        if (genericTypes.getActualTypeArguments().length != 2) {
            throw new MalformedFieldException("Listener " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have 2 generic types");
        }
        if (genericTypes.getActualTypeArguments()[0] != genericTypes.getActualTypeArguments()[1]) {
            throw new MalformedFieldException("Listener " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have 2 identical generic types");
        }
        if (!genericTypes.getActualTypeArguments()[0].equals(wantedType)) {
            throw new MalformedFieldException("Listener " + field.getDeclaringClass().getCanonicalName() + "#" + field.getName() + " must have the same generic type as the field it's listening for");
        }
    }

    private static <T> Class<T> getSettingTypeFromField(Field field) {
        Class<?> type = field.getType();
        return AnnotatedSettings.wrapPrimitive(type);
    }

    public static <T> Class<T> wrapPrimitive(Class<T> type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        return type;
    }

    private static String findComment(Field field) {
        return AnnotatedSettings.getSettingAnnotation(field).map(Setting::comment).filter(s -> !s.isEmpty()).orElse(null);
    }

    private static String findName(Field field, SettingNamingConvention convention) {
        return Optional.ofNullable(field.isAnnotationPresent(Setting.Node.class) ? field.getAnnotation(Setting.Node.class).name() : (String)AnnotatedSettings.getSettingAnnotation(field).map(Setting::name).orElse(null)).filter(s -> !s.isEmpty()).orElse(convention.name(field.getName()));
    }

    private static SettingNamingConvention createConvention(Class<? extends SettingNamingConvention> namingConvention) throws FiberException {
        try {
            return namingConvention.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FiberException("Could not initialise naming convention", e);
        }
    }
}

