/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder.constraint;

import java.util.List;
import me.zeroeightsix.fiber.builder.constraint.ComponentConstraintsBuilder;
import me.zeroeightsix.fiber.builder.constraint.CompositeConstraintsBuilder;
import me.zeroeightsix.fiber.builder.constraint.ConstraintsBuilder;
import me.zeroeightsix.fiber.constraint.CompositeType;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;

public class AggregateConstraintsBuilder<S, T, C>
extends ConstraintsBuilder<S, T> {
    private final Class<C> componentType;

    public AggregateConstraintsBuilder(S source, List<Constraint<? super T>> constraints, Class<T> aggregateType, Class<C> componentType) {
        super(source, constraints, aggregateType);
        this.componentType = componentType;
    }

    @Override
    public AggregateConstraintsBuilder<S, T, C> atLeast(T min) throws RuntimeFiberException {
        super.atLeast((Object)min);
        return this;
    }

    @Override
    public AggregateConstraintsBuilder<S, T, C> atMost(T max) {
        super.atMost((Object)max);
        return this;
    }

    @Override
    public AggregateConstraintsBuilder<S, T, C> range(T min, T max) {
        super.range((Object)min, (Object)max);
        return this;
    }

    @Override
    public AggregateConstraintsBuilder<S, T, C> minLength(int min) {
        super.minLength(min);
        return this;
    }

    @Override
    public AggregateConstraintsBuilder<S, T, C> maxLength(int max) {
        super.maxLength(max);
        return this;
    }

    @Override
    public AggregateConstraintsBuilder<S, T, C> regex(String regexPattern) {
        super.regex(regexPattern);
        return this;
    }

    @Override
    public CompositeConstraintsBuilder<AggregateConstraintsBuilder<S, T, C>, T> composite(CompositeType type) {
        return new CompositeConstraintsBuilder(this, type, this.sourceConstraints, this.type);
    }

    public ComponentConstraintsBuilder<AggregateConstraintsBuilder<S, T, C>, T, C> component() {
        if (this.type.isArray()) {
            List sourceConstraints = this.sourceConstraints;
            return ComponentConstraintsBuilder.array(this, sourceConstraints, this.componentType);
        }
        List sourceConstraints = this.sourceConstraints;
        return ComponentConstraintsBuilder.collection(this, sourceConstraints, this.componentType);
    }
}

