/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.tree;

import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.builder.ConfigAggregateBuilder;
import me.zeroeightsix.fiber.builder.ConfigValueBuilder;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.tree.ConfigLeaf;
import me.zeroeightsix.fiber.tree.Property;

public class ConfigValue<T>
extends ConfigLeaf
implements Property<T> {
    @Nullable
    private T value;
    @Nullable
    private T defaultValue;
    @Nonnull
    private final BiConsumer<T, T> consumer;
    @Nonnull
    private final List<Constraint<? super T>> constraintList;
    @Nonnull
    private final Class<T> type;
    private final Predicate<T> restriction;

    public ConfigValue(@Nullable String name, @Nullable String comment, @Nullable T value, @Nullable T defaultValue, @Nonnull BiConsumer<T, T> consumer, @Nonnull List<Constraint<? super T>> constraintList, @Nonnull Class<T> type, boolean isFinal) {
        super(name, comment);
        this.value = value;
        this.defaultValue = defaultValue;
        this.consumer = consumer;
        this.constraintList = constraintList;
        this.type = type;
        this.restriction = isFinal ? t -> false : t -> constraintList.stream().allMatch(constraint -> constraint.test(t));
    }

    @Override
    @Nullable
    public T getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean setValue(@Nullable T value) {
        if (!this.restriction.test(value)) {
            return false;
        }
        T oldValue = this.value;
        this.value = value;
        this.consumer.accept(oldValue, value);
        return true;
    }

    @Nonnull
    public BiConsumer<T, T> getListener() {
        return this.consumer;
    }

    @Nullable
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Nonnull
    public List<Constraint<? super T>> getConstraints() {
        return this.constraintList;
    }

    public static <T> ConfigValueBuilder<T> builder(@Nonnull Class<T> type) {
        return new ConfigValueBuilder<T>(type);
    }

    public static <T> ConfigValueBuilder<T> builder(@Nonnull T defaultValue) {
        Class<?> type = defaultValue.getClass();
        return new ConfigValueBuilder(type).withDefaultValue(defaultValue);
    }

    public static <E> ConfigAggregateBuilder<E[], E> builder(@Nonnull E[] defaultValue) {
        Class<E[]> type = defaultValue.getClass();
        return ConfigAggregateBuilder.create(type).withDefaultValue(defaultValue);
    }

    public static <C extends Collection<E>, E> ConfigAggregateBuilder<C, E> builder(@Nonnull C defaultValue, Class<E> elementType) {
        Class<?> type = defaultValue.getClass();
        return ConfigAggregateBuilder.create(type, elementType).withDefaultValue(defaultValue);
    }
}

