/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber;

import java.util.Map;
import java.util.stream.Collectors;
import me.zeroeightsix.fiber.tree.ConfigValue;
import me.zeroeightsix.fiber.tree.Node;
import me.zeroeightsix.fiber.tree.Property;
import me.zeroeightsix.fiber.tree.TreeItem;

public class NodeOperations {
    public static void mergeTo(Node from, Node to) {
        Map<String, TreeItem> map = to.getItems().stream().collect(Collectors.toMap(TreeItem::getName, item -> item));
        from.getItems().forEach(item -> {
            String name = item.getName();
            map.put(name, (TreeItem)item);
        });
        to.getItems().clear();
        to.getItems().addAll(map.values());
    }

    public static void mergeTo(ConfigValue<?> value, Node to) {
        to.remove(value.getName());
        to.getItems().add(value);
    }

    public static <T> void mergeTo(Property<T> from, Property<T> to) {
        to.setValue(from.getValue());
    }
}

