/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.tree;

import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.exception.FiberException;
import me.zeroeightsix.fiber.tree.ConfigNode;
import me.zeroeightsix.fiber.tree.TreeItem;

public interface Node
extends TreeItem {
    @Nonnull
    public Set<TreeItem> getItems();

    default public boolean isSerializedSeparately() {
        return false;
    }

    @Nullable
    default public TreeItem lookup(String name) {
        return this.getItems().stream().filter(treeItem -> treeItem.getName().equals(name)).findFirst().orElse(null);
    }

    default public TreeItem add(@Nonnull TreeItem item) throws FiberException {
        TreeItem existing = this.lookup(item.getName());
        if (existing != null) {
            throw new FiberException("Attempt to replace node " + existing.getName());
        }
        this.getItems().add(item);
        return item;
    }

    default public TreeItem remove(String name) {
        Optional<TreeItem> itemOptional = this.getItems().stream().filter(item -> item.getName().equals(name)).findAny();
        if (!itemOptional.isPresent()) {
            return null;
        }
        TreeItem item2 = itemOptional.get();
        this.getItems().remove(item2);
        return item2;
    }

    default public Node fork(String name) throws FiberException {
        return this.fork(name, false);
    }

    default public Node fork(String name, boolean serializeSeparately) throws FiberException {
        return (Node)this.add(new ConfigNode(name, null, serializeSeparately));
    }
}

