/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder.constraint;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import me.zeroeightsix.fiber.builder.constraint.AbstractConstraintsBuilder;
import me.zeroeightsix.fiber.constraint.Constraint;
import me.zeroeightsix.fiber.constraint.ConstraintType;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;

public final class ComponentConstraintsBuilder<S, A, T>
extends AbstractConstraintsBuilder<S, A, T> {
    private final Function<List<Constraint<? super T>>, Constraint<? super A>> collector;

    public static <S, T> ComponentConstraintsBuilder<S, T[], T> array(S source, List<Constraint<? super T[]>> sourceConstraints, Class<T> type) {
        return new ComponentConstraintsBuilder(source, sourceConstraints, type, ArrayComponentConstraint::new);
    }

    public static <S, T, C extends Collection<T>> ComponentConstraintsBuilder<S, C, T> collection(S source, List<Constraint<? super C>> sourceConstraints, Class<T> type) {
        return new ComponentConstraintsBuilder(source, sourceConstraints, type, CollectionComponentConstraint::new);
    }

    private ComponentConstraintsBuilder(S source, List<Constraint<? super A>> sourceConstraints, Class<T> type, Function<List<Constraint<? super T>>, Constraint<? super A>> collector) {
        super(source, sourceConstraints, type);
        this.collector = collector;
    }

    @Override
    public ComponentConstraintsBuilder<S, A, T> atLeast(T min) throws RuntimeFiberException {
        super.atLeast(min);
        return this;
    }

    @Override
    public ComponentConstraintsBuilder<S, A, T> atMost(T max) {
        super.atMost(max);
        return this;
    }

    @Override
    public ComponentConstraintsBuilder<S, A, T> range(T min, T max) {
        super.range(min, max);
        return this;
    }

    @Override
    public ComponentConstraintsBuilder<S, A, T> minLength(int min) {
        super.minLength(min);
        return this;
    }

    @Override
    public ComponentConstraintsBuilder<S, A, T> maxLength(int max) {
        super.maxLength(max);
        return this;
    }

    @Override
    public ComponentConstraintsBuilder<S, A, T> regex(String regexPattern) {
        super.regex(regexPattern);
        return this;
    }

    public S finishComponent() {
        this.sourceConstraints.add(this.collector.apply(this.newConstraints));
        return (S)this.source;
    }

    private static class CollectionComponentConstraint<T>
    extends ComponentConstraint<Iterable<T>, T> {
        public CollectionComponentConstraint(List<Constraint<? super T>> constraints) {
            super(constraints);
        }

        @Override
        protected boolean allMatch(Constraint<? super T> constraint, Iterable<T> value) {
            for (T t : value) {
                if (constraint.test(t)) continue;
                return false;
            }
            return true;
        }
    }

    private static class ArrayComponentConstraint<A, T>
    extends ComponentConstraint<A, T> {
        ArrayComponentConstraint(List<Constraint<? super T>> constraints) {
            super(constraints);
        }

        @Override
        protected boolean allMatch(Constraint<? super T> constraint, A value) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object t = Array.get(value, i);
                if (constraint.test(t)) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class ComponentConstraint<A, T>
    extends Constraint<A> {
        private final List<Constraint<? super T>> constraints;

        ComponentConstraint(List<Constraint<? super T>> constraints) {
            super(ConstraintType.COMPONENTS_MATCH);
            this.constraints = constraints;
        }

        @Override
        public boolean test(A value) {
            for (Constraint<? super T> constraint : this.constraints) {
                if (this.allMatch(constraint, value)) continue;
                return false;
            }
            return true;
        }

        protected abstract boolean allMatch(Constraint<? super T> var1, A var2);
    }
}

