/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder;

import java.util.Collection;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import me.zeroeightsix.fiber.annotation.AnnotatedSettings;
import me.zeroeightsix.fiber.builder.ConfigNodeBuilder;
import me.zeroeightsix.fiber.builder.ConfigValueBuilder;
import me.zeroeightsix.fiber.builder.constraint.AggregateConstraintsBuilder;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;

public final class ConfigAggregateBuilder<A, E>
extends ConfigValueBuilder<A> {
    @Nonnull
    private final Class<E> componentType;

    public static boolean isAggregate(Class<?> type) {
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    public static <E> ConfigAggregateBuilder<E[], E> create(@Nonnull String name, @Nonnull Class<E[]> arrayType) {
        if (!arrayType.isArray()) {
            throw new RuntimeFiberException(arrayType + " is not a valid array type");
        }
        return new ConfigAggregateBuilder(name, arrayType, AnnotatedSettings.wrapPrimitive(arrayType.getComponentType()));
    }

    public static <C extends Collection<E>, E> ConfigAggregateBuilder<C, E> create(@Nonnull String name, @Nonnull Class<? super C> collectionType, @Nonnull Class<E> componentType) {
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new RuntimeFiberException(collectionType + " is not a valid Collection type");
        }
        return new ConfigAggregateBuilder<C, E>(name, collectionType, componentType);
    }

    private ConfigAggregateBuilder(@Nonnull String name, @Nonnull Class<A> type, @Nonnull Class<E> componentType) {
        super(name, type);
        this.componentType = componentType;
    }

    public ConfigAggregateBuilder<A, E> withName(String name) {
        super.withName(name);
        return this;
    }

    public ConfigAggregateBuilder<A, E> withComment(String comment) {
        super.withComment(comment);
        return this;
    }

    public ConfigAggregateBuilder<A, E> withListener(BiConsumer<A, A> consumer) {
        super.withListener(consumer);
        return this;
    }

    public ConfigAggregateBuilder<A, E> withDefaultValue(A defaultValue) {
        super.withDefaultValue(defaultValue);
        return this;
    }

    public ConfigAggregateBuilder<A, E> setFinal() {
        super.setFinal();
        return this;
    }

    public ConfigAggregateBuilder<A, E> setFinal(boolean isFinal) {
        super.setFinal(isFinal);
        return this;
    }

    public ConfigAggregateBuilder<A, E> withParent(ConfigNodeBuilder node) {
        super.withParent(node);
        return this;
    }

    public AggregateConstraintsBuilder<ConfigAggregateBuilder<A, E>, A, E> constraints() {
        return new AggregateConstraintsBuilder(this, this.constraintList, this.type, this.componentType);
    }
}

