/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.annotation.AnnotatedSettings;
import me.zeroeightsix.fiber.exception.FiberException;
import me.zeroeightsix.fiber.exception.RuntimeFiberException;
import me.zeroeightsix.fiber.tree.ConfigNode;
import me.zeroeightsix.fiber.tree.NodeLike;
import me.zeroeightsix.fiber.tree.TreeItem;

public class ConfigNodeBuilder
implements NodeLike {
    private final Map<String, TreeItem> items = new HashMap<String, TreeItem>();
    @Nullable
    protected ConfigNodeBuilder parent = null;
    @Nullable
    protected String name = null;
    @Nullable
    private String comment;
    private boolean serializeSeparately;
    private ConfigNode built;

    @Override
    @Nonnull
    public Collection<TreeItem> getItems() {
        return this.items.values();
    }

    @Override
    @Nullable
    public TreeItem lookup(String name) {
        return this.items.get(name);
    }

    public ConfigNodeBuilder withParent(ConfigNodeBuilder parent) {
        if (this.name == null && parent != null) {
            throw new IllegalStateException("A child node needs a name");
        }
        this.parent = parent;
        return this;
    }

    public ConfigNodeBuilder withName(String name) {
        if (name == null && this.parent != null) {
            throw new IllegalStateException("Cannot remove the name from a child node");
        }
        this.name = name;
        return this;
    }

    public ConfigNodeBuilder withComment(@Nullable String comment) {
        this.comment = comment;
        return this;
    }

    public ConfigNodeBuilder withSeparateSerialization() {
        this.withSeparateSerialization(true);
        return this;
    }

    public ConfigNodeBuilder withSeparateSerialization(boolean serializeSeparately) {
        this.serializeSeparately = serializeSeparately;
        return this;
    }

    public ConfigNodeBuilder applyFromPojo(Object pojo) throws FiberException {
        AnnotatedSettings.applyToNode(this, pojo);
        return this;
    }

    public ConfigNodeBuilder add(@Nonnull TreeItem item) throws FiberException {
        this.add(item, false);
        return this;
    }

    public ConfigNodeBuilder add(@Nonnull TreeItem item, boolean overwrite) throws FiberException {
        if (!overwrite && this.items.containsKey(item.getName())) {
            throw new FiberException("Attempt to replace node " + item.getName());
        }
        this.items.put(item.getName(), item);
        return this;
    }

    public TreeItem remove(String name) {
        return this.items.remove(name);
    }

    public Forked<? extends ConfigNodeBuilder> fork(String name) {
        return new Forked<ConfigNodeBuilder>(this, name);
    }

    public ConfigNode build() {
        if (this.built != null) {
            throw new IllegalStateException("Cannot build a node more than once");
        }
        this.built = new ConfigNode(this.name, this.comment, this.items.values(), this.serializeSeparately);
        if (this.parent != null) {
            assert (this.name != null);
            try {
                this.parent.add(this.built);
            }
            catch (FiberException e) {
                throw new RuntimeFiberException("Failed to attach built node to parent", e);
            }
        }
        return this.built;
    }

    public static class Forked<S extends ConfigNodeBuilder>
    extends ConfigNodeBuilder {
        private final S source;

        public Forked(S parent, String name) {
            if (parent == null) {
                throw new NullPointerException();
            }
            if (name == null) {
                throw new NullPointerException();
            }
            this.source = parent;
            this.parent = parent;
            this.name = name;
        }

        @Override
        public Forked<S> withParent(ConfigNodeBuilder parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Forked<S> withName(String name) {
            super.withName(name);
            return this;
        }

        @Override
        public Forked<S> withComment(@Nullable String comment) {
            super.withComment(comment);
            return this;
        }

        @Override
        public Forked<S> withSeparateSerialization() {
            super.withSeparateSerialization();
            return this;
        }

        @Override
        public Forked<S> withSeparateSerialization(boolean serializeSeparately) {
            super.withSeparateSerialization(serializeSeparately);
            return this;
        }

        @Override
        public Forked<S> add(@Nonnull TreeItem item) throws FiberException {
            super.add(item);
            return this;
        }

        @Override
        public Forked<S> add(@Nonnull TreeItem item, boolean overwrite) throws FiberException {
            super.add(item, overwrite);
            return this;
        }

        public Forked<Forked<S>> fork(String name) {
            return new Forked<Forked<S>>(this, name);
        }

        public S finishNode() {
            return this.finishNode(n -> {});
        }

        public S finishNode(Consumer<ConfigNode> action) {
            action.accept(this.build());
            return this.source;
        }
    }
}

