/*
 * Decompiled with CFR 0.152.
 */
package me.zeroeightsix.fiber.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.zeroeightsix.fiber.tree.ConfigLeaf;
import me.zeroeightsix.fiber.tree.Node;
import me.zeroeightsix.fiber.tree.TreeItem;

public class ConfigNode
extends ConfigLeaf
implements Node {
    private final SortedMap<String, TreeItem> indexedItems;
    private final SortedSet<TreeItem> items;
    private final boolean serializeSeparately;

    public ConfigNode(@Nonnull String name, @Nullable String comment, @Nonnull Collection<TreeItem> items, boolean serializeSeparately) {
        super(name, comment);
        TreeSet<TreeItem> copy = new TreeSet<TreeItem>(Comparator.comparing(TreeItem::getName));
        TreeMap<String, TreeItem> indexedItems = new TreeMap<String, TreeItem>();
        for (TreeItem item : items) {
            indexedItems.put(item.getName(), item);
            boolean added = copy.add(item);
            if (added) continue;
            throw new IllegalArgumentException(items + " has multiple items with the same name (" + item.getName() + ")");
        }
        this.items = Collections.unmodifiableSortedSet(copy);
        this.indexedItems = Collections.unmodifiableSortedMap(indexedItems);
        this.serializeSeparately = serializeSeparately;
    }

    public ConfigNode(@Nonnull String name, @Nullable String comment) {
        this(name, comment, new HashSet<TreeItem>(), false);
    }

    public ConfigNode() {
        this(null, null);
    }

    @Override
    @Nonnull
    public Set<TreeItem> getItems() {
        return this.items;
    }

    @Override
    @Nullable
    public TreeItem lookup(String name) {
        return (TreeItem)this.indexedItems.get(name);
    }

    @Override
    public boolean isSerializedSeparately() {
        return this.serializeSeparately;
    }
}

